/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.client.transaction.lock.BaseZookeeperBasedLockProvider;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.storage.StorageConfiguration;

@NotThreadSafe
public class ZookeeperBasedLockProvider
extends BaseZookeeperBasedLockProvider {
    public ZookeeperBasedLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf) {
        super(lockConfiguration, conf);
    }

    @Override
    protected String getZkBasePath(LockConfiguration lockConfiguration) {
        ValidationUtils.checkArgument(ConfigUtils.getStringWithAltKeys(lockConfiguration.getConfig(), HoodieLockConfig.ZK_BASE_PATH) != null);
        return lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.base_path");
    }

    @Override
    protected String getLockKey(LockConfiguration lockConfiguration) {
        ValidationUtils.checkArgument(ConfigUtils.getStringWithAltKeys(lockConfiguration.getConfig(), HoodieLockConfig.ZK_LOCK_KEY) != null);
        return this.lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.lock_key");
    }
}

