/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hudi.async.AsyncArchiveService;
import org.apache.hudi.async.AsyncCleanerService;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.client.BaseHoodieClient;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieTableServiceManagerClient;
import org.apache.hudi.client.RunsTableService;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.client.timeline.HoodieTimelineArchiver;
import org.apache.hudi.client.timeline.TimelineArchivers;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieLogCompactException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.CompactHelpers;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.util.CommonClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieTableServiceClient<I, T, O>
extends BaseHoodieClient
implements RunsTableService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieTableServiceClient.class);
    protected transient Timer.Context compactionTimer;
    protected transient Timer.Context clusteringTimer;
    protected transient Timer.Context logCompactionTimer;
    protected transient AsyncCleanerService asyncCleanerService;
    protected transient AsyncArchiveService asyncArchiveService;
    protected Set<String> pendingInflightAndRequestedInstants;

    protected BaseHoodieTableServiceClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, clientConfig, timelineService);
    }

    protected void startAsyncCleanerService(BaseHoodieWriteClient writeClient) {
        if (this.asyncCleanerService == null) {
            this.asyncCleanerService = AsyncCleanerService.startAsyncCleaningIfEnabled(writeClient);
        } else {
            this.asyncCleanerService.start(null);
        }
    }

    protected void startAsyncArchiveService(BaseHoodieWriteClient writeClient) {
        if (this.asyncArchiveService == null) {
            this.asyncArchiveService = AsyncArchiveService.startAsyncArchiveIfEnabled(writeClient);
        } else {
            this.asyncArchiveService.start(null);
        }
    }

    protected void asyncClean() {
        AsyncCleanerService.waitForCompletion(this.asyncCleanerService);
    }

    protected void asyncArchive() {
        AsyncArchiveService.waitForCompletion(this.asyncArchiveService);
    }

    protected void setTableServiceTimer(WriteOperationType operationType) {
        switch (operationType) {
            case CLUSTER: {
                this.clusteringTimer = this.metrics.getClusteringCtx();
                break;
            }
            case COMPACT: {
                this.compactionTimer = this.metrics.getCompactionCtx();
                break;
            }
            case LOG_COMPACT: {
                this.logCompactionTimer = this.metrics.getLogCompactionCtx();
                break;
            }
        }
    }

    protected void setPendingInflightAndRequestedInstants(Set<String> pendingInflightAndRequestedInstants) {
        this.pendingInflightAndRequestedInstants = pendingInflightAndRequestedInstants;
    }

    protected void preCommit(HoodieCommitMetadata metadata) {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.storageConf);
        this.resolveWriteConflict(table, metadata, this.pendingInflightAndRequestedInstants);
    }

    protected Option<String> inlineCompaction(Option<Map<String, String>> extraMetadata) {
        Option<String> compactionInstantTimeOpt = this.inlineScheduleCompaction(extraMetadata);
        compactionInstantTimeOpt.ifPresent(compactInstantTime -> this.compact((String)compactInstantTime, true));
        return compactionInstantTimeOpt;
    }

    private void inlineCompaction(HoodieTable table, Option<Map<String, String>> extraMetadata) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.compaction)) {
            this.scheduleCompaction(extraMetadata);
        } else {
            this.runAnyPendingCompactions(table);
            this.inlineCompaction(extraMetadata);
        }
    }

    protected HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime, boolean shouldComplete) {
        InstantGenerator instantGenerator;
        HoodieInstant inflightInstant;
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getStorageConf());
        Set<String> actions = CollectionUtils.createSet("commit", "compaction");
        Option<HoodieInstant> compactionInstantWithGreaterTimestamp = Option.fromJavaOptional(table.getActiveTimeline().getInstantsAsStream().filter(hoodieInstant -> actions.contains(hoodieInstant.getAction())).filter(hoodieInstant -> InstantComparison.compareTimestamps(hoodieInstant.requestedTime(), InstantComparison.GREATER_THAN, logCompactionInstantTime)).findFirst());
        if (compactionInstantWithGreaterTimestamp.isPresent()) {
            throw new HoodieLogCompactException(String.format("Cannot log compact since a compaction instant with greater timestamp exists. Instant details %s", compactionInstantWithGreaterTimestamp.get()));
        }
        HoodieTimeline pendingLogCompactionTimeline = table.getActiveTimeline().filterPendingLogCompactionTimeline();
        if (pendingLogCompactionTimeline.containsInstant(inflightInstant = (instantGenerator = table.getMetaClient().getInstantGenerator()).getLogCompactionInflightInstant(logCompactionInstantTime))) {
            LOG.info("Found Log compaction inflight file. Rolling back the commit and exiting.");
            table.rollbackInflightLogCompaction(inflightInstant, commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
            throw new HoodieException("Execution is aborted since it found an Inflight logcompaction,log compaction plans are mutable plans, so reschedule another logcompaction.");
        }
        this.logCompactionTimer = this.metrics.getLogCompactionCtx();
        WriteMarkersFactory.get(this.config.getMarkersType(), table, logCompactionInstantTime);
        HoodieWriteMetadata<T> writeMetadata = table.logCompact(this.context, logCompactionInstantTime);
        HoodieWriteMetadata<O> logCompactionMetadata = this.convertToOutputMetadata(writeMetadata);
        if (shouldComplete && logCompactionMetadata.getCommitMetadata().isPresent()) {
            this.completeLogCompaction(logCompactionMetadata.getCommitMetadata().get(), table, logCompactionInstantTime);
        }
        return logCompactionMetadata;
    }

    protected Option<String> inlineLogCompact(Option<Map<String, String>> extraMetadata) {
        Option<String> logCompactionInstantTimeOpt = this.scheduleLogCompaction(extraMetadata);
        logCompactionInstantTimeOpt.ifPresent(logCompactInstantTime -> this.logCompact((String)logCompactInstantTime, true));
        return logCompactionInstantTimeOpt;
    }

    protected void runAnyPendingCompactions(HoodieTable table) {
        table.getActiveTimeline().getWriteTimeline().filterPendingCompactionTimeline().getInstants().forEach(instant -> {
            LOG.info("Running previously failed inflight compaction at instant {}", instant);
            this.compact(instant.requestedTime(), true);
        });
    }

    protected void runAnyPendingLogCompactions(HoodieTable table) {
        table.getActiveTimeline().getWriteTimeline().filterPendingLogCompactionTimeline().getInstantsAsStream().forEach(instant -> {
            LOG.info("Running previously failed inflight log compaction at instant {}", instant);
            this.logCompact(instant.requestedTime(), true);
        });
    }

    protected Option<String> inlineScheduleCompaction(Option<Map<String, String>> extraMetadata) {
        return this.scheduleCompaction(extraMetadata);
    }

    public Option<String> scheduleCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = this.createNewInstantTime();
        return this.scheduleCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    protected HoodieWriteMetadata<O> compact(String compactionInstantTime, boolean shouldComplete) {
        InstantGenerator instantGenerator;
        HoodieInstant inflightInstant;
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getStorageConf());
        HoodieTimeline pendingCompactionTimeline = table.getActiveTimeline().filterPendingCompactionTimeline();
        if (pendingCompactionTimeline.containsInstant(inflightInstant = (instantGenerator = table.getMetaClient().getInstantGenerator()).getCompactionInflightInstant(compactionInstantTime))) {
            table.rollbackInflightCompaction(inflightInstant, commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
        }
        this.compactionTimer = this.metrics.getCompactionCtx();
        HoodieWriteMetadata<T> writeMetadata = table.compact(this.context, compactionInstantTime);
        HoodieWriteMetadata<O> compactionMetadata = this.convertToOutputMetadata(writeMetadata);
        if (shouldComplete && compactionMetadata.getCommitMetadata().isPresent()) {
            this.completeCompaction(compactionMetadata.getCommitMetadata().get(), table, compactionInstantTime);
        }
        return compactionMetadata;
    }

    public void commitCompaction(String compactionInstantTime, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        extraMetadata.ifPresent(m -> m.forEach(metadata::addMetadata));
        this.completeCompaction(metadata, this.createTable(this.config, this.context.getStorageConf()), compactionInstantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeCompaction(HoodieCommitMetadata metadata, HoodieTable table, String compactionCommitTime) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Collect compaction write status and commit compaction: " + this.config.getTableName());
        List<HoodieWriteStat> writeStats = metadata.getWriteStats();
        this.handleWriteErrors(writeStats, TableServiceType.COMPACT);
        InstantGenerator instantGenerator = table.getMetaClient().getInstantGenerator();
        HoodieInstant compactionInstant = instantGenerator.getCompactionInflightInstant(compactionCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of(compactionInstant), Option.empty());
            this.finalizeWrite(table, compactionCommitTime, writeStats);
            this.writeTableMetadata(table, compactionCommitTime, metadata);
            LOG.info("Committing Compaction {}", (Object)compactionCommitTime);
            LOG.debug("Compaction {} finished with result: {}", (Object)compactionCommitTime, (Object)metadata);
            CompactHelpers.getInstance().completeInflightCompaction(table, compactionCommitTime, metadata);
        }
        finally {
            this.txnManager.endTransaction(Option.of(compactionInstant));
            this.releaseResources(compactionCommitTime);
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, compactionCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.compactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.compactionTimer.stop());
            TimelineUtils.parseDateFromInstantTimeSafely(compactionCommitTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, "compaction"));
        }
        LOG.info("Compacted successfully on commit {}", (Object)compactionCommitTime);
    }

    public Option<String> scheduleLogCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = this.createNewInstantTime();
        return this.scheduleLogCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleLogCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.LOG_COMPACT).isPresent();
    }

    public HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime) {
        return this.logCompact(logCompactionInstantTime, this.config.shouldAutoCommit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeLogCompaction(HoodieCommitMetadata metadata, HoodieTable table, String logCompactionCommitTime) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Collect log compaction write status and commit compaction");
        List<HoodieWriteStat> writeStats = metadata.getWriteStats();
        this.handleWriteErrors(writeStats, TableServiceType.LOG_COMPACT);
        HoodieInstant logCompactionInstant = table.getMetaClient().createNewInstant(HoodieInstant.State.INFLIGHT, "logcompaction", logCompactionCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of(logCompactionInstant), Option.empty());
            this.preCommit(metadata);
            this.finalizeWrite(table, logCompactionCommitTime, writeStats);
            this.writeTableMetadata(table, logCompactionCommitTime, metadata);
            LOG.info("Committing Log Compaction {}", (Object)logCompactionCommitTime);
            LOG.debug("Log Compaction {} finished with result {}", (Object)logCompactionCommitTime, (Object)metadata);
            CompactHelpers.getInstance().completeInflightLogCompaction(table, logCompactionCommitTime, metadata);
        }
        finally {
            this.txnManager.endTransaction(Option.of(logCompactionInstant));
            this.releaseResources(logCompactionCommitTime);
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, logCompactionCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.logCompactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.logCompactionTimer.stop());
            TimelineUtils.parseDateFromInstantTimeSafely(logCompactionCommitTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, "logcompaction"));
        }
        LOG.info("Log Compacted successfully on commit {}", (Object)logCompactionCommitTime);
    }

    public boolean scheduleCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.COMPACT).isPresent();
    }

    public Option<String> scheduleClustering(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = this.createNewInstantTime();
        return this.scheduleClusteringAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleClusteringAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLUSTER).isPresent();
    }

    public HoodieWriteMetadata<O> cluster(String clusteringInstant, boolean shouldComplete) {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getStorageConf());
        HoodieTimeline pendingClusteringTimeline = table.getActiveTimeline().filterPendingReplaceOrClusteringTimeline();
        Option<HoodieInstant> inflightInstantOpt = ClusteringUtils.getInflightClusteringInstant(clusteringInstant, table.getActiveTimeline(), table.getMetaClient().getInstantGenerator());
        if (inflightInstantOpt.isPresent()) {
            if (pendingClusteringTimeline.isPendingClusteringInstant(inflightInstantOpt.get().requestedTime())) {
                table.rollbackInflightClustering(inflightInstantOpt.get(), commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
                table.getMetaClient().reloadActiveTimeline();
            } else {
                throw new HoodieClusteringException("Non clustering replace-commit inflight at timestamp " + clusteringInstant);
            }
        }
        this.clusteringTimer = this.metrics.getClusteringCtx();
        LOG.info("Starting clustering at {} for table {}", (Object)clusteringInstant, (Object)table.getConfig().getBasePath());
        HoodieWriteMetadata<T> writeMetadata = table.cluster(this.context, clusteringInstant);
        HoodieWriteMetadata<O> clusteringMetadata = this.convertToOutputMetadata(writeMetadata);
        this.validateClusteringCommit(clusteringMetadata, clusteringInstant, table);
        if (this.config.isMetricsOn()) {
            clusteringMetadata.getWriteStats().ifPresent(hoodieWriteStats -> hoodieWriteStats.stream().filter(hoodieWriteStat -> hoodieWriteStat.getRuntimeStats() != null).map(hoodieWriteStat -> hoodieWriteStat.getRuntimeStats().getTotalCreateTime()).forEach(this.metrics::updateClusteringFileCreationMetrics));
        }
        if (shouldComplete && clusteringMetadata.getCommitMetadata().isPresent()) {
            this.completeClustering((HoodieReplaceCommitMetadata)clusteringMetadata.getCommitMetadata().get(), table, clusteringInstant);
        }
        return clusteringMetadata;
    }

    public boolean purgePendingClustering(String clusteringInstant) {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getStorageConf());
        Option<HoodieInstant> inflightInstantOpt = ClusteringUtils.getInflightClusteringInstant(clusteringInstant, table.getActiveTimeline(), table.getMetaClient().getInstantGenerator());
        if (inflightInstantOpt.isPresent()) {
            table.rollbackInflightClustering(inflightInstantOpt.get(), commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false), true);
            table.getMetaClient().reloadActiveTimeline();
            return true;
        }
        return false;
    }

    public HoodieWriteMetadata<T> managePartitionTTL(String instantTime) {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getStorageConf());
        return table.managePartitionTTL(this.context, instantTime);
    }

    protected abstract void validateClusteringCommit(HoodieWriteMetadata<O> var1, String var2, HoodieTable var3);

    protected abstract HoodieWriteMetadata<O> convertToOutputMetadata(HoodieWriteMetadata<T> var1);

    private void completeClustering(HoodieReplaceCommitMetadata metadata, HoodieTable table, String clusteringCommitTime) {
        List<HoodieWriteStat> writeStats = metadata.getWriteStats();
        this.handleWriteErrors(writeStats, TableServiceType.CLUSTER);
        HoodieInstant clusteringInstant = ClusteringUtils.getInflightClusteringInstant(clusteringCommitTime, table.getActiveTimeline(), table.getMetaClient().getInstantGenerator()).get();
        try {
            this.txnManager.beginTransaction(Option.of(clusteringInstant), Option.empty());
            this.finalizeWrite(table, clusteringCommitTime, writeStats);
            if (this.isPreCommitRequired()) {
                this.preCommit(metadata);
            }
            this.writeTableMetadata(table, clusteringInstant.requestedTime(), metadata);
            LOG.info("Committing Clustering {} for table {}", (Object)clusteringCommitTime, (Object)table.getConfig().getBasePath());
            LOG.debug("Clustering {} finished with result {}", (Object)clusteringCommitTime, (Object)metadata);
            ClusteringUtils.transitionClusteringOrReplaceInflightToComplete(false, clusteringInstant, TimelineMetadataUtils.serializeCommitMetadata(table.getMetaClient().getCommitMetadataSerDe(), metadata), table.getActiveTimeline());
        }
        catch (Exception e) {
            throw new HoodieClusteringException("unable to transition clustering inflight to complete: " + clusteringCommitTime, e);
        }
        finally {
            this.txnManager.endTransaction(Option.of(clusteringInstant));
            this.releaseResources(clusteringCommitTime);
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, clusteringCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.clusteringTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.clusteringTimer.stop());
            TimelineUtils.parseDateFromInstantTimeSafely(clusteringCommitTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, "clustering"));
        }
        LOG.info("Clustering successfully on commit {} for table {}", (Object)clusteringCommitTime, (Object)table.getConfig().getBasePath());
    }

    protected void runTableServicesInline(HoodieTable table, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        if (!this.tableServicesEnabled(this.config)) {
            return;
        }
        if (!this.config.areAnyTableServicesExecutedInline().booleanValue() && !this.config.areAnyTableServicesScheduledInline().booleanValue()) {
            return;
        }
        if (this.config.inlineCompactionEnabled()) {
            metadata.addMetadata(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
            this.inlineCompaction(table, extraMetadata);
        } else {
            metadata.addMetadata(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
        }
        if (!this.config.inlineCompactionEnabled() && this.config.scheduleInlineCompaction() && table.getActiveTimeline().getWriteTimeline().filterPendingCompactionTimeline().empty()) {
            metadata.addMetadata(HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT.key(), "true");
            this.inlineScheduleCompaction(extraMetadata);
        }
        if (this.config.inlineLogCompactionEnabled()) {
            this.runAnyPendingLogCompactions(table);
            metadata.addMetadata(HoodieCompactionConfig.INLINE_LOG_COMPACT.key(), "true");
            this.inlineLogCompact(extraMetadata);
        } else {
            metadata.addMetadata(HoodieCompactionConfig.INLINE_LOG_COMPACT.key(), "false");
        }
        if (this.config.inlineClusteringEnabled()) {
            metadata.addMetadata(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "true");
            this.inlineClustering(table, extraMetadata);
        } else {
            metadata.addMetadata(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "false");
        }
        if (!this.config.inlineClusteringEnabled() && this.config.scheduleInlineClustering() && !table.getActiveTimeline().getLastPendingClusterInstant().isPresent()) {
            metadata.addMetadata(HoodieClusteringConfig.SCHEDULE_INLINE_CLUSTERING.key(), "true");
            this.inlineScheduleClustering(extraMetadata);
        }
        if (this.config.isInlinePartitionTTLEnable()) {
            String instantTime = this.createNewInstantTime();
            table.managePartitionTTL(table.getContext(), instantTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<String> scheduleTableService(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        HoodieTableConfig tableConfig = HoodieTableConfig.loadFromHoodieProps(this.storage, this.config.getBasePath());
        InstantGenerator instantGenerator = TimelineLayout.fromVersion(tableConfig.getTableVersion().getTimelineLayoutVersion()).getInstantGenerator();
        Option<HoodieInstant> inflightInstant = Option.of(instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, tableServiceType.getAction(), instantTime));
        try {
            this.txnManager.beginTransaction(inflightInstant, Option.empty());
            LOG.info("Scheduling table service {} for table {}", (Object)tableServiceType, (Object)this.config.getBasePath());
            Option<String> option = this.scheduleTableServiceInternal(instantTime, extraMetadata, tableServiceType);
            return option;
        }
        finally {
            this.txnManager.endTransaction(inflightInstant);
        }
    }

    protected Option<String> scheduleTableServiceInternal(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        if (!this.tableServicesEnabled(this.config)) {
            return Option.empty();
        }
        Option<String> option = Option.empty();
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.storageConf);
        switch (tableServiceType) {
            case ARCHIVE: {
                LOG.info("Scheduling archiving is not supported. Skipping.");
                break;
            }
            case CLUSTER: {
                LOG.info("Scheduling clustering at instant time: {} for table {}", (Object)instantTime, (Object)this.config.getBasePath());
                Option<HoodieClusteringPlan> clusteringPlan = table.scheduleClustering(this.context, instantTime, extraMetadata);
                option = clusteringPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            case COMPACT: {
                LOG.info("Scheduling compaction at instant time: {} for table {}", (Object)instantTime, (Object)this.config.getBasePath());
                Option<HoodieCompactionPlan> compactionPlan = table.scheduleCompaction(this.context, instantTime, extraMetadata);
                option = compactionPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            case LOG_COMPACT: {
                LOG.info("Scheduling log compaction at instant time: {} for table {}", (Object)instantTime, (Object)this.config.getBasePath());
                Option<HoodieCompactionPlan> logCompactionPlan = table.scheduleLogCompaction(this.context, instantTime, extraMetadata);
                option = logCompactionPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            case CLEAN: {
                LOG.info("Scheduling cleaning at instant time: {} for table {}", (Object)instantTime, (Object)this.config.getBasePath());
                Option<HoodieCleanerPlan> cleanerPlan = table.scheduleCleaning(this.context, instantTime, extraMetadata);
                option = cleanerPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid TableService " + (Object)((Object)tableServiceType));
            }
        }
        Option<String> instantRange = this.delegateToTableServiceManager(tableServiceType, table);
        if (instantRange.isPresent()) {
            LOG.info("Delegate instant [{}] to table service manager", (Object)instantRange.get());
        }
        return option;
    }

    protected HoodieTable createTableAndValidate(HoodieWriteConfig config, BiFunction<HoodieWriteConfig, HoodieEngineContext, HoodieTable> createTableFn, boolean skipValidation) {
        HoodieTable table = createTableFn.apply(config, this.context);
        if (!skipValidation) {
            CommonClientUtils.validateTableVersion(table.getMetaClient().getTableConfig(), config);
        }
        return table;
    }

    protected HoodieTable<?, I, ?, T> createTable(HoodieWriteConfig config, StorageConfiguration<?> storageConf) {
        return this.createTable(config, storageConf, false);
    }

    protected abstract HoodieTable<?, I, ?, T> createTable(HoodieWriteConfig var1, StorageConfiguration<?> var2, boolean var3);

    protected Option<String> inlineClustering(Option<Map<String, String>> extraMetadata) {
        Option<String> clusteringInstantOpt = this.inlineScheduleClustering(extraMetadata);
        clusteringInstantOpt.ifPresent(clusteringInstant -> this.cluster((String)clusteringInstant, true));
        return clusteringInstantOpt;
    }

    private void inlineClustering(HoodieTable table, Option<Map<String, String>> extraMetadata) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.clustering)) {
            this.scheduleClustering(extraMetadata);
        } else {
            this.runAnyPendingClustering(table);
            this.inlineClustering(extraMetadata);
        }
    }

    protected Option<String> inlineScheduleClustering(Option<Map<String, String>> extraMetadata) {
        return this.scheduleClustering(extraMetadata);
    }

    protected void runAnyPendingClustering(HoodieTable table) {
        table.getActiveTimeline().filterPendingReplaceOrClusteringTimeline().getInstants().forEach(instant -> {
            Option<Pair<HoodieInstant, HoodieClusteringPlan>> instantPlan = ClusteringUtils.getClusteringPlan(table.getMetaClient(), instant);
            if (instantPlan.isPresent()) {
                LOG.info("Running pending clustering at instant {} for table {}", (Object)instantPlan.get().getLeft(), (Object)this.config.getBasePath());
                this.cluster(instant.requestedTime(), true);
            }
        });
    }

    @Nullable
    @Deprecated
    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline, boolean skipLocking) throws HoodieIOException {
        return this.clean(cleanInstantTime, scheduleInline);
    }

    @Nullable
    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline) throws HoodieIOException {
        if (!this.tableServicesEnabled(this.config)) {
            return null;
        }
        Timer.Context timerContext = this.metrics.getCleanCtx();
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "clean", () -> this.rollbackFailedWrites());
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.storageConf);
        if (this.config.allowMultipleCleans() || !table.getActiveTimeline().getCleanerTimeline().filterInflightsAndRequested().firstInstant().isPresent()) {
            LOG.info("Cleaner started for table {}", (Object)this.config.getBasePath());
            if (scheduleInline) {
                this.scheduleTableServiceInternal(cleanInstantTime, Option.empty(), TableServiceType.CLEAN);
                table.getMetaClient().reloadActiveTimeline();
            }
            if (this.shouldDelegateToTableServiceManager(this.config, ActionType.clean)) {
                LOG.warn("Cleaning is not yet supported with Table Service Manager.");
                return null;
            }
        }
        HoodieCleanMetadata metadata = table.clean(this.context, cleanInstantTime);
        if (timerContext != null && metadata != null) {
            long durationMs = this.metrics.getDurationInMs(timerContext.stop());
            this.metrics.updateCleanMetrics(durationMs, metadata.getTotalFilesDeleted());
            LOG.info("Cleaned {} files Earliest Retained Instant : {} cleanerElapsedMs {} for table {}", new Object[]{metadata.getTotalFilesDeleted(), metadata.getEarliestCommitToRetain(), durationMs, this.config.getBasePath()});
        }
        this.releaseResources(cleanInstantTime);
        return metadata;
    }

    protected void archive(HoodieTable table) {
        if (!this.tableServicesEnabled(this.config)) {
            return;
        }
        try {
            Timer.Context timerContext = this.metrics.getArchiveCtx();
            HoodieTimelineArchiver archiver = TimelineArchivers.getInstance(table.getMetaClient().getTimelineLayoutVersion(), this.config, table);
            int instantsToArchive = archiver.archiveIfRequired(this.context, true);
            if (timerContext != null) {
                long durationMs = this.metrics.getDurationInMs(timerContext.stop());
                this.metrics.updateArchiveMetrics(durationMs, instantsToArchive);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Failed to archive", ioe);
        }
    }

    private HoodieTimeline getInflightTimelineExcludeCompactionAndClustering(HoodieTableMetaClient metaClient) {
        HoodieTimeline inflightTimelineExcludingCompaction = metaClient.getCommitsTimeline().filterPendingExcludingCompaction();
        return inflightTimelineExcludingCompaction.filter(instant -> !ClusteringUtils.isClusteringInstant(inflightTimelineExcludingCompaction, instant, metaClient.getInstantGenerator()));
    }

    protected Option<HoodiePendingRollbackInfo> getPendingRollbackInfo(HoodieTableMetaClient metaClient, String commitToRollback) {
        return this.getPendingRollbackInfo(metaClient, commitToRollback, true);
    }

    public Option<HoodiePendingRollbackInfo> getPendingRollbackInfo(HoodieTableMetaClient metaClient, String commitToRollback, boolean ignoreCompactionAndClusteringInstants) {
        return this.getPendingRollbackInfos(metaClient, ignoreCompactionAndClusteringInstants).getOrDefault(commitToRollback, Option.empty());
    }

    protected Map<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInfos(HoodieTableMetaClient metaClient) {
        return this.getPendingRollbackInfos(metaClient, true);
    }

    protected Map<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInfos(HoodieTableMetaClient metaClient, boolean ignoreCompactionAndClusteringInstants) {
        List<HoodieInstant> instants = metaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants();
        HashMap<String, Option<HoodiePendingRollbackInfo>> infoMap = new HashMap<String, Option<HoodiePendingRollbackInfo>>();
        for (HoodieInstant rollbackInstant : instants) {
            HoodieRollbackPlan rollbackPlan;
            try {
                rollbackPlan = RollbackUtils.getRollbackPlan(metaClient, rollbackInstant);
            }
            catch (Exception e) {
                if (rollbackInstant.isRequested()) {
                    LOG.warn("Fetching rollback plan failed for " + rollbackInstant + ", deleting the plan since it's in REQUESTED state", (Throwable)e);
                    try {
                        metaClient.getActiveTimeline().deletePending(rollbackInstant);
                    }
                    catch (HoodieIOException he) {
                        LOG.warn("Cannot delete " + rollbackInstant, (Throwable)he);
                    }
                    continue;
                }
                LOG.warn("Fetching rollback plan failed for " + rollbackInstant + ", skip the plan", (Throwable)e);
                continue;
            }
            try {
                String action = rollbackPlan.getInstantToRollback().getAction();
                String instantToRollback = rollbackPlan.getInstantToRollback().getCommitTime();
                if (ignoreCompactionAndClusteringInstants) {
                    if ("compaction".equals(action)) continue;
                    InstantGenerator instantGenerator = metaClient.getInstantGenerator();
                    boolean isClustering = ClusteringUtils.isClusteringInstant(metaClient.getActiveTimeline(), instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, action, instantToRollback), instantGenerator);
                    if (isClustering) continue;
                    infoMap.putIfAbsent(instantToRollback, Option.of(new HoodiePendingRollbackInfo(rollbackInstant, rollbackPlan)));
                    continue;
                }
                infoMap.putIfAbsent(instantToRollback, Option.of(new HoodiePendingRollbackInfo(rollbackInstant, rollbackPlan)));
            }
            catch (Exception e) {
                LOG.warn("Processing rollback plan failed for " + rollbackInstant + ", skip the plan", (Throwable)e);
            }
        }
        return infoMap;
    }

    protected boolean rollbackFailedIndexingCommits() {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.storageConf);
        List<String> instantsToRollback = this.getFailedIndexingCommitsToRollbackForMetadataTable(table.getMetaClient());
        Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.getPendingRollbackInfos(table.getMetaClient());
        instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
        this.rollbackFailedWrites(pendingRollbacks);
        return !pendingRollbacks.isEmpty();
    }

    private List<String> getFailedIndexingCommitsToRollbackForMetadataTable(HoodieTableMetaClient metaClient) {
        if (!HoodieTableMetadata.isMetadataTable(metaClient.getBasePath())) {
            return Collections.emptyList();
        }
        HoodieTableMetaClient dataMetaClient = HoodieTableMetaClient.builder().setBasePath(HoodieTableMetadata.getDatasetBasePath(this.config.getBasePath())).setConf(metaClient.getStorageConf().newInstance()).build();
        HoodieTimeline dataIndexTimeline = dataMetaClient.getActiveTimeline().filter(instant -> instant.getAction().equals("indexing"));
        Stream<HoodieInstant> inflightInstantsStream = metaClient.getCommitsTimeline().filter(instant -> !instant.isCompleted() && HoodieTableMetadataUtil.isIndexingCommit(dataIndexTimeline, instant.requestedTime())).getInstantsAsStream();
        return inflightInstantsStream.filter(instant -> {
            try {
                return this.heartbeatClient.isHeartbeatExpired(instant.requestedTime());
            }
            catch (IOException io) {
                throw new HoodieException("Failed to check heartbeat for instant " + instant, io);
            }
        }).map(HoodieInstant::requestedTime).collect(Collectors.toList());
    }

    protected Boolean rollbackFailedWrites() {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.storageConf);
        List<String> instantsToRollback = this.getInstantsToRollback(table.getMetaClient(), this.config.getFailedWritesCleanPolicy(), Option.empty());
        Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.getPendingRollbackInfos(table.getMetaClient());
        instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
        this.rollbackFailedWrites(pendingRollbacks);
        return !pendingRollbacks.isEmpty();
    }

    protected void rollbackFailedWrites(Map<String, Option<HoodiePendingRollbackInfo>> instantsToRollback) {
        this.rollbackFailedWrites(instantsToRollback, false, false);
    }

    protected void rollbackFailedWrites(Map<String, Option<HoodiePendingRollbackInfo>> instantsToRollback, boolean skipLocking, boolean skipVersionCheck) {
        LinkedHashMap reverseSortedRollbackInstants = instantsToRollback.entrySet().stream().sorted((i1, i2) -> ((String)i2.getKey()).compareTo((String)i1.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        boolean isMetadataTable = HoodieTableMetadata.isMetadataTable(this.basePath);
        for (Map.Entry entry : reverseSortedRollbackInstants.entrySet()) {
            if (!isMetadataTable && InstantComparison.compareTimestamps((String)entry.getKey(), InstantComparison.LESSER_THAN_OR_EQUALS, "00000000000002")) {
                this.rollbackFailedBootstrap();
                HeartbeatUtils.deleteHeartbeatFile(this.storage, this.basePath, (String)entry.getKey(), this.config);
                break;
            }
            this.rollback((String)entry.getKey(), (Option)entry.getValue(), skipLocking, skipVersionCheck);
            HeartbeatUtils.deleteHeartbeatFile(this.storage, this.basePath, (String)entry.getKey(), this.config);
        }
    }

    protected List<String> getInstantsToRollback(HoodieTableMetaClient metaClient, HoodieFailedWritesCleaningPolicy cleaningPolicy, Option<String> curInstantTime) {
        Stream<HoodieInstant> inflightInstantsStream = this.getInflightTimelineExcludeCompactionAndClustering(metaClient).getReverseOrderedInstants();
        if (cleaningPolicy.isEager()) {
            if (metaClient.isMetadataTable().booleanValue()) {
                HoodieTableMetaClient dataMetaClient = HoodieTableMetaClient.builder().setBasePath(HoodieTableMetadata.getDatasetBasePath(this.config.getBasePath())).setConf(metaClient.getStorageConf().newInstance()).build();
                HoodieTimeline dataIndexTimeline = dataMetaClient.getActiveTimeline().filter(instant -> instant.getAction().equals("indexing"));
                return inflightInstantsStream.map(HoodieInstant::requestedTime).filter(entry -> {
                    if (curInstantTime.isPresent()) {
                        return !entry.equals(curInstantTime.get());
                    }
                    return !HoodieTableMetadataUtil.isIndexingCommit(dataIndexTimeline, entry);
                }).collect(Collectors.toList());
            }
            return inflightInstantsStream.map(HoodieInstant::requestedTime).filter(entry -> {
                if (curInstantTime.isPresent()) {
                    return !entry.equals(curInstantTime.get());
                }
                return true;
            }).collect(Collectors.toList());
        }
        if (cleaningPolicy.isLazy()) {
            return this.getInstantsToRollbackForLazyCleanPolicy(metaClient, inflightInstantsStream);
        }
        if (cleaningPolicy.isNever()) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("Invalid Failed Writes Cleaning Policy " + (Object)((Object)this.config.getFailedWritesCleanPolicy()));
    }

    private List<String> getInstantsToRollbackForLazyCleanPolicy(HoodieTableMetaClient metaClient, Stream<HoodieInstant> inflightInstantsStream) {
        List expiredInstants = inflightInstantsStream.filter(instant -> {
            try {
                return this.heartbeatClient.isHeartbeatExpired(instant.requestedTime());
            }
            catch (IOException io) {
                throw new HoodieException("Failed to check heartbeat for instant " + instant, io);
            }
        }).map(HoodieInstant::requestedTime).collect(Collectors.toList());
        if (!expiredInstants.isEmpty()) {
            metaClient.reloadActiveTimeline();
            HoodieTimeline refreshedInflightTimeline = this.getInflightTimelineExcludeCompactionAndClustering(metaClient);
            return expiredInstants.stream().filter(refreshedInflightTimeline::containsInstant).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, Option<HoodiePendingRollbackInfo> pendingRollbackInfo, boolean skipLocking, boolean skipVersionCheck) throws HoodieRollbackException {
        String rollbackInstantTime = pendingRollbackInfo.map(entry -> entry.getRollbackInstant().requestedTime()).orElseGet(() -> this.createNewInstantTime(!skipLocking));
        return this.rollback(commitInstantTime, pendingRollbackInfo, rollbackInstantTime, skipLocking, skipVersionCheck);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, Option<HoodiePendingRollbackInfo> pendingRollbackInfo, String rollbackInstantTime, boolean skipLocking, boolean skipVersionCheck) throws HoodieRollbackException {
        LOG.info("Begin rollback of instant {} for table {}", (Object)commitInstantTime, (Object)this.config.getBasePath());
        Timer.Context timerContext = this.metrics.getRollbackCtx();
        try {
            HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.storageConf, skipVersionCheck);
            Option<HoodieInstant> commitInstantOpt = Option.fromJavaOptional(table.getActiveTimeline().getCommitsTimeline().getInstantsAsStream().filter(instant -> InstantComparison.EQUALS.test(instant.requestedTime(), commitInstantTime)).findFirst());
            if (commitInstantOpt.isPresent() || pendingRollbackInfo.isPresent()) {
                LOG.info(String.format("Scheduling Rollback at instant time : %s (exists in active timeline: %s), with rollback plan: %s for table %s", rollbackInstantTime, commitInstantOpt.isPresent(), pendingRollbackInfo.isPresent(), this.config.getBasePath()));
                Option rollbackPlanOption = pendingRollbackInfo.map(entry -> Option.of(entry.getRollbackPlan())).orElseGet(() -> table.scheduleRollback(this.context, rollbackInstantTime, (HoodieInstant)commitInstantOpt.get(), false, this.config.shouldRollbackUsingMarkers(), false));
                if (rollbackPlanOption.isPresent()) {
                    HoodieRollbackMetadata rollbackMetadata;
                    HoodieRollbackMetadata hoodieRollbackMetadata = rollbackMetadata = commitInstantOpt.isPresent() ? table.rollback(this.context, rollbackInstantTime, commitInstantOpt.get(), true, skipLocking) : table.rollback(this.context, rollbackInstantTime, table.getMetaClient().createNewInstant(HoodieInstant.State.INFLIGHT, ((HoodieRollbackPlan)((Object)rollbackPlanOption.get())).getInstantToRollback().getAction(), commitInstantTime), false, skipLocking);
                    if (timerContext != null) {
                        long durationInMs = this.metrics.getDurationInMs(timerContext.stop());
                        this.metrics.updateRollbackMetrics(durationInMs, rollbackMetadata.getTotalFilesDeleted());
                    }
                    return true;
                }
                throw new HoodieRollbackException("Failed to rollback " + this.config.getBasePath() + " commits " + commitInstantTime);
            }
            LOG.warn("Cannot find instant {} in the timeline of table {} for rollback", (Object)commitInstantTime, (Object)this.config.getBasePath());
            return false;
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Failed to rollback " + this.config.getBasePath() + " commits " + commitInstantTime, e);
        }
    }

    public void rollbackFailedBootstrap() {
        LOG.info("Rolling back pending bootstrap if present");
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.storageConf);
        HoodieTimeline inflightTimeline = table.getMetaClient().getCommitsTimeline().filterPendingExcludingCompactionAndLogCompaction();
        Option<String> instant = Option.fromJavaOptional(inflightTimeline.getReverseOrderedInstants().map(HoodieInstant::requestedTime).findFirst());
        if (instant.isPresent() && InstantComparison.compareTimestamps(instant.get(), InstantComparison.LESSER_THAN_OR_EQUALS, "00000000000002")) {
            LOG.info("Found pending bootstrap instants. Rolling them back");
            table.rollbackBootstrap(this.context, this.createNewInstantTime());
            LOG.info("Finished rolling back pending bootstrap");
        }
        HoodieTableMetadataUtil.deleteMetadataTable(this.config.getBasePath(), this.context);
    }

    protected boolean isPreCommitRequired() {
        return this.config.getWriteConflictResolutionStrategy().isPreCommitRequired();
    }

    private Option<String> delegateToTableServiceManager(TableServiceType tableServiceType, HoodieTable table) {
        if (!this.config.getTableServiceManagerConfig().isEnabledAndActionSupported(ActionType.compaction)) {
            return Option.empty();
        }
        HoodieTableServiceManagerClient tableServiceManagerClient = new HoodieTableServiceManagerClient(table.getMetaClient(), this.config.getTableServiceManagerConfig());
        switch (tableServiceType) {
            case COMPACT: {
                return tableServiceManagerClient.executeCompaction();
            }
            case CLUSTER: {
                return tableServiceManagerClient.executeClustering();
            }
            case CLEAN: {
                return tableServiceManagerClient.executeClean();
            }
        }
        LOG.info("Not supported delegate to table service manager, tableServiceType : " + tableServiceType.getAction());
        return Option.empty();
    }

    @Override
    public void close() {
        AsyncArchiveService.forceShutdown(this.asyncArchiveService);
        this.asyncArchiveService = null;
        AsyncCleanerService.forceShutdown(this.asyncCleanerService);
        this.asyncCleanerService = null;
        super.close();
    }

    protected void handleWriteErrors(List<HoodieWriteStat> writeStats, TableServiceType tableServiceType) {
        if (writeStats.stream().mapToLong(HoodieWriteStat::getTotalWriteErrors).sum() > 0L) {
            String message = (Object)((Object)tableServiceType) + " failed to write to files:" + writeStats.stream().filter(s -> s.getTotalWriteErrors() > 0L).map(HoodieWriteStat::getFileId).collect(Collectors.joining(","));
            switch (tableServiceType) {
                case CLUSTER: {
                    throw new HoodieClusteringException(message);
                }
                case LOG_COMPACT: {
                    throw new HoodieLogCompactException(message);
                }
                case COMPACT: {
                    throw new HoodieCompactionException(message);
                }
            }
            throw new HoodieException(message);
        }
    }

    @Override
    protected void updateColumnsToIndexWithColStats(HoodieTableMetaClient metaClient, List<String> columnsToIndex) {
    }

    protected void releaseResources(String instantTime) {
    }
}

