/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.spark.sql.Row;

public class QuickstartUtils {
    private static Option<String> convertToString(HoodieRecord record) {
        try {
            String str = ((OverwriteWithLatestAvroPayload)record.getData()).getInsertValue(DataGenerator.avroSchema).toString();
            str = "{" + str.substring(str.indexOf("\"ts\":"));
            return Option.of(str.replaceAll("}", ", \"partitionpath\": \"" + record.getPartitionPath() + "\"}"));
        }
        catch (IOException e) {
            return Option.empty();
        }
    }

    private static Option<String> convertToString(String uuid, String partitionPath, Long ts) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("\"ts\": \"" + (ts == null ? "0.0" : ts) + "\",");
        stringBuffer.append("\"uuid\": \"" + uuid + "\",");
        stringBuffer.append("\"partitionpath\": \"" + partitionPath + "\"");
        stringBuffer.append("}");
        return Option.of(stringBuffer.toString());
    }

    public static List<String> convertToStringList(List<HoodieRecord> records) {
        return records.stream().map(hr -> QuickstartUtils.convertToString(hr)).filter(os -> os.isPresent()).map(os -> (String)os.get()).collect(Collectors.toList());
    }

    public static Map<String, String> getQuickstartWriteConfigs() {
        HashMap<String, String> demoConfigs = new HashMap<String, String>();
        demoConfigs.put("hoodie.insert.shuffle.parallelism", "2");
        demoConfigs.put("hoodie.upsert.shuffle.parallelism", "2");
        demoConfigs.put("hoodie.bulkinsert.shuffle.parallelism", "2");
        demoConfigs.put("hoodie.delete.shuffle.parallelism", "2");
        return demoConfigs;
    }

    public static class DataGenerator {
        private static final String DEFAULT_FIRST_PARTITION_PATH = "americas/united_states/san_francisco";
        private static final String DEFAULT_SECOND_PARTITION_PATH = "americas/brazil/sao_paulo";
        private static final String DEFAULT_THIRD_PARTITION_PATH = "asia/india/chennai";
        private static final String[] DEFAULT_PARTITION_PATHS = new String[]{"americas/united_states/san_francisco", "americas/brazil/sao_paulo", "asia/india/chennai"};
        static String TRIP_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"ts\",\"type\": \"long\"},{\"name\": \"uuid\", \"type\": \"string\"},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"fare\",\"type\": \"double\"}]}";
        static Schema avroSchema = new Schema.Parser().parse(TRIP_EXAMPLE_SCHEMA);
        private static Random rand = new Random(46474747L);
        private final Map<Integer, HoodieKey> existingKeys;
        private final String[] partitionPaths;
        private int numExistingKeys;

        public DataGenerator() {
            this(DEFAULT_PARTITION_PATHS, new HashMap<Integer, HoodieKey>());
        }

        public DataGenerator(String[] partitionPaths) {
            this(partitionPaths, new HashMap<Integer, HoodieKey>());
        }

        private DataGenerator(String[] partitionPaths, Map<Integer, HoodieKey> keyPartitionMap) {
            this.partitionPaths = Arrays.copyOf(partitionPaths, partitionPaths.length);
            this.existingKeys = keyPartitionMap;
        }

        private static String generateRandomString() {
            int leftLimit = 48;
            int rightLimit = 57;
            int stringLength = 3;
            StringBuilder buffer = new StringBuilder(stringLength);
            for (int i = 0; i < stringLength; ++i) {
                int randomLimitedInt = leftLimit + (int)(rand.nextFloat() * (float)(rightLimit - leftLimit + 1));
                buffer.append((char)randomLimitedInt);
            }
            return buffer.toString();
        }

        public int getNumExistingKeys() {
            return this.numExistingKeys;
        }

        public static GenericRecord generateGenericRecord(String rowKey, String riderName, String driverName, long timestamp) {
            GenericData.Record rec = new GenericData.Record(avroSchema);
            rec.put("uuid", (Object)rowKey);
            rec.put("ts", (Object)timestamp);
            rec.put("rider", (Object)riderName);
            rec.put("driver", (Object)driverName);
            rec.put("begin_lat", (Object)rand.nextDouble());
            rec.put("begin_lon", (Object)rand.nextDouble());
            rec.put("end_lat", (Object)rand.nextDouble());
            rec.put("end_lon", (Object)rand.nextDouble());
            rec.put("fare", (Object)(rand.nextDouble() * 100.0));
            return rec;
        }

        public static OverwriteWithLatestAvroPayload generateRandomValue(HoodieKey key, String riderDriverSuffix) throws IOException {
            GenericRecord rec = DataGenerator.generateGenericRecord(key.getRecordKey(), "rider-" + riderDriverSuffix, "driver-" + riderDriverSuffix, DataGenerator.generateRangeRandomTimestamp(7));
            return new OverwriteWithLatestAvroPayload(Option.of(rec));
        }

        private static long generateRangeRandomTimestamp(int daysTillNow) {
            long maxIntervalMillis = (long)(daysTillNow * 24 * 60 * 60) * 1000L;
            return System.currentTimeMillis() - (long)(Math.random() * (double)maxIntervalMillis);
        }

        public Stream<HoodieRecord> generateInsertsStream(String randomString, Integer n) {
            int currSize = this.getNumExistingKeys();
            return IntStream.range(0, n).boxed().map(i -> {
                String partitionPath = this.partitionPaths[rand.nextInt(this.partitionPaths.length)];
                HoodieKey key = new HoodieKey(UUID.randomUUID().toString(), partitionPath);
                this.existingKeys.put(currSize + i, key);
                ++this.numExistingKeys;
                try {
                    return new HoodieAvroRecord<OverwriteWithLatestAvroPayload>(key, DataGenerator.generateRandomValue(key, randomString));
                }
                catch (IOException e) {
                    throw new HoodieIOException(e.getMessage(), e);
                }
            });
        }

        public List<HoodieRecord> generateInserts(Integer n) throws IOException {
            String randomString = DataGenerator.generateRandomString();
            return this.generateInsertsStream(randomString, n).collect(Collectors.toList());
        }

        public HoodieRecord generateUpdateRecord(HoodieKey key, String randomString) throws IOException {
            return new HoodieAvroRecord<OverwriteWithLatestAvroPayload>(key, DataGenerator.generateRandomValue(key, randomString));
        }

        public List<HoodieRecord> generateUpdates(Integer n) {
            if (this.numExistingKeys == 0) {
                throw new HoodieException("Data must have been written before performing the update operation");
            }
            String randomString = DataGenerator.generateRandomString();
            return IntStream.range(0, n).boxed().map(x -> {
                try {
                    return this.generateUpdateRecord(this.existingKeys.get(rand.nextInt(this.numExistingKeys)), randomString);
                }
                catch (IOException e) {
                    throw new HoodieIOException(e.getMessage(), e);
                }
            }).collect(Collectors.toList());
        }

        public List<HoodieRecord> generateUniqueUpdates(Integer n) {
            if (this.numExistingKeys < n) {
                throw new HoodieException("Data must have been written before performing the update operation");
            }
            List keys2 = IntStream.range(0, this.numExistingKeys).boxed().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(keys2);
            String randomString = DataGenerator.generateRandomString();
            return IntStream.range(0, n).boxed().map(x -> {
                try {
                    return this.generateUpdateRecord(this.existingKeys.get(keys2.get((int)x)), randomString);
                }
                catch (IOException e) {
                    throw new HoodieIOException(e.getMessage(), e);
                }
            }).collect(Collectors.toList());
        }

        public List<String> generateDeletes(List<Row> rows) {
            return rows.stream().map(row -> row.length() == 2 ? QuickstartUtils.convertToString((String)row.getAs("uuid"), (String)row.getAs("partitionpath"), null) : QuickstartUtils.convertToString((String)row.getAs("uuid"), (String)row.getAs("partitionpath"), (Long)row.getAs("ts"))).filter(os -> os.isPresent()).map(os -> (String)os.get()).collect(Collectors.toList());
        }

        public void close() {
            this.existingKeys.clear();
        }
    }
}

