/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowRollbacksProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\f\u0019\u0001\u001dB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006m\u0001!\ta\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0013Y\u0004B\u0002#\u0001A\u0003%A\bC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r5\u0003\u0001\u0015!\u0003H\u0011\u001dq\u0005A1A\u0005\n\u0019Caa\u0014\u0001!\u0002\u00139\u0005\"\u0002)\u0001\t\u0003Y\u0004\"B)\u0001\t\u00031\u0005\"\u0002*\u0001\t\u0003\u001a\u0006\"B5\u0001\t\u0003R\u0007\"\u00028\u0001\t\u0003y\u0007bBA\r\u0001\u0011\u0005\u00111D\u0004\b\u0003CA\u0002\u0012AA\u0012\r\u00199\u0002\u0004#\u0001\u0002&!1aG\u0005C\u0001\u0003[A\u0011\"a\f\u0013\u0005\u0004%\t!!\r\t\u0011\u0005\u0005#\u0003)A\u0005\u0003gAq!a\u0011\u0013\t\u0003\t)E\u0001\fTQ><(k\u001c7mE\u0006\u001c7n\u001d)s_\u000e,G-\u001e:f\u0015\tI\"$\u0001\u0006qe>\u001cW\rZ;sKNT!a\u0007\u000f\u0002\u000f\r|W.\\1oI*\u0011QDH\u0001\u0005QV$\u0017N\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013!B:qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001Q1\u0002\"!\u000b\u0016\u000e\u0003aI!a\u000b\r\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\tIS&\u0003\u0002/1\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM]\u0001\fg\"|w\u000fR3uC&d7\u000f\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$GA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\tA\u0014\b\u0005\u0002*\u0001!)qF\u0001a\u0001a\u0005!\"k\u0014'M\u0005\u0006\u001b5jU0Q\u0003J\u000bU*\u0012+F%N+\u0012\u0001\u0010\t\u0004cuz\u0014B\u0001 3\u0005\u0015\t%O]1z!\tI\u0003)\u0003\u0002B1\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0003U\u0011v\n\u0014'C\u0003\u000e[5k\u0018)B%\u0006kU\tV#S'\u0002\n1CU(M\u0019\n\u000b5iS0Q\u0003J\u000bU*\u0012+F%N\u000bACU(M\u0019\n\u000b5iS0Q\u0003J\u000bU*\u0012+F%N\u0003\u0013!\u0006*P\u00192\u0013\u0015iQ&T?>+F\u000bU+U?RK\u0006+R\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JH\u0001\u0006if\u0004Xm]\u0005\u0003\u0019&\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003Y\u0011v\n\u0014'C\u0003\u000e[5kX(V)B+Fk\u0018+Z!\u0016\u0003\u0013\u0001\u0006*P\u00192\u0013\u0015iQ&`\u001fV#\u0006+\u0016+`)f\u0003V)A\u000bS\u001f2c%)Q\"L?>+F\u000bU+U?RK\u0006+\u0012\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\fAaY1mYR\u0011A\u000b\u001a\t\u0004+v\u0003gB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tIf%\u0001\u0004=e>|GOP\u0005\u0002g%\u0011ALM\u0001\ba\u0006\u001c7.Y4f\u0013\tqvLA\u0002TKFT!\u0001\u0018\u001a\u0011\u0005\u0005\u0014W\"\u0001\u0010\n\u0005\rt\"a\u0001*po\")Q-\u0004a\u0001M\u0006!\u0011M]4t!\tIs-\u0003\u0002i1\ti\u0001K]8dK\u0012,(/Z!sON\fQAY;jY\u0012,\u0012a\u001b\t\u0003S1L!!\u001c\r\u0003\u0013A\u0013xnY3ekJ,\u0017!E4fiJ{G\u000e\u001c2bG.$U\r^1jYR)A\u000b]?\u0002\u0010!)\u0011o\u0004a\u0001e\u0006q\u0011m\u0019;jm\u0016$\u0016.\\3mS:,\u0007CA:|\u001b\u0005!(BA;w\u0003!!\u0018.\\3mS:,'BA<y\u0003\u0015!\u0018M\u00197f\u0015\tI(0\u0001\u0004d_6lwN\u001c\u0006\u0003;\tJ!\u0001 ;\u0003)!{w\u000eZ5f\u0003\u000e$\u0018N^3US6,G.\u001b8f\u0011\u0015qx\u00021\u0001\u0000\u0003-Ign\u001d;b]R$\u0016.\\3\u0011\t\u0005\u0005\u0011\u0011\u0002\b\u0005\u0003\u0007\t)\u0001\u0005\u0002Xe%\u0019\u0011q\u0001\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9A\r\u0005\b\u0003#y\u0001\u0019AA\n\u0003\u0015a\u0017.\\5u!\r\t\u0014QC\u0005\u0004\u0003/\u0011$aA%oi\u0006aq-\u001a;S_2d'-Y2lgR)A+!\b\u0002 !)\u0011\u000f\u0005a\u0001e\"9\u0011\u0011\u0003\tA\u0002\u0005M\u0011AF*i_^\u0014v\u000e\u001c7cC\u000e\\7\u000f\u0015:pG\u0016$WO]3\u0011\u0005%\u00122c\u0001\n\u0002(A\u0019\u0011'!\u000b\n\u0007\u0005-\"G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003G\tAAT!N\u000bV\u0011\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!a\u0003\u00028\u0005)a*Q'FA\u00059!-^5mI\u0016\u0014XCAA$!\u0015\tI%a\u0015-\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u0005E\u00131H\u0001\u0005kRLG.\u0003\u0003\u0002V\u0005-#\u0001C*vaBd\u0017.\u001a:")
public class ShowRollbacksProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean showDetails;
    private final ProcedureParameter[] ROLLBACKS_PARAMETERS;
    private final ProcedureParameter[] ROLLBACK_PARAMETERS;
    private final StructType ROLLBACKS_OUTPUT_TYPE;
    private final StructType ROLLBACK_OUTPUT_TYPE;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowRollbacksProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowRollbacksProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] ROLLBACKS_PARAMETERS() {
        return this.ROLLBACKS_PARAMETERS;
    }

    private ProcedureParameter[] ROLLBACK_PARAMETERS() {
        return this.ROLLBACK_PARAMETERS;
    }

    private StructType ROLLBACKS_OUTPUT_TYPE() {
        return this.ROLLBACKS_OUTPUT_TYPE;
    }

    private StructType ROLLBACK_OUTPUT_TYPE() {
        return this.ROLLBACK_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        if (this.showDetails) {
            return this.ROLLBACK_PARAMETERS();
        }
        return this.ROLLBACKS_PARAMETERS();
    }

    @Override
    public StructType outputType() {
        if (this.showDetails) {
            return this.ROLLBACK_OUTPUT_TYPE();
        }
        return this.ROLLBACKS_OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.parameters(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.parameters()[0]);
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.parameters()[1]).get());
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        if (this.showDetails) {
            String instantTime = (String)this.getArgValueOrDefault(args2, this.parameters()[2]).get();
            return this.getRollbackDetail(activeTimeline, instantTime, limit);
        }
        return this.getRollbacks(activeTimeline, limit);
    }

    @Override
    public Procedure build() {
        return new ShowRollbacksProcedure(this.showDetails);
    }

    public Seq<Row> getRollbackDetail(HoodieActiveTimeline activeTimeline, String instantTime, int limit) {
        ArrayList rows = new ArrayList();
        HoodieRollbackMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(activeTimeline.getInstantDetails(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", instantTime)).get(), HoodieRollbackMetadata.class);
        ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getPartitionMetadata()).asScala()).toMap(Predef$.MODULE$.$conforms()).iterator().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ShowRollbacksProcedure.$anonfun$getRollbackDetail$1(rows, metadata, entry);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    public Seq<Row> getRollbacks(HoodieActiveTimeline activeTimeline, int limit) {
        ArrayList rows = new ArrayList();
        HoodieTimeline rollback = activeTimeline.getRollbackTimeline().filterCompletedInstants();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(rollback.getInstants().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)instant -> {
            ShowRollbacksProcedure.$anonfun$getRollbacks$1(activeTimeline, rows, instant);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    public static final /* synthetic */ void $anonfun$getRollbackDetail$1(ArrayList rows$1, HoodieRollbackMetadata metadata$1, Tuple2 entry) {
        ((Stream)package$.MODULE$.Stream().concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Traversable[]{(Traversable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((HoodieRollbackPartitionMetadata)((Object)entry._2())).getSuccessDeleteFiles()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(f, (Object)BoxesRunTime.boxToBoolean((boolean)true)), Buffer$.MODULE$.canBuildFrom()), (Traversable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((HoodieRollbackPartitionMetadata)((Object)entry._2())).getFailedDeleteFiles()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2(f, (Object)BoxesRunTime.boxToBoolean((boolean)false)), Buffer$.MODULE$.canBuildFrom())}))).iterator().foreach((Function1 & Serializable & scala.Serializable)fileWithDeleteStatus -> BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata$1.getStartRollbackTime(), metadata$1.getCommitsRollback().toString(), entry._1(), fileWithDeleteStatus._1(), BoxesRunTime.boxToBoolean((boolean)fileWithDeleteStatus._2$mcZ$sp())})))));
    }

    public static final /* synthetic */ void $anonfun$getRollbacks$1(HoodieActiveTimeline activeTimeline$1, ArrayList rows$2, HoodieInstant instant) {
        try {
            HoodieRollbackMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(activeTimeline$1.getInstantDetails(instant).get(), HoodieRollbackMetadata.class);
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metadata.getCommitsRollback().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.getStartRollbackTime(), c, BoxesRunTime.boxToInteger((int)metadata.getTotalFilesDeleted()), BoxesRunTime.boxToLong((long)metadata.getTimeTakenInMillis()), metadata.getPartitionMetadata() != null ? BoxesRunTime.boxToInteger((int)metadata.getPartitionMetadata().size()) : BoxesRunTime.boxToInteger((int)0)})))));
        }
        catch (IOException e) {
            throw new HoodieException(new StringBuilder(44).append("Failed to get rollback's info from instant ").append(instant.getTimestamp()).append(".").toString());
        }
    }

    public ShowRollbacksProcedure(boolean showDetails) {
        this.showDetails = showDetails;
        this.ROLLBACKS_PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
        this.ROLLBACK_PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType)});
        this.ROLLBACKS_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("rollback_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_files_deleted", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("time_taken_in_millis", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_partitions", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
        this.ROLLBACK_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("rollback_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("deleted_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("succeeded", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

