/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.StringUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0003\u0006\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003'\u0001\u0011\u0005q\u0005C\u0003+\u0001\u0011\u00053\u0006C\u0003+\u0001\u0011\u00053\tC\u0003+\u0001\u0011\u0005#\nC\u0003c\u0001\u0011\u00053\rC\u0003c\u0001\u0011\u0005S\rC\u0003c\u0001\u0011\u0005sMA\u000bNKJ<W-\u00138u_.+\u0017pR3oKJ\fGo\u001c:\u000b\u0005-a\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u001b9\tA\u0001[;eS*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011AC\u0005\u00037)\u0011qbU9m\u0017\u0016Lx)\u001a8fe\u0006$xN]\u0001\u0006aJ|\u0007o\u001d\t\u0003=\u0011j\u0011a\b\u0006\u0003A\u0005\naaY8oM&<'B\u0001\u0012$\u0003\u0019\u0019w.\\7p]*\u0011QBE\u0005\u0003K}\u0011q\u0002V=qK\u0012\u0004&o\u001c9feRLWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005!J\u0003CA\r\u0001\u0011\u0015a\"\u00011\u0001\u001e\u000319W\r\u001e*fG>\u0014HmS3z)\ta\u0013\b\u0005\u0002.m9\u0011a\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003cY\ta\u0001\u0010:p_Rt$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012\u0014A\u0002)sK\u0012,g-\u0003\u00028q\t11\u000b\u001e:j]\u001eT!!\u000e\u001a\t\u000bi\u001a\u0001\u0019A\u001e\u0002\rI,7m\u001c:e!\ta\u0014)D\u0001>\u0015\tqt(A\u0004hK:,'/[2\u000b\u0005\u0001\u0013\u0012\u0001B1we>L!AQ\u001f\u0003\u001b\u001d+g.\u001a:jGJ+7m\u001c:e)\taC\tC\u0003F\t\u0001\u0007a)A\u0002s_^\u0004\"a\u0012%\u000e\u00039I!!\u0013\b\u0003\u0007I{w\u000fF\u0002L'n\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\u000bQL\b/Z:\u000b\u0005A\u0003\u0012AB;og\u00064W-\u0003\u0002S\u001b\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\t\u000bQ+\u0001\u0019A+\u0002\u0017%tG/\u001a:oC2\u0014vn\u001e\t\u0003-fk\u0011a\u0016\u0006\u00031:\t\u0001bY1uC2L8\u000f^\u0005\u00035^\u00131\"\u00138uKJt\u0017\r\u001c*po\")A,\u0002a\u0001;\u000611o\u00195f[\u0006\u0004\"A\u00181\u000e\u0003}S!A\u0014\b\n\u0005\u0005|&AC*ueV\u001cG\u000fV=qK\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\u000b\u0003Y\u0011DQA\u000f\u0004A\u0002m\"\"\u0001\f4\t\u000b\u0015;\u0001\u0019\u0001$\u0015\u0007-C\u0017\u000eC\u0003U\u0011\u0001\u0007Q\u000bC\u0003]\u0011\u0001\u0007Q\f")
public class MergeIntoKeyGenerator
extends SqlKeyGenerator {
    @Override
    public String getRecordKey(GenericRecord record) {
        Object recordKey = record.get(HoodieRecord.RECORD_KEY_META_FIELD_ORD);
        if (recordKey != null) {
            return recordKey.toString();
        }
        return super.getRecordKey(record);
    }

    @Override
    public String getRecordKey(Row row) {
        String recordKey = row.getString(HoodieRecord.RECORD_KEY_META_FIELD_ORD);
        if (!StringUtils.isNullOrEmpty(recordKey)) {
            return recordKey;
        }
        return super.getRecordKey(row);
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        UTF8String recordKey = internalRow.getUTF8String(HoodieRecord.RECORD_KEY_META_FIELD_ORD);
        if (recordKey != null) {
            return recordKey;
        }
        return super.getRecordKey(internalRow, schema);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        Object partitionPath = record.get(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
        if (partitionPath != null) {
            return partitionPath.toString();
        }
        return super.getPartitionPath(record);
    }

    @Override
    public String getPartitionPath(Row row) {
        String partitionPath = row.getString(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
        if (!StringUtils.isNullOrEmpty(partitionPath)) {
            return partitionPath;
        }
        return super.getPartitionPath(row);
    }

    @Override
    public UTF8String getPartitionPath(InternalRow internalRow, StructType schema) {
        UTF8String partitionPath = internalRow.getUTF8String(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
        if (partitionPath != null) {
            return partitionPath;
        }
        return super.getPartitionPath(internalRow, schema);
    }

    public MergeIntoKeyGenerator(TypedProperties props) {
        super(props);
    }
}

