/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.catalog;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.sql.InsertMode;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.DelegatingCatalogExtension;
import org.apache.spark.sql.connector.catalog.HoodieIdentifier;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.analysis.HoodieSpark32PlusAnalysis$HoodieV1OrV2Table$;
import org.apache.spark.sql.hudi.catalog.BasicStagedTable;
import org.apache.spark.sql.hudi.catalog.HoodieCatalog$;
import org.apache.spark.sql.hudi.catalog.HoodieInternalV2Table;
import org.apache.spark.sql.hudi.catalog.HoodieInternalV2Table$;
import org.apache.spark.sql.hudi.catalog.HoodieStagedTable;
import org.apache.spark.sql.hudi.catalog.TableCreationMode;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableRenameCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\r\u001b\u0001\u001dBQa\u000f\u0001\u0005\u0002qBq!\t\u0001C\u0002\u0013\u0005q\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0011\u0005\u0006\u000b\u0002!\tE\u0012\u0005\u0006u\u0002!\te\u001f\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003c\u0003A\u0011IAZ\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013Dq!a;\u0001\t\u0003\ti\u000fC\u0004\u00036\u0001!IAa\u000e\t\u000f\tU\u0002\u0001\"\u0005\u0003<!9!Q\u0007\u0001\u0005\u0012\t\u001d\u0003b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005;\u0002A\u0011\u0002B0\u000f\u001d\u0011yH\u0007E\u0001\u0005\u00033a!\u0007\u000e\t\u0002\t\r\u0005BB\u001e\u0017\t\u0003\u0011Y\tC\u0004\u0003\u000eZ!\tAa$\u0003\u001b!{w\u000eZ5f\u0007\u0006$\u0018\r\\8h\u0015\tYB$A\u0004dCR\fGn\\4\u000b\u0005uq\u0012\u0001\u00025vI&T!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00150e]\u0002\"!K\u0017\u000e\u0003)R!aG\u0016\u000b\u00051r\u0012!C2p]:,7\r^8s\u0013\tq#F\u0001\u000eEK2,w-\u0019;j]\u001e\u001c\u0015\r^1m_\u001e,\u0005\u0010^3og&|g\u000e\u0005\u0002*a%\u0011\u0011G\u000b\u0002\u0014'R\fw-\u001b8h)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0003gUj\u0011\u0001\u000e\u0006\u0003;\tJ!A\u000e\u001b\u0003'M\u0003\u0018M]6BI\u0006\u0004H/\u001a:TkB\u0004xN\u001d;\u0011\u0005aJT\"\u0001\u000f\n\u0005ib\"\u0001\u0006)s_ZLG-Z:I_>$\u0017.Z\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0002{A\u0011a\bA\u0007\u00025U\t\u0001\t\u0005\u0002B\u00056\ta$\u0003\u0002D=\ta1\u000b]1sWN+7o]5p]\u000611\u000f]1sW\u0002\n1b\u001d;bO\u0016\u001c%/Z1uKR)qIS(XKB\u0011\u0011\u0006S\u0005\u0003\u0013*\u00121b\u0015;bO\u0016$G+\u00192mK\")1\n\u0002a\u0001\u0019\u0006)\u0011\u000eZ3oiB\u0011\u0011&T\u0005\u0003\u001d*\u0012!\"\u00133f]RLg-[3s\u0011\u0015\u0001F\u00011\u0001R\u0003\u0019\u00198\r[3nCB\u0011!+V\u0007\u0002'*\u0011AKH\u0001\u0006if\u0004Xm]\u0005\u0003-N\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015AF\u00011\u0001Z\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u00045v{V\"A.\u000b\u0003q\u000bQa]2bY\u0006L!AX.\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\\\u0013aC3yaJ,7o]5p]NL!\u0001Z1\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007\"\u00024\u0005\u0001\u00049\u0017A\u00039s_B,'\u000f^5fgB!\u0001.\\8p\u001b\u0005I'B\u00016l\u0003\u0011)H/\u001b7\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u0004\u001b\u0006\u0004\bC\u00019x\u001d\t\tX\u000f\u0005\u0002s76\t1O\u0003\u0002uM\u00051AH]8pizJ!A^.\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003mn\u000bAb\u001d;bO\u0016\u0014V\r\u001d7bG\u0016$Ra\u0012?~}~DQaS\u0003A\u00021CQ\u0001U\u0003A\u0002ECQ\u0001W\u0003A\u0002eCQAZ\u0003A\u0002\u001d\fAc\u001d;bO\u0016\u001c%/Z1uK>\u0013(+\u001a9mC\u000e,G#C$\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0011\u0015Ye\u00011\u0001M\u0011\u0015\u0001f\u00011\u0001R\u0011\u0015Af\u00011\u0001Z\u0011\u00151g\u00011\u0001h\u0003%aw.\u00193UC\ndW\r\u0006\u0003\u0002\u0012\u0005]\u0001cA\u0015\u0002\u0014%\u0019\u0011Q\u0003\u0016\u0003\u000bQ\u000b'\r\\3\t\u000b-;\u0001\u0019\u0001'\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u000b\u0003#\ti\"a\b\u0002\"\u0005\r\u0002\"B&\t\u0001\u0004a\u0005\"\u0002)\t\u0001\u0004\t\u0006\"\u0002-\t\u0001\u0004I\u0006\"\u00024\t\u0001\u00049\u0017a\u0003;bE2,W\t_5tiN$B!!\u000b\u00020A\u0019!,a\u000b\n\u0007\u000552LA\u0004C_>dW-\u00198\t\u000b-K\u0001\u0019\u0001'\u0002\u0013\u0011\u0014x\u000e\u001d+bE2,G\u0003BA\u0015\u0003kAQa\u0013\u0006A\u00021\u000b!\u0002];sO\u0016$\u0016M\u00197f)\u0011\tI#a\u000f\t\u000b-[\u0001\u0019\u0001'\u0002\u0017I,g.Y7f)\u0006\u0014G.\u001a\u000b\u0007\u0003\u0003\n9%a\u0013\u0011\u0007i\u000b\u0019%C\u0002\u0002Fm\u0013A!\u00168ji\"1\u0011\u0011\n\u0007A\u00021\u000b\u0001b\u001c7e\u0013\u0012,g\u000e\u001e\u0005\u0007\u0003\u001bb\u0001\u0019\u0001'\u0002\u00119,w/\u00133f]RDS\u0001DA)\u0003O\u0002RAWA*\u0003/J1!!\u0016\\\u0005\u0019!\bN]8xgB!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013\u0001C1oC2L8/[:\u000b\u0007\u0005\u0005d$\u0001\u0005dCR\fG._:u\u0013\u0011\t)'a\u0017\u00037Q\u000b'\r\\3BYJ,\u0017\rZ=Fq&\u001cHo]#yG\u0016\u0004H/[8oc\u0019qr.!\u001b\u0002\u001cFJ1%a\u001b\u0002t\u0005E\u0015QO\u000b\u0005\u0003[\ny'F\u0001p\t\u001d\t\tH\nb\u0001\u0003w\u0012\u0011\u0001V\u0005\u0005\u0003k\n9(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003sZ\u0016A\u0002;ie><8/\u0005\u0003\u0002~\u0005\r\u0005c\u0001.\u0002\u0000%\u0019\u0011\u0011Q.\u0003\u000f9{G\u000f[5oOB!\u0011QQAF\u001d\rQ\u0016qQ\u0005\u0004\u0003\u0013[\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\u000byIA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011R.2\u0013\r\n\u0019*!&\u0002\u0018\u0006edb\u0001.\u0002\u0016&\u0019\u0011\u0011P.2\u000b\tR6,!'\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n9\u0006K\u0003\r\u0003?\u000b9\u000bE\u0003[\u0003'\n\t\u000b\u0005\u0003\u0002Z\u0005\r\u0016\u0002BAS\u00037\u0012ACT8Tk\u000eDG+\u00192mK\u0016C8-\u001a9uS>t\u0017G\u0002\u0010p\u0003S\u000by+M\u0005$\u0003W\n\u0019(a+\u0002vEJ1%a%\u0002\u0016\u00065\u0016\u0011P\u0019\u0006Ei[\u0016\u0011T\u0019\u0004M\u0005\u0005\u0016AC1mi\u0016\u0014H+\u00192mKR1\u0011\u0011CA[\u0003oCQaS\u0007A\u00021Cq!!/\u000e\u0001\u0004\tY,A\u0004dQ\u0006tw-Z:\u0011\u000bi\u000bi,!1\n\u0007\u0005}6L\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u00022!KAb\u0013\r\t)M\u000b\u0002\f)\u0006\u0014G.Z\"iC:<W-\u0001\u0012eK\u0012,8-\u001a+bE2,Gj\\2bi&|g.\u0016*J\u0003:$G+\u00192mKRK\b/\u001a\u000b\u0007\u0003\u0017\f9/!;\u0011\u000fi\u000bi-!5\u0002^&\u0019\u0011qZ.\u0003\rQ+\b\u000f\\33!\u0011\t\u0019.!7\u000e\u0005\u0005U'bAAlW\u0006\u0019a.\u001a;\n\t\u0005m\u0017Q\u001b\u0002\u0004+JK\u0005\u0003BAp\u0003Gl!!!9\u000b\u0007m\ty&\u0003\u0003\u0002f\u0006\u0005(\u0001E\"bi\u0006dwn\u001a+bE2,G+\u001f9f\u0011\u0015Ye\u00021\u0001M\u0011\u00151g\u00021\u0001h\u0003E\u0019'/Z1uK\"{w\u000eZ5f)\u0006\u0014G.\u001a\u000b\u0013\u0003#\ty/!=\u0002t\u0006]\u0018\u0011`A\u007f\u0005\u000b\u0011Y\u0003C\u0003L\u001f\u0001\u0007A\nC\u0003Q\u001f\u0001\u0007\u0011\u000bC\u0004\u0002v>\u0001\r!a3\u0002%1|7-\u0016:j\u0003:$G+\u00192mKRK\b/\u001a\u0005\u00061>\u0001\r!\u0017\u0005\u0007\u0003w|\u0001\u0019A4\u0002%\u0005dG\u000eV1cY\u0016\u0004&o\u001c9feRLWm\u001d\u0005\b\u0003\u007f|\u0001\u0019\u0001B\u0001\u000319(/\u001b;f\u001fB$\u0018n\u001c8t!\u0015\u0001(1A8p\u0013\tq\u0017\u0010C\u0004\u0003\b=\u0001\rA!\u0003\u0002\u0017M|WO]2f#V,'/\u001f\t\u00065\n-!qB\u0005\u0004\u0005\u001bY&AB(qi&|g\u000e\u0005\u0003\u0003\u0012\t\u0015b\u0002\u0002B\n\u0005GqAA!\u0006\u0003\"9!!q\u0003B\u0010\u001d\u0011\u0011IB!\b\u000f\u0007I\u0014Y\"C\u0001&\u0013\t\u0019C%\u0003\u0002\"E%\u0011q\u0004I\u0005\u0004\u0003\u0013s\u0012\u0002\u0002B\u0014\u0005S\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005%e\u0004C\u0004\u0003.=\u0001\rAa\f\u0002\u0013=\u0004XM]1uS>t\u0007c\u0001 \u00032%\u0019!1\u0007\u000e\u0003#Q\u000b'\r\\3De\u0016\fG/[8o\u001b>$W-\u0001\tjgB\u000bG\u000f[%eK:$\u0018NZ5feR!\u0011\u0011\u0006B\u001d\u0011\u0015Y\u0005\u00031\u0001M)\u0011\tIC!\u0010\t\u000f\t}\u0012\u00031\u0001\u0003B\u0005)A/\u00192mKB!\u0011q\u001cB\"\u0013\u0011\u0011)%!9\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\u0015\t\u0005%\"\u0011\n\u0005\b\u0005\u0017\u0012\u0002\u0019\u0001B'\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0003\u0002B(\u0005#j!!a\u0018\n\t\tM\u0013q\f\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006Ar-\u001a;Fq&\u001cH/\u001b8h)\u0006\u0014G.Z%g\u000bbL7\u000f^:\u0015\t\te#1\f\t\u00065\n-!\u0011\t\u0005\b\u0005\u007f\u0019\u0002\u0019\u0001B'\u00031\u0019\u0018M^3T_V\u00148-\u001a#G)\u0019\t\tE!\u0019\u0003~!9!q\u0001\u000bA\u0002\t\r\u0004#\u0002.\u0003\f\t\u0015\u0004\u0007\u0002B4\u0005c\u0002R!\u0011B5\u0005[J1Aa\u001b\u001f\u0005\u001d!\u0015\r^1tKR\u0004BAa\u001c\u0003r1\u0001A\u0001\u0004B:\u0005C\n\t\u0011!A\u0003\u0002\tU$aA0%cE!\u0011Q\u0010B<!\rQ&\u0011P\u0005\u0004\u0005wZ&aA!os\"1a\r\u0006a\u0001\u0005\u0003\tQ\u0002S8pI&,7)\u0019;bY><\u0007C\u0001 \u0017'\r1\"Q\u0011\t\u00045\n\u001d\u0015b\u0001BE7\n1\u0011I\\=SK\u001a$\"A!!\u0002#\r|gN^3siR\u0013\u0018M\\:g_Jl7\u000f\u0006\u0003\u0003\u0012\n\u001d\u0006c\u0002.\u0002N\nM%q\u0014\t\u0006\u0005+\u0013Yj\u001c\b\u0005\u0005/\u000b9ID\u0002s\u00053K\u0011\u0001X\u0005\u0005\u0005;\u000byIA\u0002TKF\u0004RA\u0017B\u0006\u0005C\u0003B!a8\u0003$&!!QUAq\u0005)\u0011UoY6fiN\u0003Xm\u0019\u0005\b\u0005SC\u0002\u0019\u0001BV\u0003)!(/\u00198tM>\u0014Xn\u001d\t\u0006\u0005+\u0013Yj\u0018")
public class HoodieCatalog
extends DelegatingCatalogExtension
implements StagingTableCatalog,
SparkAdapterSupport,
ProvidesHoodieConfig {
    private final SparkSession spark;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Tuple2<Seq<String>, Option<BucketSpec>> convertTransforms(Seq<Transform> seq) {
        return HoodieCatalog$.MODULE$.convertTransforms(seq);
    }

    @Override
    public scala.collection.immutable.Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$(this, hoodieCatalogTable);
    }

    @Override
    public scala.collection.immutable.Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, scala.collection.immutable.Map<String, Option<String>> insertPartitions, scala.collection.immutable.Map<String, String> extraOptions, Option<String> staticOverwritePartitionPathOpt) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$(this, hoodieCatalogTable, sparkSession, isOverwritePartition, isOverwriteTable, insertPartitions, extraOptions, staticOverwritePartitionPathOpt);
    }

    @Override
    public scala.collection.immutable.Map<String, Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$5$(this);
    }

    @Override
    public Option<String> buildHoodieInsertConfig$default$7() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$7$(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getDropDupsConfig(boolean useLegacyInsertModeFlow, scala.collection.immutable.Map<String, String> incomingParams) {
        return ProvidesHoodieConfig.getDropDupsConfig$(this, useLegacyInsertModeFlow, incomingParams);
    }

    @Override
    public Tuple4<SaveMode, Object, Object, Option<String>> deduceOverwriteConfig(SparkSession sparkSession, HoodieCatalogTable catalogTable, scala.collection.immutable.Map<String, Option<String>> partitionSpec, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.deduceOverwriteConfig$(this, sparkSession, catalogTable, partitionSpec, extraOptions);
    }

    @Override
    public scala.collection.immutable.Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$(this, sparkSession, hoodieCatalogTable, partitionsToDrop);
    }

    @Override
    public scala.collection.immutable.Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$(this, hoodieCatalogTable, sparkSession);
    }

    @Override
    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$(this, sparkSession, hoodieCatalogTable, tableConfig, extraOptions);
    }

    @Override
    public scala.collection.immutable.Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public StagedTable stageCreate(Identifier x$1, Column[] x$2, Transform[] x$3, java.util.Map<String, String> x$4) throws TableAlreadyExistsException, NoSuchNamespaceException {
        return super.stageCreate(x$1, x$2, x$3, x$4);
    }

    public StagedTable stageReplace(Identifier x$1, Column[] x$2, Transform[] x$3, java.util.Map<String, String> x$4) throws NoSuchNamespaceException, NoSuchTableException {
        return super.stageReplace(x$1, x$2, x$3, x$4);
    }

    public StagedTable stageCreateOrReplace(Identifier x$1, Column[] x$2, Transform[] x$3, java.util.Map<String, String> x$4) throws NoSuchNamespaceException {
        return super.stageCreateOrReplace(x$1, x$2, x$3, x$4);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieCatalog hoodieCatalog = this;
        synchronized (hoodieCatalog) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            return new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitions, properties, TableCreationMode.STAGE_CREATE);
        }
        return new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            return new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitions, properties, TableCreationMode.STAGE_REPLACE);
        }
        super.dropTable(ident);
        return new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        Object object;
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            return new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitions, properties, TableCreationMode.CREATE_OR_REPLACE);
        }
        try {
            object = BoxesRunTime.boxToBoolean((boolean)super.dropTable(ident));
        }
        catch (NoSuchTableException noSuchTableException) {
            object = BoxedUnit.UNIT;
        }
        return new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
    }

    public Table loadTable(Identifier ident) {
        Table table = super.loadTable(ident);
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            CatalogTable catalogTable0 = v1Table.v1Table();
            if (this.sparkAdapter().isHoodieTable(catalogTable0)) {
                CatalogTable catalogTable;
                Option option = catalogTable0.comment();
                if (option instanceof Some) {
                    scala.collection.immutable.Map newProps;
                    Some some = (Some)option;
                    String v = (String)some.value();
                    scala.collection.immutable.Map x$1 = newProps = catalogTable0.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), (Object)v));
                    TableIdentifier x$2 = catalogTable0.copy$default$1();
                    CatalogTableType x$3 = catalogTable0.copy$default$2();
                    CatalogStorageFormat x$4 = catalogTable0.copy$default$3();
                    StructType x$5 = catalogTable0.copy$default$4();
                    Option x$6 = catalogTable0.copy$default$5();
                    Seq x$7 = catalogTable0.copy$default$6();
                    Option x$8 = catalogTable0.copy$default$7();
                    String x$9 = catalogTable0.copy$default$8();
                    long x$10 = catalogTable0.copy$default$9();
                    long x$11 = catalogTable0.copy$default$10();
                    String x$12 = catalogTable0.copy$default$11();
                    Option x$13 = catalogTable0.copy$default$13();
                    Option x$14 = catalogTable0.copy$default$14();
                    Option x$15 = catalogTable0.copy$default$15();
                    Seq x$16 = catalogTable0.copy$default$16();
                    boolean x$17 = catalogTable0.copy$default$17();
                    boolean x$18 = catalogTable0.copy$default$18();
                    scala.collection.immutable.Map x$19 = catalogTable0.copy$default$19();
                    Option x$20 = catalogTable0.copy$default$20();
                    catalogTable = catalogTable0.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
                } else {
                    catalogTable = catalogTable0;
                }
                CatalogTable catalogTable2 = catalogTable;
                HoodieInternalV2Table v2Table = new HoodieInternalV2Table(this.spark(), catalogTable2.location().toString(), (Option<CatalogTable>)new Some((Object)catalogTable2), (Option<String>)new Some((Object)ident.toString()), HoodieInternalV2Table$.MODULE$.apply$default$5());
                boolean schemaEvolutionEnabled = new StringOps(Predef$.MODULE$.augmentString(this.spark().sessionState().conf().getConfString(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key(), DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().defaultValue().toString()))).toBoolean();
                if (schemaEvolutionEnabled) {
                    return v2Table;
                }
                return v2Table.v1TableWrapper();
            }
        }
        return table;
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            return this.createHoodieTable(ident, schema, locUriAndTableType, partitions, properties, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Dataset<Row>>)Option$.MODULE$.empty(), TableCreationMode.CREATE);
        }
        return super.createTable(ident, schema, partitions, properties);
    }

    public boolean tableExists(Identifier ident) {
        return super.tableExists(ident);
    }

    public boolean dropTable(Identifier ident) {
        Table table = this.loadTable(ident);
        Table table2 = table;
        Option<CatalogTable> option = HoodieSpark32PlusAnalysis$HoodieV1OrV2Table$.MODULE$.unapply(table2);
        if (!option.isEmpty()) {
            new DropHoodieTableCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier(), true, false, false).run(this.spark());
            return true;
        }
        return super.dropTable(ident);
    }

    public boolean purgeTable(Identifier ident) {
        Table table = this.loadTable(ident);
        Table table2 = table;
        Option<CatalogTable> option = HoodieSpark32PlusAnalysis$HoodieV1OrV2Table$.MODULE$.unapply(table2);
        if (!option.isEmpty()) {
            new DropHoodieTableCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier(), true, false, true).run(this.spark());
            return true;
        }
        return super.purgeTable(ident);
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        Table table = this.loadTable(oldIdent);
        Option<CatalogTable> option = HoodieSpark32PlusAnalysis$HoodieV1OrV2Table$.MODULE$.unapply(table);
        if (!option.isEmpty()) {
            new AlterHoodieTableRenameCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(oldIdent).asTableIdentifier(), CatalogV2Implicits$.MODULE$.IdentifierHelper(newIdent).asTableIdentifier(), false).run(this.spark());
            return;
        }
        super.renameTable(oldIdent, newIdent);
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        Table table = this.loadTable(ident);
        Option<CatalogTable> option = HoodieSpark32PlusAnalysis$HoodieV1OrV2Table$.MODULE$.unapply(table);
        if (!option.isEmpty()) {
            CatalogTable table2 = (CatalogTable)option.get();
            TableIdentifier tableIdent = TableIdentifier$.MODULE$.apply(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).lastOption());
            changes.groupBy((Function1 & Serializable & scala.Serializable)c -> c.getClass()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    Seq newColumns = (Seq)tuple2._2();
                    Class clazz = t;
                    Class<TableChange.AddColumn> clazz2 = TableChange.AddColumn.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                        return new AlterHoodieTableAddColumnsCommand(tableIdent, (Seq<StructField>)((Seq)newColumns.map((Function1 & Serializable & scala.Serializable)col -> new StructField(col.fieldNames()[0], col.dataType(), col.isNullable(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()))).run(this.spark());
                    }
                }
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    Seq columnChanges = (Seq)tuple2._2();
                    if (TableChange.ColumnChange.class.isAssignableFrom(t)) {
                        columnChanges.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TableChange tableChange = x0$2;
                            if (tableChange instanceof TableChange.UpdateColumnType) {
                                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
                                String colName = new UnresolvedAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnType.fieldNames())).name();
                                DataType newDataType = updateColumnType.newDataType();
                                StructField structField = new StructField(colName, newDataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                                return new AlterHoodieTableChangeColumnCommand(tableIdent, colName, structField).run(this.spark());
                            }
                            if (tableChange instanceof TableChange.UpdateColumnComment) {
                                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
                                String newComment = updateColumnComment.newComment();
                                String colName = new UnresolvedAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames())).name();
                                Option fieldOpt = table2.schema().findNestedField((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames()), true, this.spark().sessionState().conf().resolver(), table2.schema().findNestedField$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> (StructField)x$1._2());
                                StructField field = (StructField)fieldOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                    throw new AnalysisException(new StringBuilder(26).append("Couldn't find column ").append(colName).append(" in:\n").append(table2.schema().treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                                });
                                return new AlterHoodieTableChangeColumnCommand(tableIdent, colName, field.withComment(newComment)).run(this.spark());
                            }
                            throw new MatchError((Object)tableChange);
                        });
                        return BoxedUnit.UNIT;
                    }
                }
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    throw new UnsupportedOperationException(new StringBuilder(28).append("not supported table change: ").append(t.getClass()).toString());
                }
                throw new MatchError((Object)tuple2);
            });
            return this.loadTable(ident);
        }
        return super.alterTable(ident, (TableChange[])changes.toArray(ClassTag$.MODULE$.apply(TableChange.class)));
    }

    private Tuple2<URI, CatalogTableType> deduceTableLocationURIAndTableType(Identifier ident, java.util.Map<String, String> properties) {
        Option locOpt = this.isPathIdentifier(ident) ? Option$.MODULE$.apply((Object)ident.name()) : Option$.MODULE$.apply((Object)properties.get("location"));
        CatalogTableType tableType = locOpt.nonEmpty() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        Option locUriOpt = locOpt.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
        TableIdentifier tableIdent = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier();
        Option<CatalogTable> existingTableOpt = this.getExistingTableIfExists(tableIdent);
        URI locURI = (URI)locUriOpt.orElse((Function0 & Serializable & scala.Serializable)() -> existingTableOpt.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.storage().locationUri())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.spark().sessionState().catalog().defaultTablePath(tableIdent));
        return new Tuple2((Object)locURI, (Object)tableType);
    }

    public Table createHoodieTable(Identifier ident, StructType schema, Tuple2<URI, CatalogTableType> locUriAndTableType, Transform[] partitions, java.util.Map<String, String> allTableProperties, scala.collection.immutable.Map<String, String> writeOptions, Option<Dataset<Row>> sourceQuery, TableCreationMode operation) {
        BoxedUnit boxedUnit;
        Tuple2<Seq<String>, Option<BucketSpec>> tuple2 = HoodieCatalog$.MODULE$.convertTransforms((Seq<Transform>)Predef$.MODULE$.wrapRefArray((Object[])partitions));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionColumns = (Seq)tuple2._1();
        Option maybeBucketSpec = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionColumns, (Object)maybeBucketSpec);
        Seq partitionColumns2 = (Seq)tuple22._1();
        Option maybeBucketSpec2 = (Option)tuple22._2();
        StructType newSchema = schema;
        Seq newPartitionColumns = partitionColumns2;
        Option newBucketSpec = maybeBucketSpec2;
        CatalogStorageFormat qual$1 = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map)writeOptions.$minus$minus(HoodieCatalogTable$.MODULE$.needFilterProps()));
        Option x$1 = Option$.MODULE$.apply(locUriAndTableType._1());
        Option x$2 = qual$1.copy$default$2();
        Option x$3 = qual$1.copy$default$3();
        Option x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        scala.collection.immutable.Map x$6 = qual$1.copy$default$6();
        CatalogStorageFormat storage = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6);
        Option commentOpt = Option$.MODULE$.apply((Object)allTableProperties.get("comment"));
        HashMap<String, String> tablePropertiesNew = new HashMap<String, String>(allTableProperties);
        tablePropertiesNew.put("path", ((URI)locUriAndTableType._1()).getPath());
        TableIdentifier x$7 = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier();
        CatalogTableType x$8 = (CatalogTableType)locUriAndTableType._2();
        CatalogStorageFormat x$9 = storage;
        StructType x$10 = newSchema;
        Option x$11 = Option$.MODULE$.apply((Object)"hudi");
        Seq x$12 = newPartitionColumns;
        Option x$13 = newBucketSpec;
        scala.collection.immutable.Map x$14 = (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(tablePropertiesNew).asScala()).toMap(Predef$.MODULE$.$conforms()).$minus$minus(HoodieCatalogTable$.MODULE$.needFilterProps());
        Option x$15 = commentOpt;
        String x$16 = CatalogTable$.MODULE$.$lessinit$greater$default$8();
        long x$17 = CatalogTable$.MODULE$.$lessinit$greater$default$9();
        long x$18 = CatalogTable$.MODULE$.$lessinit$greater$default$10();
        String x$19 = CatalogTable$.MODULE$.$lessinit$greater$default$11();
        Option x$20 = CatalogTable$.MODULE$.$lessinit$greater$default$13();
        Option x$21 = CatalogTable$.MODULE$.$lessinit$greater$default$14();
        Seq x$22 = CatalogTable$.MODULE$.$lessinit$greater$default$16();
        boolean x$23 = CatalogTable$.MODULE$.$lessinit$greater$default$17();
        boolean x$24 = CatalogTable$.MODULE$.$lessinit$greater$default$18();
        scala.collection.immutable.Map x$25 = CatalogTable$.MODULE$.$lessinit$greater$default$19();
        Option x$26 = CatalogTable$.MODULE$.$lessinit$greater$default$20();
        CatalogTable tableDesc = new CatalogTable(x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$14, x$20, x$21, x$15, x$22, x$23, x$24, x$25, x$26);
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(this.spark(), tableDesc);
        TableCreationMode tableCreationMode = operation;
        TableCreationMode tableCreationMode2 = TableCreationMode.STAGE_CREATE;
        if (!(tableCreationMode != null ? !((Object)((Object)tableCreationMode)).equals((Object)tableCreationMode2) : tableCreationMode2 != null)) {
            String tablePath = hoodieCatalogTable.tableLocation();
            Configuration hadoopConf = this.spark().sessionState().newHadoopConf();
            Predef$.MODULE$.assert(HoodieSqlCommonUtils$.MODULE$.isEmptyPath(tablePath, hadoopConf), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Path '").append(tablePath).append("' should be empty for CTAS").toString());
            hoodieCatalogTable.initHoodieTable();
            scala.collection.immutable.Map<String, String> tblProperties = hoodieCatalogTable.catalogProperties();
            Tuple2[] tuple2Array = new Tuple2[5];
            CatalogTableType catalogTableType = tableDesc.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_CREATE_MANAGED_TABLE().key()), (Object)Boolean.toString(!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)));
            tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_SERDE_PROPERTIES().key()), (Object)ConfigUtils.configToString((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(tblProperties).asJava()));
            tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_PROPERTIES().key()), (Object)ConfigUtils.configToString((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableDesc.properties()).asJava()));
            tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_INSERT_MODE().key()), (Object)InsertMode.NON_STRICT.value());
            tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_ENABLE_BULK_INSERT().key()), (Object)"true");
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties().$plus$plus(this.buildHoodieInsertConfig(hoodieCatalogTable, this.spark(), false, false, (scala.collection.immutable.Map<String, Option<String>>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)options, this.buildHoodieInsertConfig$default$7())));
            CreateHoodieTableCommand$.MODULE$.createTableInCatalog(this.spark(), hoodieCatalogTable, false, CreateHoodieTableCommand$.MODULE$.createTableInCatalog$default$4());
            boxedUnit = BoxedUnit.UNIT;
        } else if (sourceQuery.isEmpty()) {
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties());
            boxedUnit = new CreateHoodieTableCommand(tableDesc, false).run(this.spark());
        } else {
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties().$plus$plus(this.buildHoodieInsertConfig(hoodieCatalogTable, this.spark(), false, false, (scala.collection.immutable.Map<String, Option<String>>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), this.buildHoodieInsertConfig$default$7())));
            boxedUnit = new CreateHoodieTableCommand(tableDesc, false).run(this.spark());
        }
        return this.loadTable(ident);
    }

    private boolean isPathIdentifier(Identifier ident) {
        return new Path(ident.name()).isAbsolute();
    }

    public boolean isPathIdentifier(CatalogTable table) {
        return this.isPathIdentifier(table.identifier());
    }

    public boolean isPathIdentifier(TableIdentifier tableIdentifier) {
        return this.isPathIdentifier(new HoodieIdentifier((String[])Option$.MODULE$.option2Iterable(tableIdentifier.database()).toArray(ClassTag$.MODULE$.apply(String.class)), tableIdentifier.table()));
    }

    private Option<CatalogTable> getExistingTableIfExists(TableIdentifier table) {
        SessionCatalog catalog = this.spark().sessionState().catalog();
        if (this.isPathIdentifier(table)) {
            return None$.MODULE$;
        }
        boolean tableExists = catalog.tableExists(table);
        if (tableExists) {
            CatalogTable oldTable = catalog.getTableMetadata(table);
            CatalogTableType catalogTableType = oldTable.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                throw new HoodieException(new StringBuilder(47).append(table).append(" is a view. You may not write data into a view.").toString());
            }
            if (!this.sparkAdapter().isHoodieTable(oldTable)) {
                throw new HoodieException(new StringBuilder(23).append(table).append(" is not a Hoodie table.").toString());
            }
            return new Some((Object)oldTable);
        }
        return None$.MODULE$;
    }

    private void saveSourceDF(Option<Dataset<?>> sourceQuery, scala.collection.immutable.Map<String, String> properties) {
        sourceQuery.map((Function1 & Serializable & scala.Serializable)df -> {
            df.write().format("org.apache.hudi").options((Map)properties).mode(SaveMode.Append).save();
            return df;
        });
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public HoodieCatalog() {
        SparkAdapterSupport.$init$(this);
        Logging.$init$((Logging)this);
        ProvidesHoodieConfig.$init$(this);
        this.spark = SparkSession$.MODULE$.active();
    }
}

