/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u00180\u0001qB\u0001B\u000e\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0015\"Aq\n\u0001BA\u0002\u0013\u0005\u0001\u000b\u0003\u0005V\u0001\t\u0005\r\u0011\"\u0001W\u0011!a\u0006A!A!B\u0013\t\u0006\"B/\u0001\t\u0003q\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011\u00023\t\u000f5\u0004!\u0019!C\u0001]\"1!\u0010\u0001Q\u0001\n=Dqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B?\t\u0011\u0005\r\u0001A1A\u0005\u00029Dq!!\u0002\u0001A\u0003%q\u000eC\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u0011\u0011\u0003\u0001!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014\u0001A)\u0019!C\u0001\u0003+A!\"!\u000b\u0001\u0011\u000b\u0007I\u0011AA\u0016\u0011%\t\u0019\u0004\u0001EC\u0002\u0013\u0005a\u000eC\u0005\u00026\u0001A)\u0019!C\u0001]\"Q\u0011q\u0007\u0001\t\u0006\u0004%\t!!\u000f\t\u0013\u0005\u001d\u0003\u0001#b\u0001\n\u0003q\u0007BCA%\u0001!\u0015\r\u0011\"\u0001\u0002L!Q\u00111\u000b\u0001\t\u0006\u0004%\t!!\u0016\t\u0015\u0005u\u0003\u0001#b\u0001\n\u0003\tY\u0005C\u0005\u0002`\u0001A)\u0019!C\u0001]\"Q\u0011\u0011\r\u0001\t\u0006\u0004%\t!a\u0019\t\u0015\u0005E\u0004\u0001#b\u0001\n\u0003\t\u0019\u0007\u0003\u0006\u0002t\u0001A)\u0019!C\u0001\u0003GB!\"!\u001e\u0001\u0011\u000b\u0007I\u0011AA2\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!!$\u0001\t\u0003\tI\u0001C\u0004\u0002\u0010\u0002!\t!!%\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005\"CAU\u0001E\u0005I\u0011BAV\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007Dq!a2\u0001\t\u0013\tImB\u0004\u0002j>B\t!a;\u0007\r9z\u0003\u0012AAw\u0011\u0019i\u0006\u0006\"\u0001\u0002p\"I\u0011\u0011\u001f\u0015C\u0002\u0013\u0005\u00111\u001f\u0005\t\u0003wD\u0003\u0015!\u0003\u0002v\"9\u0011Q \u0015\u0005\u0002\u0005}\bbBA\u007fQ\u0011\u0005!q\u0001\u0002\u0013\u0011>|G-[3DCR\fGn\\4UC\ndWM\u0003\u00021c\u000591-\u0019;bY><'B\u0001\u001a4\u0003!\u0019\u0017\r^1msN$(B\u0001\u001b6\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003m]\nQa\u001d9be.T!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO\u000e\u00011c\u0001\u0001>\u0007B\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\u0004\"\u0001R$\u000e\u0003\u0015S!AR\u001b\u0002\u0011%tG/\u001a:oC2L!\u0001S#\u0003\u000f1{wmZ5oOV\t!\n\u0005\u0002L\u00196\t1'\u0003\u0002Ng\ta1\u000b]1sWN+7o]5p]\u000611\u000f]1sW\u0002\nQ\u0001^1cY\u0016,\u0012!\u0015\t\u0003%Nk\u0011aL\u0005\u0003)>\u0012AbQ1uC2|w\rV1cY\u0016\f\u0011\u0002^1cY\u0016|F%Z9\u0015\u0005]S\u0006C\u0001 Y\u0013\tIvH\u0001\u0003V]&$\bbB.\u0005\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\n\u0014A\u0002;bE2,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004?\u0002\f\u0007C\u0001*\u0001\u0011\u00151d\u00011\u0001K\u0011\u0015ye\u00011\u0001R\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002IB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\u0005G>tgM\u0003\u0002jo\u00051\u0001.\u00193p_BL!a\u001b4\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003-A\u0017\rZ8pa\u000e{gN\u001a\u0011\u0002!\r\fG/\u00197pOR\u000b'\r\\3OC6,W#A8\u0011\u0005A<hBA9v!\t\u0011x(D\u0001t\u0015\t!8(\u0001\u0004=e>|GOP\u0005\u0003m~\na\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011aoP\u0001\u0012G\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a(b[\u0016\u0004\u0013!E2bi\u0006dwn\u001a)s_B,'\u000f^5fgV\tQ\u0010\u0005\u0003q}>|\u0017BA@z\u0005\ri\u0015\r]\u0001\u0013G\u0006$\u0018\r\\8h!J|\u0007/\u001a:uS\u0016\u001c\b%A\u0007uC\ndW\rT8dCRLwN\\\u0001\u000fi\u0006\u0014G.\u001a'pG\u0006$\u0018n\u001c8!\u0003EAwn\u001c3jKR\u000b'\r\\3Fq&\u001cHo]\u000b\u0003\u0003\u0017\u00012APA\u0007\u0013\r\tya\u0010\u0002\b\u0005>|G.Z1o\u0003IAwn\u001c3jKR\u000b'\r\\3Fq&\u001cHo\u001d\u0011\u0002\u00155,G/Y\"mS\u0016tG/\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0013\u001b\t\tYBC\u0002P\u0003;QA!a\b\u0002\"\u000511m\\7n_:T1!a\t8\u0003\u0011AW\u000fZ5\n\t\u0005\u001d\u00121\u0004\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0003-!\u0018M\u00197f\u0007>tg-[4\u0016\u0005\u00055\u0002\u0003BA\r\u0003_IA!!\r\u0002\u001c\t\t\u0002j\\8eS\u0016$\u0016M\u00197f\u0007>tg-[4\u0002\u0013Q\f'\r\\3OC6,\u0017\u0001\u00043bi\u0006\u0014\u0017m]3OC6,\u0017!\u0003;bE2,G+\u001f9f+\t\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\u0011\t\t%!\b\u0002\u000b5|G-\u001a7\n\t\u0005\u0015\u0013q\b\u0002\u0010\u0011>|G-[3UC\ndW\rV=qK\u0006iA/\u00192mKRK\b/\u001a(b[\u0016\f1\u0002\u001d:j[\u0006\u0014\u0018pS3zgV\u0011\u0011Q\n\t\u0005}\u0005=s.C\u0002\u0002R}\u0012Q!\u0011:sCf\fQ\u0002\u001d:f\u0007>l'-\u001b8f\u0017\u0016LXCAA,!\u0011q\u0014\u0011L8\n\u0007\u0005msH\u0001\u0004PaRLwN\\\u0001\u0010a\u0006\u0014H/\u001b;j_:4\u0015.\u001a7eg\u0006q!-Y:f\r&dWMR8s[\u0006$\u0018a\u0003;bE2,7k\u00195f[\u0006,\"!!\u001a\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b4\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ty'!\u001b\u0003\u0015M#(/^2u)f\u0004X-\u0001\u000fuC\ndWmU2iK6\fw+\u001b;i_V$X*\u001a;b\r&,G\u000eZ:\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0003E9W\r\u001e)beRLG/[8o!\u0006$\bn]\u000b\u0003\u0003w\u0002R!! \u0002\b>tA!a \u0002\u0004:\u0019!/!!\n\u0003\u0001K1!!\"@\u0003\u001d\u0001\u0018mY6bO\u0016LA!!#\u0002\f\n\u00191+Z9\u000b\u0007\u0005\u0015u(\u0001\njgB\u000b'\u000f^5uS>tW\r\u001a+bE2,\u0017aD5oSRDun\u001c3jKR\u000b'\r\\3\u0015\u0003]\u000bQ\u0003]1sg\u0016\u001c6\r[3nC\u0006sGmQ8oM&<7\u000f\u0006\u0002\u0002\u0018B1a(!'\u0002fuL1!a'@\u0005\u0019!V\u000f\u001d7fe\u0005\u0001R\r\u001f;sCR\u000b'\r\\3D_:4\u0017n\u001a\u000b\u0006{\u0006\u0005\u0016Q\u0015\u0005\b\u0003G\u001b\u0003\u0019AA\u0006\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\t\u0011\u0005\u001d6\u0005%AA\u0002u\f\u0011c\u001c:jO&tG+\u00192mK\u000e{gNZ5h\u0003i)\u0007\u0010\u001e:b)\u0006\u0014G.Z\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tiKK\u0002~\u0003_[#!!-\u0011\t\u0005M\u0016QX\u0007\u0003\u0003kSA!a.\u0002:\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003w{\u0014AC1o]>$\u0018\r^5p]&!\u0011qXA[\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cY>\fG\rV1cY\u0016\u001c6\r[3nC\nKX*\u001a;b\u00072LWM\u001c;\u0015\u0005\u0005\u0015\u0007#\u0002 \u0002Z\u0005\u0015\u0014\u0001\u0005<fe&4\u0017\u0010R1uCN\u001b\u0007.Z7b)\u001d9\u00161ZAl\u0003?Dq!!4'\u0001\u0004\ty-A\buC\ndW-\u00133f]RLg-[3s!\u0011\t\t.a5\u000e\u0003EJ1!!62\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBA\u001cM\u0001\u0007\u0011\u0011\u001c\t\u0004%\u0006m\u0017bAAo_\t\u00012)\u0019;bY><G+\u00192mKRK\b/\u001a\u0005\b\u0003g2\u0003\u0019AAq!\u0019\ti(a\"\u0002dB!\u0011qMAs\u0013\u0011\t9/!\u001b\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u0013\u0011>|G-[3DCR\fGn\\4UC\ndW\r\u0005\u0002SQM\u0011\u0001&\u0010\u000b\u0003\u0003W\fqB\\3fI\u001aKG\u000e^3s!J|\u0007o]\u000b\u0003\u0003k\u0004R!! \u0002x>LA!!?\u0002\f\n!A*[:u\u0003AqW-\u001a3GS2$XM\u001d)s_B\u001c\b%A\u0003baBd\u0017\u0010F\u0003`\u0005\u0003\u0011)\u0001\u0003\u0004\u0003\u00041\u0002\rAS\u0001\rgB\f'o[*fgNLwN\u001c\u0005\b\u0003\u001bd\u0003\u0019AAh)\u0015y&\u0011\u0002B\u0006\u0011\u0019\u0011\u0019!\fa\u0001\u0015\"1!QB\u0017A\u0002E\u000bAbY1uC2|w\rV1cY\u0016\u0004")
public class HoodieCatalogTable
implements Logging {
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private String databaseName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private String baseFileFormat;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType partitionSchema;
    private final SparkSession spark;
    private CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public static List<String> needFilterProps() {
        return HoodieCatalogTable$.MODULE$.needFilterProps();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    public void table_$eq(CatalogTable x$1) {
        this.table = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(HadoopFSUtils.getStorageConfWithCopy(this.hadoopConf())).build();
                this.bitmap$0 |= 1;
            }
        }
        return this.metaClient;
    }

    public HoodieTableMetaClient metaClient() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.metaClient$lzycompute();
        }
        return this.metaClient;
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
        }
        return this.tableConfig;
    }

    public HoodieTableConfig tableConfig() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.tableConfig$lzycompute();
        }
        return this.tableConfig;
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
        }
        return this.tableName;
    }

    public String tableName() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private String databaseName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.databaseName = this.tableConfig().getDatabaseName();
                this.bitmap$0 |= 8;
            }
        }
        return this.databaseName;
    }

    public String databaseName() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.databaseName$lzycompute();
        }
        return this.databaseName;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableType;
    }

    public HoodieTableType tableType() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.tableType$lzycompute();
        }
        return this.tableType;
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.tableTypeName;
    }

    public String tableTypeName() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.tableTypeName$lzycompute();
        }
        return this.tableTypeName;
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.primaryKeys;
    }

    public String[] primaryKeys() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.primaryKeys$lzycompute();
        }
        return this.primaryKeys;
    }

    private Option<String> preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.preCombineKey;
    }

    public Option<String> preCombineKey() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.preCombineKey$lzycompute();
        }
        return this.preCombineKey;
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.partitionFields;
    }

    public String[] partitionFields() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.partitionFields$lzycompute();
        }
        return this.partitionFields;
    }

    private String baseFileFormat$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.baseFileFormat = this.metaClient().getTableConfig().getBaseFileFormat().name();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.baseFileFormat;
    }

    public String baseFileFormat() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.baseFileFormat$lzycompute();
        }
        return this.baseFileFormat;
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                StructType structType;
                Option<StructType> schemaFromMetaOpt = this.loadTableSchemaByMetaClient();
                if (schemaFromMetaOpt.nonEmpty()) {
                    structType = (StructType)schemaFromMetaOpt.get();
                } else if (this.table().schema().nonEmpty()) {
                    structType = HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
                } else {
                    throw new AnalysisException(new StringBuilder(33).append(this.catalogTableName()).append(" does not contains schema fields.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                }
                this.tableSchema = structType;
                this.bitmap$0 |= 0x400;
            }
        }
        return this.tableSchema;
    }

    public StructType tableSchema() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.tableSchema$lzycompute();
        }
        return this.tableSchema;
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.tableSchemaWithoutMetaFields;
    }

    public StructType tableSchemaWithoutMetaFields() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.tableSchemaWithoutMetaFields$lzycompute();
        }
        return this.tableSchemaWithoutMetaFields;
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$dataSchema$1(this, f))));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.dataSchema$lzycompute();
        }
        return this.dataSchema;
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$partitionSchema$1(this, f))));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.partitionSchema$lzycompute();
        }
        return this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        java.util.List<String> droppedPartitions = TimelineUtils.getDroppedPartitions(this.metaClient(), org.apache.hudi.common.util.Option.empty(), org.apache.hudi.common.util.Option.empty());
        return (Seq)HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table(), this.metaClient().getStorage()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$getPartitionPaths$1(droppedPartitions, x$2)));
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public void initHoodieTable() {
        block4: {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initHoodieTable$1(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable ), ()Ljava/lang/String;)((HoodieCatalogTable)this));
            var4_1 = this.parseSchemaAndConfigs();
            if (var4_1 == null) {
                throw new MatchError(var4_1);
            }
            finalSchema = (StructType)var4_1._1();
            tableConfigs = (scala.collection.immutable.Map)var4_1._2();
            var3_4 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
            finalSchema = (StructType)var3_4._1();
            tableConfigs = (scala.collection.immutable.Map)var3_4._2();
            dataSchema = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(finalSchema);
            qual$1 = this.table();
            x$1 = finalSchema;
            x$2 = qual$1.copy$default$1();
            x$3 = qual$1.copy$default$2();
            x$4 = qual$1.copy$default$3();
            x$5 = qual$1.copy$default$5();
            x$6 = qual$1.copy$default$6();
            x$7 = qual$1.copy$default$7();
            x$8 = qual$1.copy$default$8();
            x$9 = qual$1.copy$default$9();
            x$10 = qual$1.copy$default$10();
            x$11 = qual$1.copy$default$11();
            x$12 = qual$1.copy$default$12();
            x$13 = qual$1.copy$default$13();
            x$14 = qual$1.copy$default$14();
            x$15 = qual$1.copy$default$15();
            x$16 = qual$1.copy$default$16();
            x$17 = qual$1.copy$default$17();
            x$18 = qual$1.copy$default$18();
            x$19 = qual$1.copy$default$19();
            x$20 = qual$1.copy$default$20();
            this.table_$eq(qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            properties = TypedProperties.fromMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs).asJava());
            catalogDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initHoodieTable$2(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable ), ()Ljava/lang/String;)((HoodieCatalogTable)this)));
            if (!this.hoodieTableExists()) break block4;
            if (StringUtils.isNullOrEmpty(this.databaseName())) ** GOTO lbl-1000
            v0 = this.databaseName();
            var35_31 = catalogDatabaseName;
            if (!(v0 != null ? v0.equals(var35_31) == false : var35_31 != null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            ValidationUtils.checkArgument(v1, "The database names from this hoodie path and this catalog table is not same.");
            recordName = AvroSchemaUtils.getAvroRecordQualifiedName(this.table().identifier().table());
            x$21 = dataSchema;
            x$22 = recordName;
            x$23 = SchemaConverters$.MODULE$.toAvroType$default$2();
            x$24 = SchemaConverters$.MODULE$.toAvroType$default$4();
            HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(catalogDatabaseName).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)x$21, x$23, x$22, x$24).toString()).initTable(HadoopFSUtils.getStorageConfWithCopy(this.hadoopConf()), this.tableLocation());
            return;
        }
        var42_37 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
        if (var42_37 == null) {
            throw new MatchError(var42_37);
        }
        recordName = (String)var42_37._1();
        namespace = (String)var42_37._2();
        var41_40 = new Tuple2((Object)recordName, (Object)namespace);
        recordName = (String)var41_40._1();
        namespace = (String)var41_40._2();
        schema = SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, recordName, namespace);
        partitionColumns = this.table().partitionColumnNames().isEmpty() != false ? null : this.table().partitionColumnNames().mkString(",");
        HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(catalogDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema.toString()).setPartitionFields(partitionColumns).initTable(HadoopFSUtils.getStorageConfWithCopy(this.hadoopConf()), this.tableLocation());
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
        globalSqlOptions = HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(globalTableConfigs);
        sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(this.catalogProperties())));
        var9_5 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
        if (var9_5 == null) ** GOTO lbl-1000
        var10_6 = (CatalogTableType)var9_5._1();
        var11_7 = var9_5._2$mcZ$sp();
        v0 = CatalogTableType$.MODULE$.EXTERNAL();
        var12_8 = var10_6;
        if (!(v0 != null ? v0.equals(var12_8) == false : var12_8 != null) && var11_7) {
            existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
            catalogTableProps = HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(this.catalogProperties());
            HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
            options = this.extraTableConfig(this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
            v1 = new Tuple2((Object)this.tableSchema(), (Object)options);
        } else if (var9_5 != null && !(var17_13 = var9_5._2$mcZ$sp())) {
            ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.table().schema();
            options = this.extraTableConfig(false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions));
            v1 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema), (Object)options);
        } else {
            if (var9_5 != null) {
                var20_16 = (CatalogTableType)var9_5._1();
                var21_17 = var9_5._2$mcZ$sp();
                v2 = CatalogTableType$.MODULE$.MANAGED();
                var22_18 = var20_16;
                if (!(v2 != null ? v2.equals(var22_18) == false : var22_18 != null) && var21_17) {
                    throw new AnalysisException(new StringBuilder(81).append("Can not create the managed table('").append(this.catalogTableName()).append("')").append(". The associated location('").append(this.tableLocation()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                }
            }
            throw new MatchError((Object)var9_5);
        }
        var8_19 = v1;
        if (var8_19 == null) {
            throw new MatchError((Object)var8_19);
        }
        finalSchema = (StructType)var8_19._1();
        tableConfigs = (scala.collection.immutable.Map)var8_19._2();
        var7_22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        finalSchema = (StructType)var7_22._1();
        tableConfigs = (scala.collection.immutable.Map)var7_22._2();
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema, HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions((scala.collection.immutable.Map<String, String>)tableConfigs));
        resolver = this.spark().sessionState().conf().resolver();
        dataSchema = (Seq)finalSchema.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseSchemaAndConfigs$1$adapted(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable scala.Function2 org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((HoodieCatalogTable)this, (Function2)resolver));
        this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema);
        return new Tuple2((Object)finalSchema, (Object)tableConfigs);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(boolean tableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (tableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            String primaryKeys = this.table().properties().getOrElse((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName(), (Function0 & Serializable & scala.Serializable)() -> this.table().storage().properties().get((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName())).toString();
            String partitions = this.table().partitionColumnNames().mkString(",");
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)DataSourceOptionsHelper$.MODULE$.inferKeyGenClazz(primaryKeys, partitions));
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StructType> loadTableSchemaByMetaClient() {
        None$ none$;
        Function2 resolver2 = this.spark().sessionState().conf().resolver();
        try {
            none$ = HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).map((Function1 & Serializable & scala.Serializable)originSchema -> {
                Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                    boolean x$1 = true;
                    String x$2 = f.copy$default$1();
                    DataType x$3 = f.copy$default$2();
                    Metadata x$4 = f.copy$default$4();
                    StructField nullableField = f.copy(x$2, x$3, x$1, x$4);
                    Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.table().schema(), nullableField.name(), (Function2<String, String, Object>)resolver2);
                    if (catalogField.isDefined()) {
                        return (StructField)((StructField)catalogField.get()).getComment().map((Function1 & Serializable & scala.Serializable)comment -> nullableField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> nullableField);
                    }
                    return nullableField;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$loadTableSchemaByMetaClient$5(this, f)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField[] partFields = (StructField[])tuple2._1();
                StructField[] dataFields = (StructField[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)partFields, (Object)dataFields);
                StructField[] partFields2 = (StructField[])tuple22._1();
                StructField[] dataFields2 = (StructField[])tuple22._2();
                scala.collection.immutable.Map nameToField = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFields2)).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Seq orderedPartFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionFields())).map((Function1 & Serializable & scala.Serializable)x$8 -> (StructField)nameToField.apply(x$8), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).toSeq();
                return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFields2)).$plus$plus((GenTraversableOnce)orderedPartFields, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            });
        }
        catch (Throwable cause) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load table schema from meta client.", cause);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema) {
        CatalogTableType catalogTableType = tableType;
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2)) {
            Seq invalidChars = (Seq)new .colon.colon((Object)",", (List)new .colon.colon((Object)":", (List)new .colon.colon((Object)";", (List)Nil$.MODULE$)));
            dataSchema.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HoodieCatalogTable.$anonfun$verifyDataSchema$4(tableIdentifier, invalidChars, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$partitionSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionPaths$1(java.util.List droppedPartitions$1, String x$2) {
        return !droppedPartitions$1.contains(x$2);
    }

    public static final /* synthetic */ String $anonfun$initHoodieTable$1(HoodieCatalogTable $this) {
        return new StringBuilder(27).append("Init hoodie.properties for ").append($this.table().identifier().unquotedString()).toString();
    }

    public static final /* synthetic */ String $anonfun$initHoodieTable$2(HoodieCatalogTable $this) {
        return $this.spark().sessionState().catalog().getCurrentDatabase();
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$2(Function2 resolver$1, StructField f$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$6, (Object)f$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$1(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return $this.table().partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$2(resolver$1, f, x$6)));
    }

    public static final /* synthetic */ boolean $anonfun$loadTableSchemaByMetaClient$5(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$verifyDataSchema$2(StructField f$2, CharSequence x$1) {
        return f$2.name().contains(x$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$1(Seq invalidChars$1, TableIdentifier tableIdentifier$1, StructField f) {
        DataType dataType = f.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            return;
        }
        if (invalidChars$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$verifyDataSchema$2(f, x$1)))) {
            String invalidCharsString = ((TraversableOnce)invalidChars$1.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append((String)c).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            String errMsg = new StringBuilder(123).append("Cannot create a table having a nested column whose name contains ").append("invalid characters (").append(invalidCharsString).append(") in Hive metastore. Table: ").append(tableIdentifier$1).append("; ").append("Column: ").append(f.name()).toString();
            throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
    }

    private static final void verifyNestedColumnNames$1(StructType schema, Seq invalidChars$1, TableIdentifier tableIdentifier$1) {
        schema.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HoodieCatalogTable.$anonfun$verifyDataSchema$1(invalidChars$1, tableIdentifier$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$4(TableIdentifier tableIdentifier$1, Seq invalidChars$1, StructField f) {
        DataType dataType = f.dataType();
        if (f.name().contains(",")) {
            throw new AnalysisException(new StringBuilder(101).append("Cannot create a table having a column whose name ").append("contains commas in Hive metastore. Table: ").append(tableIdentifier$1).append("; Column: ").append(f.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            return;
        }
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.$init$((Logging)this);
        Object object = this.table().provider().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        ValidationUtils.checkArgument(!(object != null ? !object.equals(string) : string != null), new StringBuilder(21).append(" ").append(this.table().qualifiedName()).append(" is not a Hudi table").toString());
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = this.table().qualifiedName();
        this.catalogProperties = HoodieOptionConfig$.MODULE$.makeOptionsCaseInsensitive((scala.collection.immutable.Map<String, String>)this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties()));
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(this.table(), spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }

    public static final /* synthetic */ Object $anonfun$parseSchemaAndConfigs$1$adapted(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$1($this, resolver$1, f));
    }
}

