/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.Serializable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hudi.common.function.SerializableSupplier;
import org.apache.hudi.common.function.ThrowingConsumer;
import org.apache.hudi.common.util.ValidationUtils;

@ThreadSafe
public class Transient<T>
implements Serializable {
    private SerializableSupplier<T> initializer;
    private transient boolean initialized;
    private transient T ref;

    private Transient(SerializableSupplier<T> initializer) {
        ValidationUtils.checkArgument(initializer != null);
        this.initializer = initializer;
        this.ref = null;
        this.initialized = false;
    }

    private Transient(T value, SerializableSupplier<T> initializer) {
        ValidationUtils.checkArgument(value != null);
        ValidationUtils.checkArgument(initializer != null);
        this.initializer = initializer;
        this.ref = value;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (!this.initialized) {
            Transient transient_ = this;
            synchronized (transient_) {
                if (!this.initialized) {
                    this.ref = this.initializer.get();
                    this.initialized = true;
                }
            }
        }
        return this.ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Transient transient_ = this;
        synchronized (transient_) {
            this.ref = null;
            this.initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(ThrowingConsumer<T> cleaner) throws Exception {
        Transient transient_ = this;
        synchronized (transient_) {
            if (this.initialized) {
                cleaner.accept(this.ref);
            }
            this.ref = null;
            this.initialized = false;
            this.initializer = null;
        }
    }

    public static <T> Transient<T> lazy(SerializableSupplier<T> initializer) {
        return new Transient<T>(initializer);
    }

    public static <T> Transient<T> eager(T value, SerializableSupplier<T> initializer) {
        return new Transient<T>(value, initializer);
    }
}

