/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.table.timeline.dto.BaseFileDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.Handler;

public class BaseFileHandler
extends Handler {
    public BaseFileHandler(StorageConfiguration<?> conf, TimelineService.Config timelineServiceConfig, HoodieStorage storage, FileSystemViewManager viewManager) throws IOException {
        super(conf, timelineServiceConfig, storage, viewManager);
    }

    public List<BaseFileDTO> getLatestDataFiles(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFiles(partitionPath).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public List<BaseFileDTO> getLatestDataFile(String basePath, String partitionPath, String fileId) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFile(partitionPath, fileId).map(BaseFileDTO::fromHoodieBaseFile).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public List<BaseFileDTO> getLatestDataFiles(String basePath) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFiles().map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public List<BaseFileDTO> getLatestDataFilesBeforeOrOn(String basePath, String partitionPath, String maxInstantTime) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFilesBeforeOrOn(partitionPath, maxInstantTime).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public Map<String, List<BaseFileDTO>> getAllLatestDataFilesBeforeOrOn(String basePath, String maxInstantTime) {
        return this.viewManager.getFileSystemView(basePath).getAllLatestBaseFilesBeforeOrOn(maxInstantTime).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Stream)entry.getValue()).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList())));
    }

    public List<BaseFileDTO> getLatestDataFileOn(String basePath, String partitionPath, String instantTime, String fileId) {
        return this.viewManager.getFileSystemView(basePath).getBaseFileOn(partitionPath, instantTime, fileId).map(BaseFileDTO::fromHoodieBaseFile).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public List<BaseFileDTO> getLatestDataFilesInRange(String basePath, List<String> instants) {
        return this.viewManager.getFileSystemView(basePath).getLatestBaseFilesInRange(instants).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }

    public List<BaseFileDTO> getAllDataFiles(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getAllBaseFiles(partitionPath).map(BaseFileDTO::fromHoodieBaseFile).collect(Collectors.toList());
    }
}

