/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.BoundedIOCompactionStrategy;

public class LogFileNumBasedCompactionStrategy
extends BoundedIOCompactionStrategy
implements Comparator<HoodieCompactionOperation> {
    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        Long numThreshold = writeConfig.getCompactionLogFileNumThreshold();
        List<HoodieCompactionOperation> filterOperator = operations.stream().filter(e -> (long)e.getDeltaFilePaths().size() >= numThreshold).sorted(this).collect(Collectors.toList());
        return super.orderAndFilter(writeConfig, filterOperator, pendingCompactionPlans);
    }

    @Override
    public int compare(HoodieCompactionOperation hco1, HoodieCompactionOperation hco2) {
        return hco2.getDeltaFilePaths().size() - hco1.getDeltaFilePaths().size();
    }
}

