/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentHashingUpdateStrategyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistentHashingUpdateStrategyUtils.class);

    public static Map<String, Pair<String, ConsistentBucketIdentifier>> constructPartitionToIdentifier(Set<String> partitions, HoodieTable table) {
        List instantPlanPairs = table.getMetaClient().getActiveTimeline().filterInflightsAndRequested().filter(instant -> instant.getAction().equals("replacecommit")).getInstantsAsStream().map(instant -> ClusteringUtils.getClusteringPlan(table.getMetaClient(), instant)).flatMap(o -> o.isPresent() ? Stream.of(o.get()) : Stream.empty()).collect(Collectors.toList());
        HashMap<String, HoodieConsistentHashingMetadata> partitionToHashingMeta = new HashMap<String, HoodieConsistentHashingMetadata>();
        HashMap<String, String> partitionToInstant = new HashMap<String, String>();
        for (Pair pair : instantPlanPairs) {
            String instant2 = ((HoodieInstant)pair.getLeft()).getTimestamp();
            HoodieClusteringPlan plan = (HoodieClusteringPlan)((Object)pair.getRight());
            ConsistentHashingUpdateStrategyUtils.extractHashingMetadataFromClusteringPlan(instant2, plan, table, partitions, partitionToHashingMeta, partitionToInstant);
        }
        return partitionToHashingMeta.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Pair.of(partitionToInstant.get(e.getKey()), new ConsistentBucketIdentifier((HoodieConsistentHashingMetadata)e.getValue()))));
    }

    private static void extractHashingMetadataFromClusteringPlan(String instant, HoodieClusteringPlan plan, HoodieTable table, Set<String> recordPartitions, Map<String, HoodieConsistentHashingMetadata> partitionToHashingMeta, Map<String, String> partitionToInstant) {
        for (HoodieClusteringGroup group : plan.getInputGroups()) {
            Map<String, String> groupMeta = group.getExtraMetadata();
            String p = groupMeta.get("clustering.group.partition");
            ValidationUtils.checkState(p != null, "Clustering plan does not has partition info, plan: " + (Object)((Object)plan));
            if (!recordPartitions.contains(p)) continue;
            String preInstant = partitionToInstant.putIfAbsent(p, instant);
            ValidationUtils.checkState(preInstant == null || preInstant.equals(instant), "Find a partition: " + p + " with two clustering instants");
            if (!partitionToHashingMeta.containsKey(p)) {
                Option<HoodieConsistentHashingMetadata> metadataOption = ConsistentBucketIndexUtils.loadMetadata(table, p);
                ValidationUtils.checkState(metadataOption.isPresent(), "Failed to load consistent hashing metadata for partition: " + p);
                partitionToHashingMeta.put(p, metadataOption.get());
            }
            try {
                String nodeJson = group.getExtraMetadata().get("clustering.group.child.node");
                List<ConsistentHashingNode> nodes = ConsistentHashingNode.fromJsonString(nodeJson);
                partitionToHashingMeta.get(p).getChildrenNodes().addAll(nodes);
            }
            catch (Exception e) {
                LOG.error("Failed to parse child nodes in clustering plan.", (Throwable)e);
                throw new HoodieException("Failed to parse child nodes in clustering plan, partition: " + p + ", cluster group: " + (Object)((Object)group), e);
            }
        }
    }
}

