/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage.inline;

import java.io.File;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StoragePath;

public class InLineFSUtils {
    public static final String SCHEME = "inlinefs";
    protected static final String START_OFFSET_STR = "start_offset";
    protected static final String LENGTH_STR = "length";
    protected static final String SCHEME_SEPARATOR = ":";
    protected static final String EQUALS_STR = "=";
    protected static final String LOCAL_FILESYSTEM_SCHEME = "file";

    public static StoragePath getInlineFilePath(StoragePath outerPath, String origScheme, long inLineStartOffset, long inLineLength) {
        String subPath = new File(outerPath.toString().substring(outerPath.toString().indexOf(SCHEME_SEPARATOR) + 1)).getPath();
        return new StoragePath("inlinefs:/" + subPath + "/" + origScheme + "/" + "?" + START_OFFSET_STR + EQUALS_STR + inLineStartOffset + "&" + LENGTH_STR + EQUALS_STR + inLineLength);
    }

    public static StoragePath getOuterFilePathFromInlinePath(StoragePath inlineFSPath) {
        InLineFSUtils.assertInlineFSPath(inlineFSPath);
        String outerFileScheme = inlineFSPath.getParent().getName();
        StoragePath basePath = inlineFSPath.getParent().getParent();
        ValidationUtils.checkArgument(basePath.toString().contains(SCHEME_SEPARATOR), "Invalid InLineFS path: " + inlineFSPath);
        String pathExceptScheme = basePath.toString().substring(basePath.toString().indexOf(SCHEME_SEPARATOR) + 1);
        String fullPath = outerFileScheme + SCHEME_SEPARATOR + (outerFileScheme.equals(LOCAL_FILESYSTEM_SCHEME) ? "/" : "") + pathExceptScheme;
        return new StoragePath(fullPath);
    }

    public static long startOffset(StoragePath inlineFSPath) {
        InLineFSUtils.assertInlineFSPath(inlineFSPath);
        String[] slices = inlineFSPath.toString().split("[?&=]");
        return Long.parseLong(slices[slices.length - 3]);
    }

    public static long length(StoragePath inlinePath) {
        InLineFSUtils.assertInlineFSPath(inlinePath);
        String[] slices = inlinePath.toString().split("[?&=]");
        return Long.parseLong(slices[slices.length - 1]);
    }

    private static void assertInlineFSPath(StoragePath inlinePath) {
        String scheme2 = inlinePath.toUri().getScheme();
        ValidationUtils.checkArgument(SCHEME.equals(scheme2));
    }
}

