/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.wal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.SequenceId;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication", "Coprocesssor"})
public interface WALKey
extends SequenceId,
Comparable<WALKey> {
    public static final List<UUID> EMPTY_UUIDS = Collections.unmodifiableList(new ArrayList());

    default public long estimatedSerializedSizeOf() {
        return 0L;
    }

    public byte[] getEncodedRegionName();

    public TableName getTableName();

    public long getWriteTime();

    default public long getNonceGroup() {
        return 0L;
    }

    default public long getNonce() {
        return 0L;
    }

    public UUID getOriginatingClusterId();

    public long getOrigLogSeqNum();

    public void addExtendedAttribute(String var1, byte[] var2);

    default public byte[] getExtendedAttribute(String attributeKey) {
        return null;
    }

    default public Map<String, byte[]> getExtendedAttributes() {
        return new HashMap<String, byte[]>();
    }

    default public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("table", this.getTableName());
        stringMap.put("region", Bytes.toStringBinary(this.getEncodedRegionName()));
        stringMap.put("sequence", this.getSequenceId());
        Map<String, byte[]> extendedAttributes = this.getExtendedAttributes();
        if (extendedAttributes != null) {
            for (Map.Entry<String, byte[]> entry : extendedAttributes.entrySet()) {
                stringMap.put(entry.getKey(), Bytes.toStringBinary(entry.getValue()));
            }
        }
        return stringMap;
    }
}

