/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.tool;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.tool.DataBlockEncodingValidator;
import org.apache.hudi.org.apache.hadoop.hbase.tool.HFileContentValidator;
import org.apache.hudi.org.apache.hadoop.hbase.tool.coprocessor.CoprocessorValidator;
import org.apache.hudi.org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class PreUpgradeValidator
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(PreUpgradeValidator.class);
    public static final String TOOL_NAME = "pre-upgrade";
    public static final String VALIDATE_CP_NAME = "validate-cp";
    public static final String VALIDATE_DBE_NAME = "validate-dbe";
    public static final String VALIDATE_HFILE = "validate-hfile";
    private Configuration configuration;

    public Configuration getConf() {
        return this.configuration;
    }

    public void setConf(Configuration conf) {
        this.configuration = conf;
    }

    private void printUsage() {
        System.out.println("usage: hbase pre-upgrade command ...");
        System.out.println("Available commands:");
        System.out.printf(" %-15s Validate co-processors are compatible with HBase%n", VALIDATE_CP_NAME);
        System.out.printf(" %-15s Validate DataBlockEncodings are compatible with HBase%n", VALIDATE_DBE_NAME);
        System.out.printf(" %-15s Validate HFile contents are readable%n", VALIDATE_HFILE);
        System.out.println("For further information, please use command -h");
    }

    public int run(String[] args2) throws Exception {
        AbstractHBaseTool tool;
        if (args2.length == 0) {
            this.printUsage();
            return 1;
        }
        switch (args2[0]) {
            case "validate-cp": {
                tool = new CoprocessorValidator();
                break;
            }
            case "validate-dbe": {
                tool = new DataBlockEncodingValidator();
                break;
            }
            case "validate-hfile": {
                tool = new HFileContentValidator();
                break;
            }
            case "-h": {
                this.printUsage();
                return 1;
            }
            default: {
                System.err.println("Unknown command: " + args2[0]);
                this.printUsage();
                return 1;
            }
        }
        tool.setConf(this.getConf());
        return tool.run(Arrays.copyOfRange(args2, 1, args2.length));
    }

    public static void main(String[] args2) {
        int ret;
        Configuration conf = HBaseConfiguration.create();
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new PreUpgradeValidator(), (String[])args2);
        }
        catch (Exception e) {
            LOG.error("Error running command-line tool", (Throwable)e);
            ret = 1;
        }
        System.exit(ret);
    }
}

