/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServerQuotaSource;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsRegionServerQuotaSourceImpl
extends BaseSourceImpl
implements MetricsRegionServerQuotaSource {
    private final Meter tablesInViolationCounter;
    private final Meter spaceQuotaSnapshotsReceived;
    private final Timer fileSystemUtilizationChoreTimer;
    private final Timer spaceQuotaRefresherChoreTimer;
    private final Counter regionSizeReportCounter;
    private final Timer regionSizeReportingChoreTimer;

    public MetricsRegionServerQuotaSourceImpl() {
        this("Quotas", "Metrics about HBase RegionServer Quotas", "regionserver", "RegionServer,sub=Quotas");
    }

    public MetricsRegionServerQuotaSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.tablesInViolationCounter = this.registry.meter("numTablesInViolation");
        this.spaceQuotaSnapshotsReceived = this.registry.meter("numSpaceSnapshotsReceived");
        this.fileSystemUtilizationChoreTimer = this.registry.timer("fileSystemUtilizationChoreTime");
        this.spaceQuotaRefresherChoreTimer = this.registry.timer("spaceQuotaRefresherChoreTime");
        this.regionSizeReportCounter = this.registry.counter("numRegionSizeReports");
        this.regionSizeReportingChoreTimer = this.registry.timer("regionSizeReportingChoreTime");
    }

    @Override
    public void updateNumTablesInSpaceQuotaViolation(long tablesInViolation) {
        this.tablesInViolationCounter.mark(tablesInViolation);
    }

    @Override
    public void updateNumTableSpaceQuotaSnapshots(long numSnapshots) {
        this.spaceQuotaSnapshotsReceived.mark(numSnapshots);
    }

    @Override
    public void incrementSpaceQuotaFileSystemScannerChoreTime(long time) {
        this.fileSystemUtilizationChoreTimer.updateMillis(time);
    }

    @Override
    public void incrementSpaceQuotaRefresherChoreTime(long time) {
        this.spaceQuotaRefresherChoreTimer.updateMillis(time);
    }

    @Override
    public void incrementNumRegionSizeReportsSent(long numReportsSent) {
        this.regionSizeReportCounter.increment(numReportsSent);
    }

    @Override
    public void incrementRegionSizeReportingChoreTime(long time) {
        this.regionSizeReportingChoreTimer.update(time, TimeUnit.MILLISECONDS);
    }
}

