/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionSourceImpl;
import org.apache.hudi.org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsRegionAggregateSourceImpl
extends BaseSourceImpl
implements MetricsRegionAggregateSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRegionAggregateSourceImpl.class);
    private final MetricsExecutorImpl executor = new MetricsExecutorImpl();
    private final Set<MetricsRegionSource> regionSources = Collections.newSetFromMap(new ConcurrentHashMap());

    public MetricsRegionAggregateSourceImpl() {
        this("Regions", "Metrics about HBase RegionServer regions and tables", "regionserver", "RegionServer,sub=Regions");
    }

    public MetricsRegionAggregateSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.executor.getExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                JmxCacheBuster.clearJmxCache();
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    @Override
    public void register(MetricsRegionSource source) {
        this.regionSources.add(source);
        this.clearCache();
    }

    @Override
    public void deregister(MetricsRegionSource toRemove) {
        try {
            this.regionSources.remove(toRemove);
        }
        catch (Exception e) {
            LOG.info("Error trying to remove " + toRemove + " from " + this.getClass().getSimpleName(), (Throwable)e);
        }
        this.clearCache();
    }

    private synchronized void clearCache() {
        JmxCacheBuster.clearJmxCache();
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder mrb = collector.addRecord(this.metricsName);
        if (this.regionSources != null) {
            for (MetricsRegionSource regionMetricSource : this.regionSources) {
                if (!(regionMetricSource instanceof MetricsRegionSourceImpl)) continue;
                ((MetricsRegionSourceImpl)regionMetricSource).snapshot(mrb, all);
            }
            this.metricsRegistry.snapshot(mrb, all);
        }
    }
}

