/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HeapMemoryTuner;
import org.apache.hudi.org.apache.hadoop.hbase.util.RollingStatCalculator;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DefaultHeapMemoryTuner
implements HeapMemoryTuner {
    public static final String MAX_STEP_KEY = "hbase.regionserver.heapmemory.autotuner.step.max";
    public static final String MIN_STEP_KEY = "hbase.regionserver.heapmemory.autotuner.step.min";
    public static final String SUFFICIENT_MEMORY_LEVEL_KEY = "hbase.regionserver.heapmemory.autotuner.sufficient.memory.level";
    public static final String LOOKUP_PERIODS_KEY = "hbase.regionserver.heapmemory.autotuner.lookup.periods";
    public static final String NUM_PERIODS_TO_IGNORE = "hbase.regionserver.heapmemory.autotuner.ignored.periods";
    public static final float DEFAULT_MAX_STEP_VALUE = 0.04f;
    public static final float DEFAULT_MIN_STEP_VALUE = 0.00125f;
    public static final float DEFAULT_SUFFICIENT_MEMORY_LEVEL_VALUE = 0.5f;
    public static final int DEFAULT_LOOKUP_PERIODS = 60;
    public static final int DEFAULT_NUM_PERIODS_IGNORED = 60;
    private static final HeapMemoryManager.TunerResult NO_OP_TUNER_RESULT = new HeapMemoryManager.TunerResult(false);
    private static final double TUNER_STEP_EPS = 1.0E-6;
    private Logger LOG = LoggerFactory.getLogger(DefaultHeapMemoryTuner.class);
    private HeapMemoryManager.TunerResult TUNER_RESULT = new HeapMemoryManager.TunerResult(true);
    private Configuration conf;
    private float sufficientMemoryLevel = 0.5f;
    private float maximumStepSize = 0.04f;
    private float minimumStepSize = 0.00125f;
    private int tunerLookupPeriods = 60;
    private int numPeriodsToIgnore = 60;
    private int ignoreInitialPeriods = 0;
    private float globalMemStorePercentMinRange;
    private float globalMemStorePercentMaxRange;
    private float blockCachePercentMinRange;
    private float blockCachePercentMaxRange;
    private float globalMemStoreLimitLowMarkPercent;
    private RollingStatCalculator rollingStatsForCacheMisses;
    private RollingStatCalculator rollingStatsForFlushes;
    private RollingStatCalculator rollingStatsForEvictions;
    private RollingStatCalculator rollingStatsForTunerSteps;
    private float step = 0.04f;
    private StepDirection prevTuneDirection = StepDirection.NEUTRAL;
    private double decayingTunerStepSizeSum = 0.0;

    DefaultHeapMemoryTuner() {
    }

    @Override
    public HeapMemoryManager.TunerResult tune(HeapMemoryManager.TunerContext context) {
        float newBlockCacheSize;
        float newMemstoreSize;
        float curMemstoreSize = context.getCurMemStoreSize();
        float curBlockCacheSize = context.getCurBlockCacheSize();
        this.addToRollingStats(context);
        if (this.ignoreInitialPeriods < this.numPeriodsToIgnore) {
            ++this.ignoreInitialPeriods;
            this.rollingStatsForTunerSteps.insertDataValue(0L);
            return NO_OP_TUNER_RESULT;
        }
        StepDirection newTuneDirection = this.getTuneDirection(context);
        long blockedFlushCount = context.getBlockedFlushCount();
        long unblockedFlushCount = context.getUnblockedFlushCount();
        long totalOnheapFlushCount = blockedFlushCount + unblockedFlushCount;
        boolean offheapMemstore = context.isOffheapMemStore();
        if (this.prevTuneDirection == StepDirection.NEUTRAL && newTuneDirection != StepDirection.NEUTRAL && this.rollingStatsForTunerSteps.getDeviation() < 1.0E-6) {
            this.step = this.maximumStepSize;
        } else if ((newTuneDirection == StepDirection.INCREASE_MEMSTORE_SIZE && this.decayingTunerStepSizeSum < 0.0 || newTuneDirection == StepDirection.INCREASE_BLOCK_CACHE_SIZE && this.decayingTunerStepSizeSum > 0.0) && !offheapMemstore && this.step != this.minimumStepSize) {
            this.step /= 2.0f;
        }
        if (this.step < this.minimumStepSize) {
            this.LOG.debug("Tuner step size is too low; we will not perform any tuning this time.");
            this.step = 0.0f;
            newTuneDirection = StepDirection.NEUTRAL;
        }
        if (totalOnheapFlushCount == 0L && offheapMemstore && newTuneDirection == StepDirection.INCREASE_BLOCK_CACHE_SIZE) {
            this.step = this.minimumStepSize;
        }
        float minMemstoreSize = (this.globalMemStoreLimitLowMarkPercent + 1.0f) * curMemstoreSize / 2.0f;
        switch (newTuneDirection) {
            case INCREASE_BLOCK_CACHE_SIZE: {
                if (curMemstoreSize - this.step < minMemstoreSize) {
                    this.step = curMemstoreSize - minMemstoreSize;
                }
                newMemstoreSize = curMemstoreSize - this.step;
                newBlockCacheSize = curBlockCacheSize + this.step;
                this.rollingStatsForTunerSteps.insertDataValue(-((int)(this.step * 100000.0f)));
                this.decayingTunerStepSizeSum = (this.decayingTunerStepSizeSum - (double)this.step) / 2.0;
                break;
            }
            case INCREASE_MEMSTORE_SIZE: {
                newBlockCacheSize = curBlockCacheSize - this.step;
                newMemstoreSize = curMemstoreSize + this.step;
                this.rollingStatsForTunerSteps.insertDataValue((int)(this.step * 100000.0f));
                this.decayingTunerStepSizeSum = (this.decayingTunerStepSizeSum + (double)this.step) / 2.0;
                break;
            }
            default: {
                this.prevTuneDirection = StepDirection.NEUTRAL;
                this.rollingStatsForTunerSteps.insertDataValue(0L);
                this.decayingTunerStepSizeSum /= 2.0;
                return NO_OP_TUNER_RESULT;
            }
        }
        if (newMemstoreSize > this.globalMemStorePercentMaxRange) {
            newMemstoreSize = this.globalMemStorePercentMaxRange;
        } else if (newMemstoreSize < this.globalMemStorePercentMinRange) {
            newMemstoreSize = this.globalMemStorePercentMinRange;
        }
        if (newBlockCacheSize > this.blockCachePercentMaxRange) {
            newBlockCacheSize = this.blockCachePercentMaxRange;
        } else if (newBlockCacheSize < this.blockCachePercentMinRange) {
            newBlockCacheSize = this.blockCachePercentMinRange;
        }
        this.TUNER_RESULT.setBlockCacheSize(newBlockCacheSize);
        this.TUNER_RESULT.setMemStoreSize(newMemstoreSize);
        this.prevTuneDirection = newTuneDirection;
        return this.TUNER_RESULT;
    }

    private StepDirection getTuneDirection(HeapMemoryManager.TunerContext context) {
        boolean earlyBlockCacheSufficientCheck;
        StepDirection newTuneDirection = StepDirection.NEUTRAL;
        long blockedFlushCount = context.getBlockedFlushCount();
        long unblockedFlushCount = context.getUnblockedFlushCount();
        long evictCount = context.getEvictCount();
        long cacheMissCount = context.getCacheMissCount();
        long totalFlushCount = blockedFlushCount + unblockedFlushCount;
        float curMemstoreSize = context.getCurMemStoreSize();
        float curBlockCacheSize = context.getCurBlockCacheSize();
        StringBuilder tunerLog = new StringBuilder();
        boolean earlyMemstoreSufficientCheck = totalFlushCount == 0L || context.getCurMemStoreUsed() < curMemstoreSize * this.sufficientMemoryLevel;
        boolean bl = earlyBlockCacheSufficientCheck = evictCount == 0L || context.getCurBlockCacheUsed() < curBlockCacheSize * this.sufficientMemoryLevel;
        if (earlyMemstoreSufficientCheck && earlyBlockCacheSufficientCheck) {
            newTuneDirection = StepDirection.NEUTRAL;
        } else if (earlyMemstoreSufficientCheck) {
            newTuneDirection = StepDirection.INCREASE_BLOCK_CACHE_SIZE;
        } else if (earlyBlockCacheSufficientCheck) {
            newTuneDirection = StepDirection.INCREASE_MEMSTORE_SIZE;
        } else {
            boolean isReverting = false;
            switch (this.prevTuneDirection) {
                case INCREASE_BLOCK_CACHE_SIZE: {
                    if (!((double)evictCount > this.rollingStatsForEvictions.getMean()) && !((double)totalFlushCount > this.rollingStatsForFlushes.getMean() + this.rollingStatsForFlushes.getDeviation() / 2.0)) break;
                    newTuneDirection = StepDirection.INCREASE_MEMSTORE_SIZE;
                    tunerLog.append("We will revert previous tuning");
                    if ((double)evictCount > this.rollingStatsForEvictions.getMean()) {
                        tunerLog.append(" because we could not decrease evictions sufficiently.");
                    } else {
                        tunerLog.append(" because the number of flushes rose significantly.");
                    }
                    isReverting = true;
                    break;
                }
                case INCREASE_MEMSTORE_SIZE: {
                    if (!((double)totalFlushCount > this.rollingStatsForFlushes.getMean()) && !((double)evictCount > this.rollingStatsForEvictions.getMean() + this.rollingStatsForEvictions.getDeviation() / 2.0)) break;
                    newTuneDirection = StepDirection.INCREASE_BLOCK_CACHE_SIZE;
                    tunerLog.append("We will revert previous tuning");
                    if ((double)totalFlushCount > this.rollingStatsForFlushes.getMean()) {
                        tunerLog.append(" because we could not decrease flushes sufficiently.");
                    } else {
                        tunerLog.append(" because number of evictions rose significantly.");
                    }
                    isReverting = true;
                    break;
                }
            }
            if (!isReverting) {
                if ((double)cacheMissCount < this.rollingStatsForCacheMisses.getMean() - this.rollingStatsForCacheMisses.getDeviation() * 0.8 && (double)totalFlushCount < this.rollingStatsForFlushes.getMean() - this.rollingStatsForFlushes.getDeviation() * 0.8) {
                    newTuneDirection = StepDirection.NEUTRAL;
                } else if ((double)cacheMissCount > this.rollingStatsForCacheMisses.getMean() + this.rollingStatsForCacheMisses.getDeviation() * 0.8 && (double)totalFlushCount < this.rollingStatsForFlushes.getMean() - this.rollingStatsForFlushes.getDeviation() * 0.8) {
                    newTuneDirection = StepDirection.INCREASE_BLOCK_CACHE_SIZE;
                    tunerLog.append("Going to increase block cache size due to increase in number of cache misses.");
                } else if ((double)cacheMissCount < this.rollingStatsForCacheMisses.getMean() - this.rollingStatsForCacheMisses.getDeviation() * 0.8 && (double)totalFlushCount > this.rollingStatsForFlushes.getMean() + this.rollingStatsForFlushes.getDeviation() * 0.8) {
                    newTuneDirection = StepDirection.INCREASE_MEMSTORE_SIZE;
                    tunerLog.append("Going to increase memstore size due to increase in number of flushes.");
                } else if (blockedFlushCount > 0L && this.prevTuneDirection == StepDirection.NEUTRAL) {
                    newTuneDirection = StepDirection.INCREASE_MEMSTORE_SIZE;
                    tunerLog.append("Going to increase memstore size due to" + blockedFlushCount + " blocked flushes.");
                } else {
                    tunerLog.append("Going to do nothing because we could not determine best tuning direction");
                    newTuneDirection = StepDirection.NEUTRAL;
                }
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(tunerLog.toString());
        }
        return newTuneDirection;
    }

    private void addToRollingStats(HeapMemoryManager.TunerContext context) {
        this.rollingStatsForCacheMisses.insertDataValue(context.getCacheMissCount());
        this.rollingStatsForFlushes.insertDataValue(context.getBlockedFlushCount() + context.getUnblockedFlushCount());
        this.rollingStatsForEvictions.insertDataValue(context.getEvictCount());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.maximumStepSize = conf.getFloat(MAX_STEP_KEY, 0.04f);
        this.minimumStepSize = conf.getFloat(MIN_STEP_KEY, 0.00125f);
        this.step = this.maximumStepSize;
        this.sufficientMemoryLevel = conf.getFloat(SUFFICIENT_MEMORY_LEVEL_KEY, 0.5f);
        this.tunerLookupPeriods = conf.getInt(LOOKUP_PERIODS_KEY, 60);
        this.blockCachePercentMinRange = conf.getFloat("hfile.block.cache.size.min.range", conf.getFloat("hfile.block.cache.size", 0.4f));
        this.blockCachePercentMaxRange = conf.getFloat("hfile.block.cache.size.max.range", conf.getFloat("hfile.block.cache.size", 0.4f));
        this.globalMemStorePercentMinRange = conf.getFloat("hbase.regionserver.global.memstore.size.min.range", MemorySizeUtil.getGlobalMemStoreHeapPercent(conf, false));
        this.globalMemStorePercentMaxRange = conf.getFloat("hbase.regionserver.global.memstore.size.max.range", MemorySizeUtil.getGlobalMemStoreHeapPercent(conf, false));
        this.globalMemStoreLimitLowMarkPercent = MemorySizeUtil.getGlobalMemStoreHeapLowerMark(conf, true);
        this.numPeriodsToIgnore = conf.getInt(NUM_PERIODS_TO_IGNORE, this.tunerLookupPeriods);
        this.rollingStatsForCacheMisses = new RollingStatCalculator(this.tunerLookupPeriods);
        this.rollingStatsForFlushes = new RollingStatCalculator(this.tunerLookupPeriods);
        this.rollingStatsForEvictions = new RollingStatCalculator(this.tunerLookupPeriods);
        this.rollingStatsForTunerSteps = new RollingStatCalculator(this.tunerLookupPeriods);
    }

    private static enum StepDirection {
        INCREASE_BLOCK_CACHE_SIZE,
        INCREASE_MEMSTORE_SIZE,
        NEUTRAL;

    }
}

