/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.constant;

import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;

@ConfigClassProperty(name="Key Generator Options", groupName=ConfigGroups.Names.WRITE_CLIENT, subGroupName=ConfigGroups.SubGroupNames.KEY_GENERATOR, areCommonConfigs=true, description="")
public class KeyGeneratorOptions
extends HoodieConfig {
    public static final ConfigProperty<String> URL_ENCODE_PARTITIONING = ConfigProperty.key("hoodie.datasource.write.partitionpath.urlencode").defaultValue("false").markAdvanced().withDocumentation("Should we url encode the partition path value, before creating the folder structure.");
    public static final ConfigProperty<String> HIVE_STYLE_PARTITIONING_ENABLE = ConfigProperty.key("hoodie.datasource.write.hive_style_partitioning").defaultValue("false").withDocumentation("Flag to indicate whether to use Hive style partitioning.\nIf set true, the names of partition folders follow <partition_column_name>=<partition_value> format.\nBy default false (the names of partition folders are only partition values)");
    public static final ConfigProperty<String> RECORDKEY_FIELD_NAME = ConfigProperty.key("hoodie.datasource.write.recordkey.field").noDefaultValue().withDocumentation("Record key field. Value to be used as the `recordKey` component of `HoodieKey`.\nActual value will be obtained by invoking .toString() on the field value. Nested fields can be specified using\nthe dot notation eg: `a.b.c`");
    public static final ConfigProperty<String> PARTITIONPATH_FIELD_NAME = ConfigProperty.key("hoodie.datasource.write.partitionpath.field").noDefaultValue().withDocumentation("Partition path field. Value to be used at the partitionPath component of HoodieKey. Actual value obtained by invoking .toString()");
    public static final ConfigProperty<String> KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED = ConfigProperty.key("hoodie.datasource.write.keygenerator.consistent.logical.timestamp.enabled").defaultValue("false").sinceVersion("0.10.1").markAdvanced().withDocumentation("When set to true, consistent value will be generated for a logical timestamp type column, like timestamp-millis and timestamp-micros, irrespective of whether row-writer is enabled. Disabled by default so as not to break the pipeline that deploy either fully row-writer path or non row-writer path. For example, if it is kept disabled then record key of timestamp type with value `2016-12-29 09:54:00` will be written as timestamp `2016-12-29 09:54:00.0` in row-writer path, while it will be written as long value `1483023240000000` in non row-writer path. If enabled, then the timestamp value will be written in both the cases.");
    @Deprecated
    public static final String URL_ENCODE_PARTITIONING_OPT_KEY = URL_ENCODE_PARTITIONING.key();
    @Deprecated
    public static final String DEFAULT_URL_ENCODE_PARTITIONING_OPT_VAL = URL_ENCODE_PARTITIONING.defaultValue();
    @Deprecated
    public static final String HIVE_STYLE_PARTITIONING_OPT_KEY = HIVE_STYLE_PARTITIONING_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL = HIVE_STYLE_PARTITIONING_ENABLE.defaultValue();
    @Deprecated
    public static final String RECORDKEY_FIELD_OPT_KEY = RECORDKEY_FIELD_NAME.key();
    @Deprecated
    public static final String PARTITIONPATH_FIELD_OPT_KEY = PARTITIONPATH_FIELD_NAME.key();

    @Deprecated
    public static class Config {
        @Deprecated
        public static final String TIMESTAMP_TYPE_FIELD_PROP = TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD.key();
        @Deprecated
        public static final String INPUT_TIME_UNIT = TimestampKeyGeneratorConfig.INPUT_TIME_UNIT.key();
        @Deprecated
        public static final String TIMESTAMP_INPUT_DATE_FORMAT_PROP = TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT.key();
        @Deprecated
        public static final String TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX_PROP = TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX.key();
        @Deprecated
        public static final String TIMESTAMP_INPUT_TIMEZONE_FORMAT_PROP = TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_TIMEZONE_FORMAT.key();
        @Deprecated
        public static final String TIMESTAMP_OUTPUT_DATE_FORMAT_PROP = TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT.key();
        @Deprecated
        public static final String TIMESTAMP_TIMEZONE_FORMAT_PROP = TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT.key();
        @Deprecated
        public static final String TIMESTAMP_OUTPUT_TIMEZONE_FORMAT_PROP = TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_TIMEZONE_FORMAT.key();
        @Deprecated
        public static final String DATE_TIME_PARSER_PROP = TimestampKeyGeneratorConfig.DATE_TIME_PARSER.key();
    }
}

