/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.ByteArraySeekableDataInputStream;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieNativeAvroHFileReader
extends HoodieAvroHFileReaderImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieNativeAvroHFileReader.class);
    private final HoodieStorage storage;
    private final Option<StoragePath> path;
    private final Option<byte[]> bytesContent;
    private Option<HFileReader> sharedHFileReader;
    private final Lazy<Schema> schema;

    public HoodieNativeAvroHFileReader(HoodieStorage storage, StoragePath path, Option<Schema> schemaOption) {
        this.storage = storage;
        this.path = Option.of(path);
        this.bytesContent = Option.empty();
        this.sharedHFileReader = Option.empty();
        this.schema = schemaOption.map(Lazy::eagerly).orElseGet(() -> Lazy.lazily(() -> HoodieNativeAvroHFileReader.fetchSchema(this.getSharedHFileReader())));
    }

    public HoodieNativeAvroHFileReader(HoodieStorage storage, byte[] content, Option<Schema> schemaOption) {
        this.storage = storage;
        this.path = Option.empty();
        this.bytesContent = Option.of(content);
        this.sharedHFileReader = Option.empty();
        this.schema = schemaOption.map(Lazy::eagerly).orElseGet(() -> Lazy.lazily(() -> HoodieNativeAvroHFileReader.fetchSchema(this.getSharedHFileReader())));
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        if (!Objects.equals(readerSchema, requestedSchema)) {
            throw new UnsupportedOperationException("Schema projections are not supported in HFile reader");
        }
        HFileReader reader = this.newHFileReader();
        return new RecordIterator(reader, this.getSchema(), readerSchema);
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        HFileReader reader = this.getSharedHFileReader();
        try {
            return new String[]{StringUtils.fromUTF8Bytes(reader.getMetaInfo(new UTF8StringKey("minRecordKey")).get()), StringUtils.fromUTF8Bytes(reader.getMetaInfo(new UTF8StringKey("maxRecordKey")).get())};
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot read min and max record keys from HFile.", e);
        }
    }

    @Override
    public BloomFilter readBloomFilter() {
        try {
            HFileReader reader = this.getSharedHFileReader();
            ByteBuffer byteBuffer = reader.getMetaBlock("bloomFilter").get();
            return BloomFilterFactory.fromByteBuffer(byteBuffer, StringUtils.fromUTF8Bytes(reader.getMetaInfo(new UTF8StringKey("bloomFilterTypeCode")).get()));
        }
        catch (IOException e) {
            throw new HoodieException("Could not read bloom filter from " + this.path, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        try (HFileReader reader = this.newHFileReader();){
            reader.seekTo();
            Set<String> set = new TreeSet<String>(candidateRowKeys).stream().filter(k -> {
                try {
                    return reader.seekTo(new UTF8StringKey((String)k)) == 0;
                }
                catch (IOException e) {
                    LOG.error("Failed to check key availability: " + k);
                    return false;
                }
            }).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to filter row keys in HFiles", e);
        }
    }

    @Override
    public ClosableIterator<String> getRecordKeyIterator() throws IOException {
        final HFileReader reader = this.newHFileReader();
        return new ClosableIterator<String>(){

            @Override
            public boolean hasNext() {
                try {
                    return reader.next();
                }
                catch (IOException e) {
                    throw new HoodieException("Error while scanning for keys", e);
                }
            }

            @Override
            public String next() {
                try {
                    return reader.getKeyValue().get().getKey().getContentInString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new HoodieIOException("Error closing the HFile reader", e);
                }
            }
        };
    }

    @Override
    public Schema getSchema() {
        return this.schema.get();
    }

    @Override
    public void close() {
        try {
            if (this.sharedHFileReader.isPresent()) {
                this.sharedHFileReader.get().close();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error closing the HFile reader", e);
        }
    }

    @Override
    public long getTotalRecords() {
        return this.getSharedHFileReader().getNumKeyValueEntries();
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeysIterator(List<String> sortedKeys, Schema schema) throws IOException {
        HFileReader reader = this.newHFileReader();
        RecordByKeyIterator iterator2 = new RecordByKeyIterator(reader, sortedKeys, this.getSchema(), schema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeyPrefixIterator(List<String> sortedKeyPrefixes, Schema schema) throws IOException {
        HFileReader reader = this.newHFileReader();
        RecordByKeyPrefixIterator iterator2 = new RecordByKeyPrefixIterator(reader, sortedKeyPrefixes, this.getSchema(), schema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    private static Schema fetchSchema(HFileReader reader) {
        try {
            return new Schema.Parser().parse(StringUtils.fromUTF8Bytes(reader.getMetaInfo(new UTF8StringKey("schema")).get()));
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read schema from HFile", e);
        }
    }

    private static GenericRecord getRecordFromKeyValue(KeyValue keyValue, Schema writerSchema, Schema readerSchema) throws IOException {
        byte[] bytes = keyValue.getBytes();
        return HoodieNativeAvroHFileReader.deserialize(bytes, keyValue.getKeyContentOffset(), keyValue.getKeyContentLength(), bytes, keyValue.getValueOffset(), keyValue.getValueLength(), writerSchema, readerSchema);
    }

    private synchronized HFileReader getSharedHFileReader() {
        try {
            if (!this.sharedHFileReader.isPresent()) {
                this.sharedHFileReader = Option.of(this.newHFileReader());
            }
            return this.sharedHFileReader.get();
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to construct HFile reader", e);
        }
    }

    private HFileReader newHFileReader() throws IOException {
        SeekableDataInputStream inputStream;
        long fileSize;
        if (this.path.isPresent()) {
            fileSize = this.storage.getPathInfo(this.path.get()).getLength();
            inputStream = this.storage.openSeekable(this.path.get(), false);
        } else {
            fileSize = this.bytesContent.get().length;
            inputStream = new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream(this.bytesContent.get()));
        }
        return new HFileReaderImpl(inputStream, fileSize);
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeysIterator(List<String> sortedKeys, Schema readerSchema) throws IOException {
        HFileReader reader = this.newHFileReader();
        return new RecordByKeyIterator(reader, sortedKeys, this.getSchema(), this.schema.get());
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeyPrefixIterator(List<String> sortedKeyPrefixes, Schema readerSchema) throws IOException {
        HFileReader reader = this.newHFileReader();
        return new RecordByKeyPrefixIterator(reader, sortedKeyPrefixes, this.getSchema(), readerSchema);
    }

    private static class RecordByKeyPrefixIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> sortedKeyPrefixesIterator;
        private Iterator<IndexedRecord> recordsIterator;
        private final HFileReader reader;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;
        private boolean isFirstKeyPrefix = true;

        RecordByKeyPrefixIterator(HFileReader reader, List<String> sortedKeyPrefixes, Schema writerSchema, Schema readerSchema) throws IOException {
            this.sortedKeyPrefixesIterator = sortedKeyPrefixes.iterator();
            this.reader = reader;
            this.reader.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.next != null) {
                        return true;
                    }
                    if (this.recordsIterator != null && this.recordsIterator.hasNext()) {
                        this.next = this.recordsIterator.next();
                        return true;
                    }
                    if (!this.sortedKeyPrefixesIterator.hasNext()) break;
                    this.recordsIterator = RecordByKeyPrefixIterator.getRecordByKeyPrefixIteratorInternal(this.reader, this.isFirstKeyPrefix, this.sortedKeyPrefixesIterator.next(), this.writerSchema, this.readerSchema);
                    this.isFirstKeyPrefix = false;
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to read next record from HFile", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the HFile reader and scanner", e);
            }
        }

        private static Iterator<IndexedRecord> getRecordByKeyPrefixIteratorInternal(final HFileReader reader, boolean isFirstKeyPrefix, String keyPrefix, final Schema writerSchema, final Schema readerSchema) throws IOException {
            final UTF8StringKey lookUpKeyPrefix = new UTF8StringKey(keyPrefix);
            if (!isFirstKeyPrefix) {
                Option<KeyValue> keyValue = reader.getKeyValue();
                if (!keyValue.isPresent()) {
                    return Collections.emptyIterator();
                }
                if (!HFileUtils.isPrefixOfKey(lookUpKeyPrefix, keyValue.get().getKey())) {
                    if (lookUpKeyPrefix.compareTo(keyValue.get().getKey()) < 0) {
                        return Collections.emptyIterator();
                    }
                    int val = reader.seekTo(lookUpKeyPrefix);
                    if (val >= 1 && !reader.next()) {
                        return Collections.emptyIterator();
                    }
                }
            } else {
                int val = reader.seekTo(lookUpKeyPrefix);
                if (val >= 1 && !reader.next()) {
                    return Collections.emptyIterator();
                }
            }
            class KeyPrefixIterator
            implements Iterator<IndexedRecord> {
                private IndexedRecord next = null;
                private boolean eof = false;

                KeyPrefixIterator() {
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    if (this.eof) {
                        return false;
                    }
                    try {
                        KeyValue keyValue = reader.getKeyValue().get();
                        if (!HFileUtils.isPrefixOfKey(lookUpKeyPrefix, keyValue.getKey())) {
                            return false;
                        }
                        byte[] bytes = keyValue.getBytes();
                        this.next = HoodieAvroHFileReaderImplBase.deserialize(bytes, keyValue.getKeyContentOffset(), keyValue.getKeyContentLength(), bytes, keyValue.getValueOffset(), keyValue.getValueLength(), writerSchema, readerSchema);
                        this.eof = !reader.next();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to deserialize payload", e);
                    }
                    return true;
                }

                @Override
                public IndexedRecord next() {
                    IndexedRecord next = this.next;
                    this.next = null;
                    return next;
                }
            }
            return new KeyPrefixIterator();
        }
    }

    private static class RecordByKeyIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> sortedKeyIterator;
        private final HFileReader reader;
        private final Schema readerSchema;
        private final Schema writerSchema;
        private IndexedRecord next = null;

        RecordByKeyIterator(HFileReader reader, List<String> sortedKeys, Schema writerSchema, Schema readerSchema) throws IOException {
            this.sortedKeyIterator = sortedKeys.iterator();
            this.reader = reader;
            this.reader.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.next != null) {
                    return true;
                }
                while (this.sortedKeyIterator.hasNext()) {
                    UTF8StringKey key = new UTF8StringKey(this.sortedKeyIterator.next());
                    if (this.reader.seekTo(key) != 0) continue;
                    KeyValue keyValue = this.reader.getKeyValue().get();
                    this.next = HoodieAvroHFileReaderImplBase.deserialize(key.getBytes(), key.getContentOffset(), key.getContentLength(), keyValue.getBytes(), keyValue.getValueOffset(), keyValue.getValueLength(), this.writerSchema, this.readerSchema);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to read next record from HFile ", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the HFile reader", e);
            }
        }
    }

    private static class RecordIterator
    implements ClosableIterator<IndexedRecord> {
        private final HFileReader reader;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;
        private boolean eof = false;

        RecordIterator(HFileReader reader, Schema writerSchema, Schema readerSchema) {
            this.reader = reader;
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.eof) {
                    return false;
                }
                if (this.next != null) {
                    return true;
                }
                boolean hasRecords = !this.reader.isSeeked() ? this.reader.seekTo() : this.reader.next();
                if (!hasRecords) {
                    this.eof = true;
                    return false;
                }
                this.next = HoodieNativeAvroHFileReader.getRecordFromKeyValue(this.reader.getKeyValue().get(), this.writerSchema, this.readerSchema);
                return true;
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to read next record from hfile ", io);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the HFile reader", e);
            }
        }
    }
}

