/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.util.IOUtils;

public class KeyValue {
    public static final int KEY_OFFSET = 8;
    private final byte[] bytes;
    private final int offset;
    private final Key key;

    public KeyValue(byte[] bytes, int offset) {
        this.bytes = bytes;
        this.offset = offset;
        this.key = new Key(bytes, offset + 8, IOUtils.readInt(bytes, offset));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Key getKey() {
        return this.key;
    }

    public int getKeyContentOffset() {
        return this.key.getContentOffset();
    }

    public int getKeyLength() {
        return this.key.getLength();
    }

    public int getKeyOffset() {
        return this.key.getOffset();
    }

    public int getKeyContentLength() {
        return this.key.getContentLength();
    }

    public int getValueOffset() {
        return this.getKeyOffset() + this.getKeyLength();
    }

    public int getValueLength() {
        return IOUtils.readInt(this.bytes, this.offset + 4);
    }

    public String toString() {
        return "KeyValue{key=" + this.key.toString() + "}";
    }
}

