/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hadoop.HoodieAvroOrcReader;
import org.apache.hudi.io.hadoop.HoodieAvroParquetReader;
import org.apache.hudi.io.hadoop.HoodieHBaseAvroHFileReader;
import org.apache.hudi.io.storage.HoodieAvroBootstrapFileReader;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieNativeAvroHFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class HoodieAvroFileReaderFactory
extends HoodieFileReaderFactory {
    public HoodieAvroFileReaderFactory(HoodieStorage storage) {
        super(storage);
    }

    @Override
    protected HoodieFileReader newParquetFileReader(StoragePath path) {
        return new HoodieAvroParquetReader(this.storage, path);
    }

    @Override
    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePath path, Option<Schema> schemaOption) throws IOException {
        if (HoodieAvroFileReaderFactory.isUseNativeHFileReaderEnabled(hoodieConfig)) {
            return new HoodieNativeAvroHFileReader(this.storage, path, schemaOption);
        }
        if (schemaOption.isPresent()) {
            return new HoodieHBaseAvroHFileReader(this.storage.getConf(), path, schemaOption);
        }
        return new HoodieHBaseAvroHFileReader(this.storage.getConf(), path);
    }

    @Override
    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePath path, HoodieStorage storage, byte[] content, Option<Schema> schemaOption) throws IOException {
        if (HoodieAvroFileReaderFactory.isUseNativeHFileReaderEnabled(hoodieConfig)) {
            return new HoodieNativeAvroHFileReader(this.storage, content, schemaOption);
        }
        return new HoodieHBaseAvroHFileReader(this.storage.getConf(), path, storage, content, schemaOption);
    }

    @Override
    protected HoodieFileReader newOrcFileReader(StoragePath path) {
        return new HoodieAvroOrcReader(this.storage, path);
    }

    @Override
    public HoodieFileReader newBootstrapFileReader(HoodieFileReader skeletonFileReader, HoodieFileReader dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        return new HoodieAvroBootstrapFileReader(skeletonFileReader, dataFileReader, partitionFields, partitionValues);
    }
}

