/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;

@ThreadSafe
public class CachingPath
extends Path {
    private volatile Path parent;
    private volatile String fileName;
    private volatile String fullPathStr;

    public CachingPath(String parent, String child) {
        super(parent, child);
    }

    public CachingPath(Path parent, String child) {
        super(parent, child);
    }

    public CachingPath(String parent, Path child) {
        super(parent, child);
    }

    public CachingPath(Path parent, Path child) {
        super(parent, child);
    }

    public CachingPath(String pathString) throws IllegalArgumentException {
        super(pathString);
    }

    public CachingPath(URI aUri) {
        super(aUri);
    }

    public String getName() {
        if (this.fileName == null) {
            this.fileName = super.getName();
        }
        return this.fileName;
    }

    public Path getParent() {
        if (this.parent == null) {
            this.parent = super.getParent();
        }
        return this.parent;
    }

    public String toString() {
        if (this.fullPathStr == null) {
            this.fullPathStr = super.toString();
        }
        return this.fullPathStr;
    }

    public CachingPath subPath(String relativePath) {
        return new CachingPath((Path)this, (Path)CachingPath.createRelativePathUnsafe(relativePath));
    }

    public static CachingPath wrap(Path path) {
        if (path instanceof CachingPath) {
            return (CachingPath)path;
        }
        return new CachingPath(path.toUri());
    }

    public static CachingPath createRelativePathUnsafe(String relativePath) {
        try {
            URI uri2 = new URI(null, null, relativePath, null, null);
            return new CachingPath(uri2);
        }
        catch (URISyntaxException e) {
            throw new HoodieException("Failed to instantiate relative path", e);
        }
    }

    public static CachingPath concatPathUnsafe(Path basePath, Path relativePath) {
        ValidationUtils.checkState(!relativePath.toUri().isAbsolute());
        return CachingPath.concatPathUnsafe(basePath, relativePath.toUri().getPath());
    }

    public static CachingPath concatPathUnsafe(Path basePath, String relativePath) {
        try {
            URI baseURI = basePath.toUri();
            String resolvedPath = CachingPath.resolveRelativePath(baseURI.getPath(), relativePath);
            URI resolvedURI = new URI(baseURI.getScheme(), baseURI.getAuthority(), resolvedPath, baseURI.getQuery(), baseURI.getFragment());
            return new CachingPath(resolvedURI);
        }
        catch (URISyntaxException e) {
            throw new HoodieException("Failed to instantiate relative path", e);
        }
    }

    private static String resolveRelativePath(String basePath, String relativePath) {
        StringBuffer sb = new StringBuffer(basePath);
        if (basePath.endsWith("/")) {
            if (relativePath.startsWith("/")) {
                sb.append(relativePath.substring(1));
            } else {
                sb.append(relativePath);
            }
        } else if (relativePath.startsWith("/")) {
            sb.append(relativePath);
        } else {
            sb.append('/');
            sb.append(relativePath);
        }
        return sb.toString();
    }

    public static Path getPathWithoutSchemeAndAuthority(Path path) {
        return path.isUriPathAbsolute() ? CachingPath.createRelativePathUnsafe(path.toUri().getPath()) : path;
    }
}

