/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.queue;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.queue.BaseHoodieQueueBasedExecutor;
import org.apache.hudi.common.util.queue.DisruptorMessageQueue;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.common.util.queue.HoodieMessageQueue;
import org.apache.hudi.common.util.queue.HoodieProducer;
import org.apache.hudi.common.util.queue.IteratorBasedQueueProducer;

public class DisruptorExecutor<I, O, E>
extends BaseHoodieQueueBasedExecutor<I, O, E> {
    public DisruptorExecutor(Integer bufferSize, Iterator<I> inputItr, HoodieConsumer<O, E> consumer, Function<I, O> transformFunction, String waitStrategy, Runnable preExecuteRunnable) {
        this((int)bufferSize, Collections.singletonList(new IteratorBasedQueueProducer<I>(inputItr)), consumer, transformFunction, waitStrategy, preExecuteRunnable);
    }

    public DisruptorExecutor(int bufferSize, List<HoodieProducer<I>> producers, HoodieConsumer<O, E> consumer, Function<I, O> transformFunction, String waitStrategyId, Runnable preExecuteRunnable) {
        super(producers, Option.of(consumer), new DisruptorMessageQueue<I, O>(bufferSize, transformFunction, waitStrategyId, producers.size(), preExecuteRunnable), preExecuteRunnable);
    }

    @Override
    protected void setUp() {
        DisruptorMessageQueue disruptorQueue = (DisruptorMessageQueue)this.queue;
        disruptorQueue.setHandlers((HoodieConsumer)this.consumer.get());
        disruptorQueue.start();
    }

    @Override
    protected void doConsume(HoodieMessageQueue<I, O> queue, HoodieConsumer<O, E> consumer) {
    }
}

