/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.BitSet;

public class PartitionPathEncodeUtils {
    public static final String DEPRECATED_DEFAULT_PARTITION_PATH = "default";
    public static final String DEFAULT_PARTITION_PATH = "__HIVE_DEFAULT_PARTITION__";
    static BitSet charToEscape;

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return PartitionPathEncodeUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return DEFAULT_PARTITION_PATH;
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (PartitionPathEncodeUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapePartitionValue(String value) {
        if (value == null || value.isEmpty()) {
            return DEFAULT_PARTITION_PATH;
        }
        return PartitionPathEncodeUtils.escapePathName(value);
    }

    static {
        char[] clist;
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
    }
}

