/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public abstract class FileFormatUtils {
    public Set<String> readRowKeys(HoodieStorage storage, StoragePath filePath) {
        return this.filterRowKeys(storage, filePath, new HashSet<String>());
    }

    public BloomFilter readBloomFilterFromMetadata(HoodieStorage storage, StoragePath filePath) {
        Map<String, String> footerVals = this.readFooter(storage, false, filePath, "org.apache.hudi.bloomfilter", "com.uber.hoodie.bloomfilter", "hoodie_bloom_filter_type_code");
        String footerVal = footerVals.get("org.apache.hudi.bloomfilter");
        if (null == footerVal) {
            footerVal = footerVals.get("com.uber.hoodie.bloomfilter");
        }
        BloomFilter toReturn = null;
        if (footerVal != null) {
            toReturn = footerVals.containsKey("hoodie_bloom_filter_type_code") ? BloomFilterFactory.fromString(footerVal, footerVals.get("hoodie_bloom_filter_type_code")) : BloomFilterFactory.fromString(footerVal, BloomFilterTypeCode.SIMPLE.name());
        }
        return toReturn;
    }

    public String[] readMinMaxRecordKeys(HoodieStorage storage, StoragePath filePath) {
        Map<String, String> minMaxKeys = this.readFooter(storage, true, filePath, "hoodie_min_record_key", "hoodie_max_record_key");
        if (minMaxKeys.size() != 2) {
            throw new HoodieException(String.format("Could not read min/max record key out of footer correctly from %s. read) : %s", filePath, minMaxKeys));
        }
        return new String[]{minMaxKeys.get("hoodie_min_record_key"), minMaxKeys.get("hoodie_max_record_key")};
    }

    public abstract List<GenericRecord> readAvroRecords(HoodieStorage var1, StoragePath var2);

    public abstract List<GenericRecord> readAvroRecords(HoodieStorage var1, StoragePath var2, Schema var3);

    public abstract Map<String, String> readFooter(HoodieStorage var1, boolean var2, StoragePath var3, String ... var4);

    public abstract long getRowCount(HoodieStorage var1, StoragePath var2);

    public abstract Set<String> filterRowKeys(HoodieStorage var1, StoragePath var2, Set<String> var3);

    public abstract List<HoodieKey> fetchHoodieKeys(HoodieStorage var1, StoragePath var2);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage var1, StoragePath var2, Option<BaseKeyGenerator> var3);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage var1, StoragePath var2);

    public abstract List<HoodieKey> fetchHoodieKeys(HoodieStorage var1, StoragePath var2, Option<BaseKeyGenerator> var3);

    public abstract Schema readAvroSchema(HoodieStorage var1, StoragePath var2);

    public abstract List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage var1, StoragePath var2, List<String> var3);

    public abstract HoodieFileFormat getFormat();

    public abstract void writeMetaFile(HoodieStorage var1, StoragePath var2, Properties var3) throws IOException;

    public abstract byte[] serializeRecordsToLogBlock(HoodieStorage var1, List<HoodieRecord> var2, Schema var3, Schema var4, String var5, Map<String, String> var6) throws IOException;
}

