/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieMetaserverBasedTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metaserver.client.HoodieMetaserverClient;
import org.apache.hudi.metaserver.client.HoodieMetaserverClientProxy;
import org.apache.hudi.metaserver.thrift.NoSuchObjectException;
import org.apache.hudi.metaserver.thrift.Table;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTableMetaserverClient
extends HoodieTableMetaClient {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTableMetaserverClient.class);
    private final String databaseName;
    private final String tableName;
    private final Table table;
    private final transient HoodieMetaserverClient metaserverClient;

    public HoodieTableMetaserverClient(HoodieStorage storage, String basePath, ConsistencyGuardConfig consistencyGuardConfig, String mergerStrategy, FileSystemRetryConfig fileSystemRetryConfig, Option<String> databaseName, Option<String> tableName, HoodieMetaserverConfig config) {
        super(storage, basePath, false, consistencyGuardConfig, Option.of(TimelineLayoutVersion.CURR_LAYOUT_VERSION), config.getString(HoodieTableConfig.PAYLOAD_CLASS_NAME), mergerStrategy, fileSystemRetryConfig);
        this.databaseName = databaseName.isPresent() ? databaseName.get() : this.tableConfig.getDatabaseName();
        this.tableName = tableName.isPresent() ? tableName.get() : this.tableConfig.getTableName();
        this.metaserverConfig = config;
        this.metaserverClient = HoodieMetaserverClientProxy.getProxy(config);
        this.table = this.initOrGetTable(config);
        this.tableConfig.setTableVersion(HoodieTableVersion.current());
        this.tableConfig.setAll(config.getProps());
    }

    private Table initOrGetTable(HoodieMetaserverConfig config) {
        Table table;
        ValidationUtils.checkArgument(StringUtils.nonEmpty(this.databaseName), "database name is required.");
        ValidationUtils.checkArgument(StringUtils.nonEmpty(this.tableName), "table name is required.");
        try {
            table = this.metaserverClient.getTable(this.databaseName, this.tableName);
        }
        catch (HoodieException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                String user = "";
                try {
                    user = UserGroupInformation.getCurrentUser().getShortUserName();
                }
                catch (IOException ioException) {
                    LOG.info("Failed to get the user", (Throwable)ioException);
                }
                LOG.info(String.format("Table %s.%s doesn't exist, will create it.", this.databaseName, this.tableName));
                table = new Table();
                table.setDatabaseName(this.databaseName);
                table.setTableName(this.tableName);
                table.setLocation(config.getString(HoodieWriteConfig.BASE_PATH));
                table.setOwner(user);
                table.setTableType(config.getString(HoodieTableConfig.TYPE.key()));
                this.metaserverClient.createTable(table);
                table = this.metaserverClient.getTable(this.databaseName, this.tableName);
            }
            throw e;
        }
        return table;
    }

    @Override
    public HoodieTableType getTableType() {
        return HoodieTableType.valueOf(this.table.getTableType());
    }

    @Override
    public synchronized HoodieActiveTimeline getActiveTimeline() {
        if (this.activeTimeline == null) {
            this.activeTimeline = new HoodieMetaserverBasedTimeline((HoodieTableMetaClient)this, this.metaserverConfig);
        }
        return this.activeTimeline;
    }

    @Override
    public synchronized HoodieActiveTimeline reloadActiveTimeline() {
        this.activeTimeline = new HoodieMetaserverBasedTimeline((HoodieTableMetaClient)this, this.metaserverConfig);
        return this.activeTimeline;
    }

    @Override
    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Set<String> includedExtensions, boolean applyLayoutVersionFilters) {
        throw new HoodieException("Unsupport operation");
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Path timelinePath, Set<String> includedExtensions, boolean applyLayoutVersionFilters) {
        throw new HoodieException("Unsupport operation");
    }

    public void setBasePath(String basePath) {
        throw new HoodieException("Unsupport operation");
    }

    public void setMetaPath(String metaPath) {
        throw new HoodieException("Unsupport operation");
    }

    public void setActiveTimeline(HoodieActiveTimeline activeTimeline) {
        throw new HoodieException("Unsupport operation");
    }

    public HoodieMetaserverClient getMetaserverClient() {
        return this.metaserverClient;
    }
}

