/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.client.clustering.update.strategy.BaseSparkUpdateStrategy;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.HoodieTable;

public class SparkAllowUpdateStrategy<T>
extends BaseSparkUpdateStrategy<T> {
    public SparkAllowUpdateStrategy(HoodieEngineContext engineContext, HoodieTable table, Set<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, table, fileGroupsInPendingClustering);
    }

    @Override
    public Pair<HoodieData<HoodieRecord<T>>, Set<HoodieFileGroupId>> handleUpdate(HoodieData<HoodieRecord<T>> taggedRecordsRDD) {
        List<HoodieFileGroupId> fileGroupIdsWithRecordUpdate = this.getGroupIdsWithUpdate(taggedRecordsRDD);
        Set fileGroupIdsWithUpdatesAndPendingClustering = fileGroupIdsWithRecordUpdate.stream().filter(this.fileGroupsInPendingClustering::contains).collect(Collectors.toSet());
        return Pair.of(taggedRecordsRDD, fileGroupIdsWithUpdatesAndPendingClustering);
    }
}

