/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.bootstrap;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.FullRecordBootstrapDataProvider;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import scala.Option;

public abstract class SparkFullBootstrapDataProviderBase
extends FullRecordBootstrapDataProvider<JavaRDD<HoodieRecord>> {
    private final transient SparkSession sparkSession;

    public SparkFullBootstrapDataProviderBase(TypedProperties props, HoodieSparkEngineContext context) {
        super(props, context);
        this.sparkSession = SparkSession.builder().config(context.getJavaSparkContext().getConf()).getOrCreate();
    }

    @Override
    public JavaRDD<HoodieRecord> generateInputRecords(String tableName, String sourceBasePath, List<Pair<String, List<HoodieFileStatus>>> partitionPathsWithFiles, HoodieWriteConfig config) {
        String[] filePaths = (String[])partitionPathsWithFiles.stream().map(Pair::getValue).flatMap(f -> f.stream().map(fs -> HadoopFSUtils.toPath(fs.getPath()).toString())).toArray(String[]::new);
        HoodieRecord.HoodieRecordType recordType = config.getRecordMerger().getRecordType();
        Dataset inputDataset = this.sparkSession.read().format(this.getFormat()).option("basePath", sourceBasePath).load(filePaths);
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(this.props);
        String precombineKey = this.props.getString("hoodie.datasource.write.precombine.field");
        String structName = tableName + "_record";
        String namespace = "hoodie." + tableName;
        if (recordType == HoodieRecord.HoodieRecordType.AVRO) {
            RDD<GenericRecord> genericRecords = HoodieSparkUtils.createRdd((Dataset<Row>)inputDataset, structName, namespace, false, org.apache.hudi.common.util.Option.empty());
            return genericRecords.toJavaRDD().map((Function & Serializable)gr -> {
                String orderingVal = HoodieAvroUtils.getNestedFieldValAsString(gr, precombineKey, false, this.props.getBoolean(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), Boolean.parseBoolean(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue())));
                try {
                    return DataSourceUtils.createHoodieRecord(gr, (Comparable)((Object)orderingVal), keyGenerator.getKey((GenericRecord)gr), this.props.getString("hoodie.datasource.write.payload.class"), (Option<HoodieRecordLocation>)Option.apply(null));
                }
                catch (IOException ioe) {
                    throw new HoodieIOException(ioe.getMessage(), ioe);
                }
            });
        }
        if (recordType == HoodieRecord.HoodieRecordType.SPARK) {
            SparkKeyGeneratorInterface sparkKeyGenerator = (SparkKeyGeneratorInterface)((Object)keyGenerator);
            StructType structType = inputDataset.schema();
            return inputDataset.queryExecution().toRdd().toJavaRDD().map((Function & Serializable)internalRow -> {
                String recordKey = sparkKeyGenerator.getRecordKey((InternalRow)internalRow, structType).toString();
                String partitionPath = sparkKeyGenerator.getPartitionPath((InternalRow)internalRow, structType).toString();
                HoodieKey key = new HoodieKey(recordKey, partitionPath);
                return new HoodieSparkRecord(key, (InternalRow)internalRow, structType, false);
            });
        }
        throw new UnsupportedOperationException(recordType.name());
    }

    protected abstract String getFormat();
}

