/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieStreamingSink;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieDataTypeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class DataSourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceUtils.class);

    public static String getTablePath(HoodieStorage storage, List<StoragePath> userProvidedPaths) throws IOException {
        LOG.info("Getting table path..");
        for (StoragePath path : userProvidedPaths) {
            try {
                Option<StoragePath> tablePath = TablePathUtils.getTablePath(storage, path);
                if (!tablePath.isPresent()) continue;
                return tablePath.get().toString();
            }
            catch (HoodieException he) {
                LOG.warn("Error trying to get table path from " + path.toString(), (Throwable)he);
            }
        }
        throw new TableNotFoundException(userProvidedPaths.stream().map(StoragePath::toString).collect(Collectors.joining(",")));
    }

    public static Option<BulkInsertPartitioner> createUserDefinedBulkInsertPartitioner(HoodieWriteConfig config) throws HoodieException {
        String bulkInsertPartitionerClass = config.getUserDefinedBulkInsertPartitionerClass();
        try {
            return StringUtils.isNullOrEmpty(bulkInsertPartitionerClass) ? Option.empty() : Option.of((BulkInsertPartitioner)ReflectionUtils.loadClass(bulkInsertPartitionerClass, config));
        }
        catch (Throwable e) {
            throw new HoodieException("Could not create UserDefinedBulkInsertPartitioner class " + bulkInsertPartitionerClass, e);
        }
    }

    public static Option<BulkInsertPartitioner<Dataset<Row>>> createUserDefinedBulkInsertPartitionerWithRows(HoodieWriteConfig config) throws HoodieException {
        String bulkInsertPartitionerClass = config.getUserDefinedBulkInsertPartitionerClass();
        try {
            return StringUtils.isNullOrEmpty(bulkInsertPartitionerClass) ? Option.empty() : Option.of((BulkInsertPartitioner)ReflectionUtils.loadClass(bulkInsertPartitionerClass, config));
        }
        catch (Throwable e) {
            throw new HoodieException("Could not create UserDefinedBulkInsertPartitionerRows class " + bulkInsertPartitionerClass, e);
        }
    }

    public static HoodieRecordPayload createPayload(String payloadClass, GenericRecord record, Comparable orderingVal) throws IOException {
        try {
            return (HoodieRecordPayload)ReflectionUtils.loadClass(payloadClass, new Class[]{GenericRecord.class, Comparable.class}, new Object[]{record, orderingVal});
        }
        catch (Throwable e) {
            throw new IOException("Could not create payload for class: " + payloadClass, e);
        }
    }

    public static Map<String, String> getExtraMetadata(Map<String, String> properties) {
        HashMap<String, String> extraMetadataMap = new HashMap<String, String>();
        if (properties.containsKey(DataSourceWriteOptions.COMMIT_METADATA_KEYPREFIX().key())) {
            properties.entrySet().forEach(entry -> {
                if (((String)entry.getKey()).startsWith((String)properties.get(DataSourceWriteOptions.COMMIT_METADATA_KEYPREFIX().key()))) {
                    extraMetadataMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            });
        }
        if (properties.containsKey(HoodieSparkSqlWriter.SPARK_STREAMING_BATCH_ID())) {
            extraMetadataMap.put(HoodieStreamingSink.SINK_CHECKPOINT_KEY(), CommitUtils.getCheckpointValueAsString(properties.getOrDefault(DataSourceWriteOptions.STREAMING_CHECKPOINT_IDENTIFIER().key(), DataSourceWriteOptions.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue()), properties.get(HoodieSparkSqlWriter.SPARK_STREAMING_BATCH_ID())));
        }
        return extraMetadataMap;
    }

    public static HoodieRecordPayload createPayload(String payloadClass, GenericRecord record) throws IOException {
        try {
            return (HoodieRecordPayload)ReflectionUtils.loadClass(payloadClass, new Class[]{Option.class}, new Object[]{Option.of(record)});
        }
        catch (Throwable e) {
            throw new IOException("Could not create payload for class: " + payloadClass, e);
        }
    }

    public static HoodieWriteConfig createHoodieConfig(String schemaStr, String basePath, String tblName, Map<String, String> parameters) {
        boolean asyncCompact = Boolean.parseBoolean(parameters.get(DataSourceWriteOptions.ASYNC_COMPACT_ENABLE().key()));
        boolean inlineCompact = false;
        if (parameters.containsKey(HoodieCompactionConfig.INLINE_COMPACT.key())) {
            inlineCompact = Boolean.parseBoolean(parameters.get(HoodieCompactionConfig.INLINE_COMPACT.key()));
        }
        if (!inlineCompact) {
            inlineCompact = !asyncCompact && parameters.get(DataSourceWriteOptions.TABLE_TYPE().key()).equals(DataSourceWriteOptions.MOR_TABLE_TYPE_OPT_VAL());
        }
        boolean combineInserts = Boolean.parseBoolean(parameters.get(DataSourceWriteOptions.INSERT_DROP_DUPS().key()));
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath(basePath).withAutoCommit(false).combineInput(combineInserts, true);
        if (schemaStr != null) {
            builder = builder.withSchema(schemaStr);
        }
        return builder.forTable(tblName).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(inlineCompact).build()).withPayloadConfig(HoodiePayloadConfig.newBuilder().withPayloadClass(parameters.get(DataSourceWriteOptions.PAYLOAD_CLASS_NAME().key())).withPayloadOrderingField(parameters.get(DataSourceWriteOptions.PRECOMBINE_FIELD().key())).build()).withProps(parameters).build();
    }

    public static SparkRDDWriteClient createHoodieClient(JavaSparkContext jssc, String schemaStr, String basePath, String tblName, Map<String, String> parameters) {
        return new SparkRDDWriteClient(new HoodieSparkEngineContext(jssc), DataSourceUtils.createHoodieConfig(schemaStr, basePath, tblName, parameters));
    }

    public static HoodieWriteResult doWriteOperation(SparkRDDWriteClient client, JavaRDD<HoodieRecord> hoodieRecords, String instantTime, WriteOperationType operation, Boolean isPrepped) throws HoodieException {
        switch (operation) {
            case BULK_INSERT: {
                Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner = DataSourceUtils.createUserDefinedBulkInsertPartitioner(client.getConfig());
                return new HoodieWriteResult(client.bulkInsert(hoodieRecords, instantTime, userDefinedBulkInsertPartitioner));
            }
            case INSERT: {
                return new HoodieWriteResult(client.insert(hoodieRecords, instantTime));
            }
            case UPSERT: {
                if (isPrepped.booleanValue()) {
                    return new HoodieWriteResult(client.upsertPreppedRecords(hoodieRecords, instantTime));
                }
                return new HoodieWriteResult(client.upsert(hoodieRecords, instantTime));
            }
            case INSERT_OVERWRITE: {
                return client.insertOverwrite(hoodieRecords, instantTime);
            }
            case INSERT_OVERWRITE_TABLE: {
                return client.insertOverwriteTable(hoodieRecords, instantTime);
            }
        }
        throw new HoodieException("Not a valid operation type for doWriteOperation: " + operation.toString());
    }

    public static HoodieWriteResult doDeleteOperation(SparkRDDWriteClient client, JavaRDD<Tuple2<HoodieKey, scala.Option<HoodieRecordLocation>>> hoodieKeysAndLocations, String instantTime, boolean isPrepped) {
        if (isPrepped) {
            HoodieRecord.HoodieRecordType recordType = client.getConfig().getRecordMerger().getRecordType();
            JavaRDD records = hoodieKeysAndLocations.map((Function & Serializable)tuple -> {
                HoodieRecord record = recordType == HoodieRecord.HoodieRecordType.AVRO ? new HoodieAvroRecord<EmptyHoodieRecordPayload>((HoodieKey)tuple._1, new EmptyHoodieRecordPayload()) : new HoodieSparkRecord((HoodieKey)tuple._1, null, false);
                record.setCurrentLocation((HoodieRecordLocation)((scala.Option)tuple._2).get());
                return record;
            });
            return new HoodieWriteResult(client.deletePrepped(records, instantTime));
        }
        return new HoodieWriteResult(client.delete((JavaRDD<HoodieKey>)hoodieKeysAndLocations.map((Function & Serializable)tuple -> (HoodieKey)tuple._1()), instantTime));
    }

    public static HoodieWriteResult doDeletePartitionsOperation(SparkRDDWriteClient client, List<String> partitionsToDelete, String instantTime) {
        return client.deletePartitions(partitionsToDelete, instantTime);
    }

    public static HoodieRecord createHoodieRecord(GenericRecord gr, Comparable orderingVal, HoodieKey hKey, String payloadClass, scala.Option<HoodieRecordLocation> recordLocation) throws IOException {
        HoodieRecordPayload payload = DataSourceUtils.createPayload(payloadClass, gr, orderingVal);
        HoodieAvroRecord<HoodieRecordPayload> record = new HoodieAvroRecord<HoodieRecordPayload>(hKey, payload);
        if (recordLocation.isDefined()) {
            record.setCurrentLocation((HoodieRecordLocation)recordLocation.get());
        }
        return record;
    }

    public static HoodieRecord createHoodieRecord(GenericRecord gr, HoodieKey hKey, String payloadClass, scala.Option<HoodieRecordLocation> recordLocation) throws IOException {
        HoodieRecordPayload payload = DataSourceUtils.createPayload(payloadClass, gr);
        HoodieAvroRecord<HoodieRecordPayload> record = new HoodieAvroRecord<HoodieRecordPayload>(hKey, payload);
        if (recordLocation.isDefined()) {
            record.setCurrentLocation((HoodieRecordLocation)recordLocation.get());
        }
        return record;
    }

    public static JavaRDD<HoodieRecord> dropDuplicates(JavaSparkContext jssc, JavaRDD<HoodieRecord> incomingHoodieRecords, HoodieWriteConfig writeConfig) {
        try {
            SparkRDDReadClient client = new SparkRDDReadClient(new HoodieSparkEngineContext(jssc), writeConfig);
            return client.tagLocation(incomingHoodieRecords).filter((Function & Serializable)r -> !((HoodieRecord)r).isCurrentLocationKnown());
        }
        catch (TableNotFoundException e) {
            return incomingHoodieRecords;
        }
    }

    public static JavaRDD<HoodieRecord> dropDuplicates(JavaSparkContext jssc, JavaRDD<HoodieRecord> incomingHoodieRecords, Map<String, String> parameters) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(parameters.get("path")).withProps(parameters).build();
        return DataSourceUtils.dropDuplicates(jssc, incomingHoodieRecords, writeConfig);
    }

    public static void tryOverrideParquetWriteLegacyFormatProperty(Map<String, String> properties, StructType schema) {
        if (HoodieDataTypeUtils.hasSmallPrecisionDecimalType((DataType)schema) && properties.get(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key()) == null) {
            LOG.warn("Small Decimal Type found in the persisted schema, reverting default value of 'hoodie.parquet.writelegacyformat.enabled' to true");
            properties.put(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key(), "true");
        }
    }
}

