/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.MalformedInputException;
import io.airlift.compress.zstd.CompressionParameters;
import io.airlift.compress.zstd.UnsafeUtil;

final class Util {
    private Util() {
    }

    public static int highestBit(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static boolean isPowerOf2(int value) {
        return (value & value - 1) == 0;
    }

    public static int mask(int bits) {
        return (1 << bits) - 1;
    }

    public static void verify(boolean condition, long offset, String reason) {
        if (!condition) {
            throw new MalformedInputException(offset, reason);
        }
    }

    public static void checkArgument(boolean condition, String reason) {
        if (!condition) {
            throw new IllegalArgumentException(reason);
        }
    }

    static void checkPositionIndexes(int start2, int end, int size) {
        if (start2 < 0 || end < start2 || end > size) {
            throw new IndexOutOfBoundsException(Util.badPositionIndexes(start2, end, size));
        }
    }

    private static String badPositionIndexes(int start2, int end, int size) {
        if (start2 < 0 || start2 > size) {
            return Util.badPositionIndex(start2, size, "start index");
        }
        if (end < 0 || end > size) {
            return Util.badPositionIndex(end, size, "end index");
        }
        return String.format("end index (%s) must not be less than start index (%s)", end, start2);
    }

    private static String badPositionIndex(int index, int size, String desc) {
        if (index < 0) {
            return String.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return String.format("%s (%s) must not be greater than size (%s)", desc, index, size);
    }

    public static void checkState(boolean condition, String reason) {
        if (!condition) {
            throw new IllegalStateException(reason);
        }
    }

    public static MalformedInputException fail(long offset, String reason) {
        throw new MalformedInputException(offset, reason);
    }

    public static int cycleLog(int hashLog, CompressionParameters.Strategy strategy) {
        int cycleLog = hashLog;
        if (strategy == CompressionParameters.Strategy.BTLAZY2 || strategy == CompressionParameters.Strategy.BTOPT || strategy == CompressionParameters.Strategy.BTULTRA) {
            cycleLog = hashLog - 1;
        }
        return cycleLog;
    }

    public static int get24BitLittleEndian(Object inputBase, long inputAddress) {
        return UnsafeUtil.UNSAFE.getShort(inputBase, inputAddress) & 0xFFFF | (UnsafeUtil.UNSAFE.getByte(inputBase, inputAddress + 2L) & 0xFF) << 16;
    }

    public static void put24BitLittleEndian(Object outputBase, long outputAddress, int value) {
        UnsafeUtil.UNSAFE.putShort(outputBase, outputAddress, (short)value);
        UnsafeUtil.UNSAFE.putByte(outputBase, outputAddress + 2L, (byte)(value >>> 16));
    }

    public static int minTableLog(int inputSize, int maxSymbolValue) {
        if (inputSize <= 1) {
            throw new IllegalArgumentException("Not supported. RLE should be used instead");
        }
        int minBitsSrc = Util.highestBit(inputSize - 1) + 1;
        int minBitsSymbols = Util.highestBit(maxSymbolValue) + 2;
        return Math.min(minBitsSrc, minBitsSymbols);
    }
}

