/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.store.jdbc;

import java.io.IOException;
import java.io.InputStream;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSessionFactoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSessionFactoryUtils.class);
    private static final String CONFIG_PATH = "mybatis-config.xml";
    private static volatile SqlSessionFactory sqlSessionFactory;

    private SqlSessionFactoryUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initSqlSessionFactory() {
        if (sqlSessionFactory != null) return;
        Class<SqlSessionFactoryUtils> clazz = SqlSessionFactoryUtils.class;
        synchronized (SqlSessionFactoryUtils.class) {
            if (sqlSessionFactory != null) return;
            try (InputStream inputStream = Resources.getResourceAsStream((String)CONFIG_PATH);){
                sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream);
            }
            catch (IOException e) {
                LOG.error("Failed to init SQL session.", (Throwable)e);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static SqlSession openSqlSession() {
        SqlSessionFactoryUtils.initSqlSessionFactory();
        return sqlSessionFactory.openSession();
    }
}

