/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.store.bean;

import java.math.BigInteger;
import java.sql.Timestamp;
import org.apache.hudi.metaserver.thrift.Table;

public class TableBean {
    private String databaseName;
    private Long tblId;
    private String tableName;
    private Long createTime;
    private String owner;
    private String location;

    public TableBean(Table table) {
        this.tableName = table.tableName;
        this.owner = table.owner;
        this.location = table.location;
    }

    public TableBean(String databaseName, BigInteger tblId, String tableName, Timestamp createTime, String owner, String location) {
        this.databaseName = databaseName;
        this.tblId = tblId.longValue();
        this.tableName = tableName;
        this.createTime = createTime.getTime();
        this.owner = owner;
        this.location = location;
    }

    public TableBean(String databaseName, Long tblId, String tableName, Timestamp createTime, String owner, String location) {
        this.databaseName = databaseName;
        this.tblId = tblId;
        this.tableName = tableName;
        this.createTime = createTime.getTime();
        this.owner = owner;
        this.location = location;
    }

    public Table toTable() {
        Table table = new Table();
        table.setDatabaseName(this.databaseName);
        table.setTableName(this.tableName);
        table.setOwner(this.owner);
        table.setLocation(this.location);
        table.setCreateTime(this.createTime);
        return table;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Long getTblId() {
        return this.tblId;
    }

    public void setTblId(Long tblId) {
        this.tblId = tblId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime.getTime();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toString() {
        return "TableBean{databaseName=" + this.databaseName + ", tblId=" + this.tblId + ", tableName='" + this.tableName + '\'' + ", createTime='" + this.createTime + '\'' + ", owner='" + this.owner + '\'' + ", location='" + this.location + '\'' + '}';
    }
}

