/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.store;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metaserver.store.MetaserverStorage;
import org.apache.hudi.metaserver.store.bean.InstantBean;
import org.apache.hudi.metaserver.store.bean.TableBean;
import org.apache.hudi.metaserver.store.jdbc.WrapperDao;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.hudi.metaserver.thrift.THoodieInstant;
import org.apache.hudi.metaserver.thrift.TState;
import org.apache.hudi.metaserver.thrift.Table;

public class RelationalDBBasedStorage
implements MetaserverStorage,
Serializable {
    private final WrapperDao tableDao = new WrapperDao.TableDao();
    private final WrapperDao timelineDao = new WrapperDao.TimelineDao();

    @Override
    public void initStorage() throws MetaserverStorageException {
        WrapperDao dao = new WrapperDao("DDLMapper");
        dao.updateBySql("createDBs", null);
        dao.updateBySql("createTables", null);
        dao.updateBySql("createTableParams", null);
        dao.updateBySql("createPartitions", null);
        dao.updateBySql("createTableTimestamp", null);
        dao.updateBySql("createInstant", null);
        dao.updateBySql("createInstantMetadata", null);
        dao.updateBySql("createFiles", null);
    }

    @Override
    public boolean createDatabase(String db) throws MetaserverStorageException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("databaseName", db);
        return this.tableDao.insertBySql("insertDB", params) == 1;
    }

    @Override
    public Long getDatabaseId(String db) throws MetaserverStorageException {
        List ids = this.tableDao.queryForListBySql("selectDBId", db);
        RelationalDBBasedStorage.validate(ids, "db " + db);
        return ids.isEmpty() ? null : (Long)ids.get(0);
    }

    @Override
    public boolean deleteDatabase(Long dbId) throws MetaserverStorageException {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("dbId", dbId);
        return this.tableDao.deleteBySql("deleteDB", params) == 1;
    }

    @Override
    public boolean createTable(Long dbId, Table table) throws MetaserverStorageException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dbId", dbId);
        TableBean tableBean = new TableBean(table);
        params.put("tableBean", tableBean);
        return this.tableDao.insertBySql("insertTable", params) == 1;
    }

    @Override
    public Table getTable(String db, String tb) throws MetaserverStorageException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("databaseName", db);
        params.put("tableName", tb);
        List table = this.tableDao.queryForListBySql("selectTable", params);
        RelationalDBBasedStorage.validate(table, "table " + db + "." + tb);
        return table.isEmpty() ? null : ((TableBean)table.get(0)).toTable();
    }

    @Override
    public Long getTableId(String db, String tb) throws MetaserverStorageException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("databaseName", db);
        params.put("tableName", tb);
        List ids = this.tableDao.queryForListBySql("selectTableId", params);
        RelationalDBBasedStorage.validate(ids, "table " + db + "." + tb);
        return ids.isEmpty() ? null : (Long)ids.get(0);
    }

    @Override
    public boolean deleteTable(Long tableId) throws MetaserverStorageException {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("tableId", tableId);
        return this.tableDao.deleteBySql("deleteTable", params) == 1;
    }

    @Override
    public String createNewTimestamp(long tableId) throws MetaserverStorageException {
        String newTimestamp;
        boolean success;
        do {
            String oldTimestamp = this.getLatestTimestamp(tableId);
            do {
                newTimestamp = HoodieInstantTimeGenerator.createNewInstantTime((long)0L);
            } while (oldTimestamp != null && HoodieTimeline.compareTimestamps((String)newTimestamp, (BiPredicate)HoodieActiveTimeline.LESSER_THAN_OR_EQUALS, (String)oldTimestamp));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tableId", tableId);
            params.put("oldTimestamp", oldTimestamp);
            params.put("newTimestamp", newTimestamp);
            if (oldTimestamp == null) {
                success = this.timelineDao.insertBySql("insertTimestamp", params) == 1;
                continue;
            }
            boolean bl = success = this.timelineDao.updateBySql("updateTimestamp", params) == 1;
        } while (!success);
        return newTimestamp;
    }

    private String getLatestTimestamp(long tableId) throws MetaserverStorageException {
        List timestamps = this.timelineDao.queryForListBySql("selectTimestampByTableId", tableId);
        RelationalDBBasedStorage.validate(timestamps, "timestamp");
        return timestamps.isEmpty() ? null : (String)timestamps.get(0);
    }

    @Override
    public boolean deleteTableTimestamp(Long tableId) throws MetaserverStorageException {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("tableId", tableId);
        return this.timelineDao.deleteBySql("deleteTimestamp", params) == 1;
    }

    @Override
    public boolean createInstant(long tableId, THoodieInstant instant) throws MetaserverStorageException {
        InstantBean instantBean = new InstantBean(tableId, instant);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instant", instantBean);
        params.put("duration", 120);
        params.put("startTs", (int)(System.currentTimeMillis() / 1000L));
        return this.timelineDao.insertBySql("insertInstant", params) == 1;
    }

    @Override
    public boolean updateInstant(long tableId, THoodieInstant fromInstant, THoodieInstant toInstant) throws MetaserverStorageException {
        InstantBean oldInstant = new InstantBean(tableId, fromInstant);
        InstantBean newInstant = new InstantBean(tableId, toInstant);
        HashMap<String, InstantBean> params = new HashMap<String, InstantBean>();
        params.put("oldInstant", oldInstant);
        params.put("newInstant", newInstant);
        return this.timelineDao.updateBySql("updateInstant", params) == 1;
    }

    @Override
    public boolean deleteInstant(long tableId, THoodieInstant instant) throws MetaserverStorageException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableId", tableId);
        params.put("ts", instant.getTimestamp());
        return this.timelineDao.deleteBySql("deleteInstant", params) == 1;
    }

    @Override
    public List<THoodieInstant> scanInstants(long tableId, List<TState> states, int limit) throws MetaserverStorageException {
        if (CollectionUtils.isNullOrEmpty(states)) {
            throw new MetaserverStorageException("State has to be specified when scan instants");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableId", tableId);
        params.put("states", states.stream().mapToInt(TState::getValue).boxed().collect(Collectors.toList()));
        params.put("limit", limit);
        List instantBeans = this.timelineDao.queryForListBySql("selectInstantsByStates", params);
        return instantBeans.stream().map(InstantBean::toTHoodieInstant).collect(Collectors.toList());
    }

    @Override
    public List<THoodieInstant> scanInstants(long tableId, TState state, int limit) throws MetaserverStorageException {
        return this.scanInstants(tableId, Collections.singletonList(state), limit);
    }

    @Override
    public boolean instantExists(long tableId, THoodieInstant instant) throws MetaserverStorageException {
        InstantBean instantBean = new InstantBean(tableId, instant);
        List ids = this.timelineDao.queryForListBySql("selectInstantId", instantBean);
        RelationalDBBasedStorage.validate(ids, instantBean.toString());
        return !ids.isEmpty();
    }

    @Override
    public void saveInstantMetadata(long tableId, THoodieInstant instant, byte[] metadata) throws MetaserverStorageException {
        InstantBean instantBean = new InstantBean(tableId, instant);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instant", instantBean);
        params.put("metadata", metadata);
        this.timelineDao.insertBySql("insertInstantMetadata", params);
    }

    @Override
    public boolean deleteInstantMetadata(long tableId, THoodieInstant instant) throws MetaserverStorageException {
        InstantBean instantBean = new InstantBean(tableId, instant);
        return this.timelineDao.deleteBySql("deleteInstantMetadata", instantBean) == 1;
    }

    @Override
    public boolean deleteInstantAllMeta(long tableId, String timestamp) throws MetaserverStorageException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableId", tableId);
        params.put("ts", timestamp);
        return this.timelineDao.deleteBySql("deleteInstantAllMetadata", params) >= 1;
    }

    @Override
    public Option<byte[]> getInstantMetadata(long tableId, THoodieInstant instant) throws MetaserverStorageException {
        InstantBean instantBean = new InstantBean(tableId, instant);
        Map result = (Map)this.timelineDao.queryForObjectBySql("selectInstantMetadata", instantBean);
        return result == null ? Option.empty() : Option.of((Object)((byte[])result.get("data")));
    }

    @Override
    public void close() {
    }

    public static void validate(List<?> entities, String entityName) throws MetaserverStorageException {
        try {
            ValidationUtils.checkState((CollectionUtils.isNullOrEmpty(entities) || entities.size() == 1 ? 1 : 0) != 0, (String)("Found multiple records of " + entityName + " , expected one"));
        }
        catch (IllegalStateException e) {
            throw new MetaserverStorageException(e.getMessage());
        }
    }
}

