/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.service;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metaserver.store.MetaserverStorage;
import org.apache.hudi.metaserver.thrift.HoodieInstantChangeResult;
import org.apache.hudi.metaserver.thrift.MetaserverException;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.hudi.metaserver.thrift.NoSuchObjectException;
import org.apache.hudi.metaserver.thrift.TAction;
import org.apache.hudi.metaserver.thrift.THoodieInstant;
import org.apache.hudi.metaserver.thrift.TState;
import org.apache.hudi.metaserver.util.MetaserverTableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineService
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineService.class);
    private static final List<TAction> ALL_ACTIONS = Arrays.asList(TAction.COMMIT, TAction.DELTACOMMIT, TAction.CLEAN, TAction.ROLLBACK, TAction.SAVEPOINT, TAction.REPLACECOMMIT, TAction.COMPACTION, TAction.RESTORE);
    private static final List<TState> PENDING_STATES = Arrays.asList(TState.REQUESTED, TState.INFLIGHT);
    private final MetaserverStorage store;

    public TimelineService(MetaserverStorage metaserverStorage) {
        this.store = metaserverStorage;
    }

    public List<THoodieInstant> listInstants(String db, String tb, int num) throws MetaserverStorageException, NoSuchObjectException {
        Long tableId = MetaserverTableUtils.getTableId(this.store, db, tb);
        List<THoodieInstant> completeds = this.store.scanInstants((long)tableId, TState.COMPLETED, num);
        List<THoodieInstant> pendings = this.store.scanInstants((long)tableId, PENDING_STATES, -1);
        completeds.addAll(pendings);
        return completeds;
    }

    public ByteBuffer getInstantMetadata(String db, String tb, THoodieInstant instant) throws MetaserverStorageException, NoSuchObjectException {
        Long tableId = MetaserverTableUtils.getTableId(this.store, db, tb);
        Option<byte[]> instantMetadata = this.store.getInstantMetadata(tableId, instant);
        return ByteBuffer.wrap((byte[])instantMetadata.orElse((Object)new byte[0]));
    }

    public String createNewInstantTime(String db, String tb) throws MetaserverStorageException, NoSuchObjectException {
        Long tableId = MetaserverTableUtils.getTableId(this.store, db, tb);
        return this.store.createNewTimestamp(tableId);
    }

    public HoodieInstantChangeResult createNewInstantWithTime(String db, String tb, THoodieInstant instant, ByteBuffer content) throws MetaserverStorageException, NoSuchObjectException {
        ValidationUtils.checkArgument((boolean)instant.getState().equals((Object)TState.REQUESTED));
        Long tableId = MetaserverTableUtils.getTableId(this.store, db, tb);
        HoodieInstantChangeResult result = new HoodieInstantChangeResult();
        result.setInstant(instant);
        if (this.store.instantExists(tableId, instant)) {
            result.setSuccess(true);
            return result;
        }
        this.store.saveInstantMetadata(tableId, instant, content.array());
        result.setSuccess(this.store.createInstant(tableId, instant));
        return result;
    }

    public HoodieInstantChangeResult transitionInstantState(String db, String tb, THoodieInstant fromInstant, THoodieInstant toInstant, ByteBuffer metadata) throws MetaserverStorageException, NoSuchObjectException, MetaserverException {
        switch (fromInstant.getState()) {
            case REQUESTED: {
                return this.transitionRequestedToInflight(db, tb, fromInstant, toInstant, metadata);
            }
            case INFLIGHT: {
                return this.transitionInflightToCompleted(db, tb, fromInstant, toInstant, metadata);
            }
        }
        throw new MetaserverException("Unsupported state " + (Object)((Object)fromInstant.getState()) + " when do the state transition.");
    }

    private HoodieInstantChangeResult transitionRequestedToInflight(String db, String tb, THoodieInstant fromInstant, THoodieInstant toInstant, ByteBuffer metadata) throws MetaserverStorageException, NoSuchObjectException {
        ValidationUtils.checkArgument((boolean)fromInstant.getState().equals((Object)TState.REQUESTED));
        ValidationUtils.checkArgument((boolean)toInstant.getState().equals((Object)TState.INFLIGHT));
        HoodieInstantChangeResult result = new HoodieInstantChangeResult();
        Long tableId = MetaserverTableUtils.getTableId(this.store, db, tb);
        if (this.store.instantExists(tableId, toInstant)) {
            LOG.info("Instant " + toInstant + " has been already changed to");
            result.setSuccess(true);
            return result;
        }
        this.store.saveInstantMetadata(tableId, toInstant, metadata.array());
        result.setSuccess(this.store.updateInstant(tableId, fromInstant, toInstant));
        return result;
    }

    private HoodieInstantChangeResult transitionInflightToCompleted(String db, String tb, THoodieInstant fromInstant, THoodieInstant toInstant, ByteBuffer metadata) throws MetaserverStorageException, NoSuchObjectException {
        ValidationUtils.checkArgument((boolean)fromInstant.getState().equals((Object)TState.INFLIGHT));
        ValidationUtils.checkArgument((boolean)toInstant.getState().equals((Object)TState.COMPLETED));
        HoodieInstantChangeResult result = new HoodieInstantChangeResult();
        Long tableId = MetaserverTableUtils.getTableId(this.store, db, tb);
        if (this.store.instantExists(tableId, toInstant)) {
            LOG.info("Instant " + toInstant + " has been already changed to");
            result.setSuccess(true);
            return result;
        }
        this.store.saveInstantMetadata(tableId, toInstant, metadata.array());
        result.setSuccess(this.store.updateInstant(tableId, fromInstant, toInstant));
        return result;
    }

    public HoodieInstantChangeResult deleteInstant(String db, String tb, THoodieInstant instant) throws MetaserverStorageException, NoSuchObjectException {
        Long tableId = MetaserverTableUtils.getTableId(this.store, db, tb);
        HoodieInstantChangeResult result = new HoodieInstantChangeResult();
        if (this.store.instantExists(tableId, instant)) {
            if (instant.getState() == TState.COMPLETED) {
                this.store.deleteInstantAllMeta(tableId, instant.getTimestamp());
            }
            this.store.deleteInstant(tableId, instant);
        } else {
            LOG.info("Instant " + instant + " has been already deleted");
        }
        result.setSuccess(true);
        return result;
    }
}

