/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.metaserver.client.HoodieMetaserverClient;
import org.apache.hudi.metaserver.client.HoodieMetaserverClientImp;

public class HoodieMetaserverClientProxy
implements InvocationHandler,
Serializable {
    private final int retryLimit;
    private final long retryDelayMs;
    private final HoodieMetaserverConfig config;

    private HoodieMetaserverClientProxy(HoodieMetaserverConfig config) {
        this.retryLimit = config.getConnectionRetryLimit();
        this.retryDelayMs = (long)config.getConnectionRetryDelay() * 1000L;
        this.config = config;
    }

    public static HoodieMetaserverClient getProxy(HoodieMetaserverConfig config) {
        HoodieMetaserverClientProxy handler = new HoodieMetaserverClientProxy(config);
        return (HoodieMetaserverClient)Proxy.newProxyInstance(HoodieMetaserverClientProxy.class.getClassLoader(), new Class[]{HoodieMetaserverClient.class}, (InvocationHandler)handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try (HoodieMetaserverClientImp client = new HoodieMetaserverClientImp(this.config);){
            Object object = new RetryHelper(this.retryDelayMs, this.retryLimit, this.retryDelayMs, Exception.class.getName()).tryWith((RetryHelper.CheckedFunction & Serializable)() -> method.invoke((Object)client, args)).start();
            return object;
        }
        catch (IllegalAccessException | InvocationTargetException | UndeclaredThrowableException e) {
            throw e.getCause();
        }
    }
}

