/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.client;

import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metaserver.client.HoodieMetaserverClient;
import org.apache.hudi.metaserver.thrift.Table;
import org.apache.hudi.metaserver.thrift.ThriftHoodieMetaserver;
import org.apache.hudi.metaserver.util.EntityConversions;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetaserverClientImp
implements HoodieMetaserverClient {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetaserverClientImp.class);
    private final HoodieMetaserverConfig config;
    private final int retryLimit;
    private final long retryDelayMs;
    private boolean isConnected;
    private boolean isLocal;
    private ThriftHoodieMetaserver.Iface client;
    private TTransport transport;

    public HoodieMetaserverClientImp(HoodieMetaserverConfig config) {
        this.config = config;
        this.retryLimit = config.getConnectionRetryLimit();
        this.retryDelayMs = (long)config.getConnectionRetryDelay() * 1000L;
        String uri = config.getMetaserverUris();
        if (this.isLocalEmbeddedMetaserver(uri)) {
            try {
                this.client = (ThriftHoodieMetaserver.Iface)ReflectionUtils.invokeStaticMethod((String)"org.apache.hudi.metaserver.HoodieMetaserver", (String)"getEmbeddedMetaserver", (Object[])new Object[0], (Class[])new Class[0]);
            }
            catch (HoodieException e) {
                throw new HoodieException("Please check the server uri has ever been set. Empty uri is used for local unit test", (Throwable)e);
            }
            this.isConnected = true;
            this.isLocal = true;
        } else {
            URI msUri = URI.create(uri);
            this.transport = new TSocket(msUri.getHost(), msUri.getPort());
            this.client = new ThriftHoodieMetaserver.Client((TProtocol)new TBinaryProtocol(this.transport));
            try {
                new RetryHelper(this.retryDelayMs, this.retryLimit, this.retryDelayMs, TTransportException.class.getName()).tryWith((RetryHelper.CheckedFunction & Serializable)() -> {
                    this.transport.open();
                    this.isConnected = true;
                    LOG.info("Connected to meta server: " + msUri);
                    return null;
                }).start();
            }
            catch (TTransportException e) {
                throw new HoodieException("Fail to connect to the metaserver.", (Throwable)e);
            }
        }
    }

    private boolean isLocalEmbeddedMetaserver(String uri) {
        return uri == null || uri.trim().isEmpty();
    }

    @Override
    public Table getTable(String db, String tb) {
        return this.exceptionWrapper(() -> this.client.getTable(db, tb)).get();
    }

    @Override
    public void createTable(Table table) {
        try {
            this.client.createTable(table);
        }
        catch (TException e) {
            throw new HoodieException((Throwable)e);
        }
    }

    @Override
    public List<HoodieInstant> listInstants(String db, String tb, int commitNum) {
        return this.exceptionWrapper(() -> this.client.listInstants(db, tb, commitNum).stream().map(EntityConversions::fromTHoodieInstant).collect(Collectors.toList())).get();
    }

    @Override
    public Option<byte[]> getInstantMetadata(String db, String tb, HoodieInstant instant) {
        ByteBuffer byteBuffer = this.exceptionWrapper(() -> this.client.getInstantMetadata(db, tb, EntityConversions.toTHoodieInstant(instant))).get();
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return bytes.length > 0 ? Option.of((Object)bytes) : Option.empty();
    }

    @Override
    public String createNewTimestamp(String db, String tb) {
        return this.exceptionWrapper(() -> this.client.createNewInstantTime(db, tb)).get();
    }

    @Override
    public void createNewInstant(String db, String tb, HoodieInstant instant, Option<byte[]> content) {
        this.exceptionWrapper(() -> this.client.createNewInstantWithTime(db, tb, EntityConversions.toTHoodieInstant(instant), this.getByteBuffer(content))).get();
    }

    @Override
    public void transitionInstantState(String db, String tb, HoodieInstant fromInstant, HoodieInstant toInstant, Option<byte[]> content) {
        this.exceptionWrapper(() -> this.client.transitionInstantState(db, tb, EntityConversions.toTHoodieInstant(fromInstant), EntityConversions.toTHoodieInstant(toInstant), this.getByteBuffer(content))).get();
    }

    @Override
    public void deleteInstant(String db, String tb, HoodieInstant instant) {
        this.exceptionWrapper(() -> this.client.deleteInstant(db, tb, EntityConversions.toTHoodieInstant(instant))).get();
    }

    private ByteBuffer getByteBuffer(Option<byte[]> content) {
        ByteBuffer byteBuffer = content.isPresent() ? ByteBuffer.wrap((byte[])content.get()) : ByteBuffer.allocate(0);
        return byteBuffer;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public void close() {
        this.isConnected = false;
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    private <R, E extends TException> Supplier<R> exceptionWrapper(FunctionWithTException<R, E> f) {
        return () -> {
            try {
                return f.get();
            }
            catch (TException e) {
                throw new HoodieException((Throwable)e);
            }
        };
    }

    static interface FunctionWithTException<R, E extends TException> {
        public R get() throws E;
    }
}

