/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.util.IOUtils;

public class HFileUtils {
    private static final Map<Integer, CompressionCodec> HFILE_COMPRESSION_CODEC_MAP = HFileUtils.createCompressionCodecMap();

    public static CompressionCodec decodeCompressionCodec(int id) {
        CompressionCodec codec = HFILE_COMPRESSION_CODEC_MAP.get(id);
        if (codec == null) {
            throw new IllegalArgumentException("Compression code not found for ID: " + id);
        }
        return codec;
    }

    public static int readMajorVersion(byte[] bytes, int offset) {
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        int ch3 = bytes[offset + 2] & 0xFF;
        return (ch1 << 16) + (ch2 << 8) + ch3;
    }

    public static int compareKeys(Key key1, Key key2) {
        return IOUtils.compareTo(key1.getBytes(), key1.getContentOffset(), key1.getContentLength(), key2.getBytes(), key2.getContentOffset(), key2.getContentLength());
    }

    public static boolean isPrefixOfKey(Key prefix, Key key) {
        int keyLength;
        int prefixLength = prefix.getContentLength();
        if (prefixLength > (keyLength = key.getLength())) {
            return false;
        }
        byte[] prefixBytes = prefix.getBytes();
        byte[] keyBytes = key.getBytes();
        for (int i = 0; i < prefixLength; ++i) {
            if (prefixBytes[prefix.getContentOffset() + i] == keyBytes[key.getContentOffset() + i]) continue;
            return false;
        }
        return true;
    }

    public static String getValue(KeyValue kv) {
        return StringUtils.fromUTF8Bytes(kv.getBytes(), kv.getValueOffset(), kv.getValueLength());
    }

    private static Map<Integer, CompressionCodec> createCompressionCodecMap() {
        HashMap<Integer, CompressionCodec> result = new HashMap<Integer, CompressionCodec>();
        result.put(0, CompressionCodec.LZO);
        result.put(1, CompressionCodec.GZIP);
        result.put(2, CompressionCodec.NONE);
        result.put(3, CompressionCodec.SNAPPY);
        result.put(4, CompressionCodec.LZ4);
        result.put(5, CompressionCodec.BZIP2);
        result.put(6, CompressionCodec.ZSTD);
        return Collections.unmodifiableMap(result);
    }
}

