/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.util.IOUtils;

public class HFileRootIndexBlock
extends HFileBlock {
    public HFileRootIndexBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.ROOT_INDEX, byteBuff, startOffsetInBuff);
    }

    public TreeMap<Key, BlockIndexEntry> readBlockIndex(int numEntries, boolean contentKeyOnly) {
        int i;
        TreeMap<Key, BlockIndexEntry> blockIndexEntryMap = new TreeMap<Key, BlockIndexEntry>();
        int buffOffset = this.startOffsetInBuff + 33;
        ArrayList<UTF8StringKey> keyList = new ArrayList<UTF8StringKey>();
        ArrayList<Long> offsetList = new ArrayList<Long>();
        ArrayList<Integer> sizeList = new ArrayList<Integer>();
        for (i = 0; i < numEntries; ++i) {
            long offset = IOUtils.readLong(this.byteBuff, buffOffset);
            int size = IOUtils.readInt(this.byteBuff, buffOffset + 8);
            int varLongSizeOnDist = IOUtils.decodeVarLongSizeOnDisk(this.byteBuff, buffOffset + 12);
            int keyLength = (int)IOUtils.readVarLong(this.byteBuff, buffOffset + 12, varLongSizeOnDist);
            byte[] keyBytes = IOUtils.copy(this.byteBuff, buffOffset + 12 + varLongSizeOnDist, keyLength);
            Key key = contentKeyOnly ? new UTF8StringKey(keyBytes) : new Key(keyBytes);
            keyList.add((UTF8StringKey)key);
            offsetList.add(offset);
            sizeList.add(size);
            buffOffset += 12 + varLongSizeOnDist + keyLength;
        }
        for (i = 0; i < numEntries; ++i) {
            Key key = (Key)keyList.get(i);
            blockIndexEntryMap.put(key, new BlockIndexEntry(key, i < numEntries - 1 ? Option.of(keyList.get(i + 1)) : Option.empty(), (Long)offsetList.get(i), (Integer)sizeList.get(i)));
        }
        return blockIndexEntryMap;
    }
}

