/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.util;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hudi.io.util.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestIOUtils {
    private static final byte[] BYTE_ARRAY = new byte[]{-56, 54, 9, -14, -91, 125, 1, 72, -119, 102};

    @Test
    public void testReadInt() {
        Assertions.assertEquals((int)-935982606, (int)IOUtils.readInt((byte[])BYTE_ARRAY, (int)0));
        Assertions.assertEquals((int)906621605, (int)IOUtils.readInt((byte[])BYTE_ARRAY, (int)1));
        Assertions.assertEquals((int)166897021, (int)IOUtils.readInt((byte[])BYTE_ARRAY, (int)2));
    }

    @Test
    public void testReadLong() {
        Assertions.assertEquals((long)-4020014679618420408L, (long)IOUtils.readLong((byte[])BYTE_ARRAY, (int)0));
        Assertions.assertEquals((long)3893910145419266185L, (long)IOUtils.readLong((byte[])BYTE_ARRAY, (int)1));
        Assertions.assertEquals((long)716817247016356198L, (long)IOUtils.readLong((byte[])BYTE_ARRAY, (int)2));
    }

    @Test
    public void testReadShort() {
        Assertions.assertEquals((int)-14282, (int)IOUtils.readShort((byte[])BYTE_ARRAY, (int)0));
        Assertions.assertEquals((int)13833, (int)IOUtils.readShort((byte[])BYTE_ARRAY, (int)1));
        Assertions.assertEquals((int)2546, (int)IOUtils.readShort((byte[])BYTE_ARRAY, (int)2));
    }

    private static Stream<Arguments> decodeVariableLengthNumberParams() {
        Object[][] data = new Object[][]{{new byte[]{0}, 0}, {new byte[]{-108}, -108}, {new byte[]{98}, 98}, {new byte[]{-113, -48}, 208}, {new byte[]{-114, 125, 80}, 32080}, {new byte[]{-115, 31, 13, 14}, 2034958}, {new byte[]{-121, -54}, -203}, {new byte[]{-116, 37, -77, 17, 62}, 632492350}, {new byte[]{-124, 1, -10, 100, -127}, -32924802}, {new byte[]{-116, 127, -1, -1, -1}, Integer.MAX_VALUE}, {new byte[]{-124, 127, -1, -1, -1}, Integer.MIN_VALUE}, {new byte[]{-118, 20, -17, -92, -41, 107, -78}, 23019495320498L}, {new byte[]{-127, 2, -7, -102, -100, -69, -93, -109}, -837392403243924L}, {new byte[]{-120, 127, -1, -1, -1, -1, -1, -1, -1}, Long.MAX_VALUE}, {new byte[]{-128, 127, -1, -1, -1, -1, -1, -1, -1}, Long.MIN_VALUE}};
        return Stream.of(data).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"decodeVariableLengthNumberParams"})
    public void testDecodeVariableLengthNumber(byte[] bytes, long expectedNumber) throws IOException {
        int size = IOUtils.decodeVarLongSizeOnDisk((byte[])bytes, (int)0);
        Assertions.assertEquals((int)bytes.length, (int)size);
        Assertions.assertEquals((int)bytes.length, (int)IOUtils.decodeVarLongSize((byte)bytes[0]));
        Assertions.assertEquals((long)expectedNumber, (long)IOUtils.readVarLong((byte[])bytes, (int)0));
        Assertions.assertEquals((long)expectedNumber, (long)IOUtils.readVarLong((byte[])bytes, (int)0, (int)size));
        Assertions.assertEquals((Object)(expectedNumber < 0L ? 1 : 0), (Object)IOUtils.isNegativeVarLong((byte)bytes[0]));
    }

    @Test
    public void testByteArrayCompareTo() {
        byte[] bytes1 = new byte[]{-101, 0, 24, 101, 46, -13};
        byte[] bytes2 = new byte[]{-101, 0, 24, 101, 28, 56, 83};
        Assertions.assertEquals((int)0, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)4, (byte[])bytes1, (int)0, (int)4));
        Assertions.assertEquals((int)-2, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)4, (byte[])bytes1, (int)0, (int)6));
        Assertions.assertEquals((int)1, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)5, (byte[])bytes1, (int)0, (int)4));
        Assertions.assertEquals((int)0, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)4, (byte[])bytes2, (int)0, (int)4));
        Assertions.assertEquals((int)-2, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)4, (byte[])bytes2, (int)0, (int)6));
        Assertions.assertEquals((int)2, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)6, (byte[])bytes1, (int)0, (int)4));
        Assertions.assertEquals((int)18, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)5, (byte[])bytes2, (int)0, (int)5));
        Assertions.assertEquals((int)18, (int)IOUtils.compareTo((byte[])bytes1, (int)0, (int)6, (byte[])bytes2, (int)0, (int)6));
        Assertions.assertEquals((int)-155, (int)IOUtils.compareTo((byte[])bytes1, (int)1, (int)4, (byte[])bytes2, (int)0, (int)5));
        Assertions.assertEquals((int)22, (int)IOUtils.compareTo((byte[])bytes1, (int)4, (int)2, (byte[])bytes2, (int)2, (int)4));
    }

    @Test
    public void testIndexOf() {
        byte[] array = new byte[]{-101, 0, 24, 101, 46, -13};
        Assertions.assertEquals((int)0, (int)IOUtils.indexOf((byte[])array, (byte[])new byte[0]));
        Assertions.assertEquals((int)0, (int)IOUtils.indexOf((byte[])array, (byte[])new byte[]{-101, 0}));
        Assertions.assertEquals((int)2, (int)IOUtils.indexOf((byte[])array, (byte[])new byte[]{24, 101, 46}));
        Assertions.assertEquals((int)4, (int)IOUtils.indexOf((byte[])array, (byte[])new byte[]{46, -13}));
        Assertions.assertEquals((int)-1, (int)IOUtils.indexOf((byte[])array, (byte[])new byte[]{46, -13, 49}));
        Assertions.assertEquals((int)-1, (int)IOUtils.indexOf((byte[])array, (byte[])new byte[]{49}));
    }

    @Test
    public void testToBytes() {
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 20}, (byte[])IOUtils.toBytes((int)20));
        Assertions.assertArrayEquals((byte[])new byte[]{2, -109, -19, -120}, (byte[])IOUtils.toBytes((int)43249032));
        Assertions.assertArrayEquals((byte[])new byte[]{25, -103, -102, 97}, (byte[])IOUtils.toBytes((int)429496929));
        Assertions.assertArrayEquals((byte[])new byte[]{127, -1, -1, -1}, (byte[])IOUtils.toBytes((int)Integer.MAX_VALUE));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 20}, (byte[])IOUtils.toBytes((long)20L));
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 73, 82, 69, 50}, (byte[])IOUtils.toBytes((long)1230128434L));
        Assertions.assertArrayEquals((byte[])new byte[]{25, -103, -103, -103, -103, -103, -102, 97}, (byte[])IOUtils.toBytes((long)1844674407370955361L));
        Assertions.assertArrayEquals((byte[])new byte[]{127, -1, -1, -1, -1, -1, -1, -1}, (byte[])IOUtils.toBytes((long)Long.MAX_VALUE));
    }
}

