/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestStoragePath {
    @Test
    public void testToString() {
        Arrays.stream(new String[]{"/", "/foo", "/foo/bar", "foo", "foo/bar", "/foo/bar#boo", "foo/bar#boo", "file:/a/b/c", "s3://a/b/c"}).forEach(this::toStringTest);
    }

    @Test
    public void testNormalize() throws URISyntaxException {
        Assertions.assertEquals((Object)"", (Object)new StoragePath(".").toString());
        Assertions.assertEquals((Object)"..", (Object)new StoragePath("..").toString());
        Assertions.assertEquals((Object)"/", (Object)new StoragePath("/").toString());
        Assertions.assertEquals((Object)"/", (Object)new StoragePath("//").toString());
        Assertions.assertEquals((Object)"/", (Object)new StoragePath("///").toString());
        Assertions.assertEquals((Object)"//foo/", (Object)new StoragePath("//foo/").toString());
        Assertions.assertEquals((Object)"//foo/", (Object)new StoragePath("//foo//").toString());
        Assertions.assertEquals((Object)"//foo/bar", (Object)new StoragePath("//foo//bar").toString());
        Assertions.assertEquals((Object)"/foo", (Object)new StoragePath("/foo/").toString());
        Assertions.assertEquals((Object)"/foo", (Object)new StoragePath("/foo/").toString());
        Assertions.assertEquals((Object)"foo", (Object)new StoragePath("foo/").toString());
        Assertions.assertEquals((Object)"foo", (Object)new StoragePath("foo//").toString());
        Assertions.assertEquals((Object)"foo/bar", (Object)new StoragePath("foo//bar").toString());
        Assertions.assertEquals((Object)"file:/a/b/c", (Object)new StoragePath("file:///a/b/c").toString());
        Assertions.assertEquals((Object)"s3://a/b/c/d/e", (Object)new StoragePath("s3://a/b/c", "d/e").toString());
        Assertions.assertEquals((Object)"s3://a/b/c/d/e", (Object)new StoragePath("s3://a/b/c/", "d/e").toString());
        Assertions.assertEquals((Object)"s3://a/b/c/d/e", (Object)new StoragePath("s3://a/b/c/", "d/e/").toString());
        Assertions.assertEquals((Object)"s3://a/b/c", (Object)new StoragePath("s3://a/b/c/", "/").toString());
        Assertions.assertEquals((Object)"s3://a/b/c", (Object)new StoragePath("s3://a/b/c/", "").toString());
        Assertions.assertEquals((Object)"s3://a/b/c/d/e", (Object)new StoragePath(new StoragePath("s3://a/b/c"), "d/e").toString());
        Assertions.assertEquals((Object)"s3://a/b/c/d/e", (Object)new StoragePath(new StoragePath("s3://a/b/c/"), "d/e").toString());
        Assertions.assertEquals((Object)"s3://a/b/c/d/e", (Object)new StoragePath(new StoragePath("s3://a/b/c/"), "d/e/").toString());
        Assertions.assertEquals((Object)"s3://a/b/c", (Object)new StoragePath(new StoragePath("s3://a/b/c/"), "/").toString());
        Assertions.assertEquals((Object)"s3://a/b/c", (Object)new StoragePath(new StoragePath("s3://a/b/c/"), "").toString());
        Assertions.assertEquals((Object)"hdfs://foo/foo2/bar/baz/", (Object)new StoragePath(new URI("hdfs://foo//foo2///bar/baz///")).toString());
    }

    @Test
    public void testIsAbsolute() {
        Assertions.assertTrue((boolean)new StoragePath("/").isAbsolute());
        Assertions.assertTrue((boolean)new StoragePath("/foo").isAbsolute());
        Assertions.assertFalse((boolean)new StoragePath("foo").isAbsolute());
        Assertions.assertFalse((boolean)new StoragePath("foo/bar").isAbsolute());
        Assertions.assertFalse((boolean)new StoragePath(".").isAbsolute());
    }

    @Test
    public void testGetParent() {
        Assertions.assertEquals((Object)new StoragePath("/foo"), (Object)new StoragePath("/foo/bar").getParent());
        Assertions.assertEquals((Object)new StoragePath("foo"), (Object)new StoragePath("foo/bar").getParent());
        Assertions.assertEquals((Object)new StoragePath("/"), (Object)new StoragePath("/foo").getParent());
        Assertions.assertEquals((Object)new StoragePath("/foo/bar/x"), (Object)new StoragePath("/foo/bar", "x/y").getParent());
        Assertions.assertEquals((Object)new StoragePath("/foo/bar"), (Object)new StoragePath("/foo/bar/", "y").getParent());
        Assertions.assertEquals((Object)new StoragePath("/foo"), (Object)new StoragePath("/foo/bar/", "/").getParent());
        Assertions.assertThrows(IllegalStateException.class, () -> new StoragePath("/").getParent());
    }

    @Test
    public void testURI() throws URISyntaxException {
        URI uri = new URI("file:///bar#baz");
        StoragePath path = new StoragePath(uri);
        Assertions.assertEquals((Object)uri, (Object)new URI(path.toString()));
        Assertions.assertEquals((Object)"foo://bar/baz#boo", (Object)new StoragePath("foo://bar/", "/baz#boo").toString());
        Assertions.assertEquals((Object)"foo://bar/baz/fud#boo", (Object)new StoragePath(new StoragePath(new URI("foo://bar/baz#bud")), "fud#boo").toString());
        Assertions.assertEquals((Object)"foo://bar/fud#boo", (Object)new StoragePath(new StoragePath(new URI("foo://bar/baz#bud")), "/fud#boo").toString());
    }

    @Test
    public void testEncoded() {
        Assertions.assertEquals((Object)new StoragePath("s3://foo/bar/1%2F2%2F3"), (Object)new StoragePath("s3://foo/bar", "1%2F2%2F3"));
        Assertions.assertEquals((Object)"s3://foo/bar/1%2F2%2F3", (Object)new StoragePath("s3://foo/bar", "1%2F2%2F3").toString());
        Assertions.assertEquals((Object)new StoragePath("s3://foo/bar/1%2F2%2F3"), (Object)new StoragePath(new StoragePath("s3://foo/bar"), "1%2F2%2F3"));
        Assertions.assertEquals((Object)"s3://foo/bar/1%2F2%2F3", (Object)new StoragePath(new StoragePath("s3://foo/bar"), "1%2F2%2F3").toString());
        Assertions.assertEquals((Object)"s3://foo/bar/1%2F2%2F3", (Object)new StoragePath("s3://foo/bar/1%2F2%2F3").toString());
    }

    @Test
    public void testPathToUriConversion() throws URISyntaxException {
        Assertions.assertEquals((Object)new URI(null, null, "/foo?bar", null, null), (Object)new StoragePath("/foo?bar").toUri());
        Assertions.assertEquals((Object)new URI(null, null, "/foo\"bar", null, null), (Object)new StoragePath("/foo\"bar").toUri());
        Assertions.assertEquals((Object)new URI(null, null, "/foo bar", null, null), (Object)new StoragePath("/foo bar").toUri());
        Assertions.assertEquals((Object)"/foo?bar", (Object)new StoragePath("http://localhost/foo?bar").toUri().getPath());
        Assertions.assertEquals((Object)"/foo", (Object)new URI("http://localhost/foo?bar").getPath());
        Assertions.assertEquals((Object)new URI("/foo;bar").getPath(), (Object)new StoragePath("/foo;bar").toUri().getPath());
        Assertions.assertEquals((Object)new URI("/foo;bar"), (Object)new StoragePath("/foo;bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo+bar"), (Object)new StoragePath("/foo+bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo-bar"), (Object)new StoragePath("/foo-bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo=bar"), (Object)new StoragePath("/foo=bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo,bar"), (Object)new StoragePath("/foo,bar").toUri());
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)"", (Object)new StoragePath("/").getName());
        Assertions.assertEquals((Object)"foo", (Object)new StoragePath("foo").getName());
        Assertions.assertEquals((Object)"foo", (Object)new StoragePath("/foo").getName());
        Assertions.assertEquals((Object)"foo", (Object)new StoragePath("/foo/").getName());
        Assertions.assertEquals((Object)"bar", (Object)new StoragePath("/foo/bar").getName());
        Assertions.assertEquals((Object)"bar", (Object)new StoragePath("hdfs://host/foo/bar").getName());
        Assertions.assertEquals((Object)"bar", (Object)new StoragePath("hdfs://host", "foo/bar").getName());
        Assertions.assertEquals((Object)"bar", (Object)new StoragePath("hdfs://host/foo/", "bar").getName());
    }

    @Test
    public void testGetPathWithoutSchemeAndAuthority() {
        Assertions.assertEquals((Object)new StoragePath("/foo/bar/boo"), (Object)new StoragePath("/foo/bar/boo").getPathWithoutSchemeAndAuthority());
        Assertions.assertEquals((Object)new StoragePath("/foo/bar/boo"), (Object)new StoragePath("file:///foo/bar/boo").getPathWithoutSchemeAndAuthority());
        Assertions.assertEquals((Object)new StoragePath("/bar/boo"), (Object)new StoragePath("s3://foo/bar/boo").getPathWithoutSchemeAndAuthority());
    }

    @Test
    public void testDepth() throws URISyntaxException {
        Assertions.assertEquals((int)0, (int)new StoragePath("/").depth());
        Assertions.assertEquals((int)0, (int)new StoragePath("///").depth());
        Assertions.assertEquals((int)0, (int)new StoragePath("//foo/").depth());
        Assertions.assertEquals((int)1, (int)new StoragePath("//foo//bar").depth());
        Assertions.assertEquals((int)5, (int)new StoragePath("/a/b/c/d/e").depth());
        Assertions.assertEquals((int)4, (int)new StoragePath("s3://a/b/c", "d/e").depth());
        Assertions.assertEquals((int)2, (int)new StoragePath("s3://a/b/c/", "").depth());
        Assertions.assertEquals((int)4, (int)new StoragePath(new StoragePath("s3://a/b/c"), "d/e").depth());
    }

    @Test
    public void testMakeQualified() throws URISyntaxException {
        URI defaultUri = new URI("hdfs://host1/dir1");
        Assertions.assertEquals((Object)new StoragePath("hdfs://host1/a/b/c"), (Object)new StoragePath("/a/b/c").makeQualified(defaultUri));
        Assertions.assertEquals((Object)new StoragePath("hdfs://host2/a/b/c"), (Object)new StoragePath("hdfs://host2/a/b/c").makeQualified(defaultUri));
        Assertions.assertEquals((Object)new StoragePath("hdfs://host1/a/b/c"), (Object)new StoragePath("hdfs:/a/b/c").makeQualified(defaultUri));
        Assertions.assertEquals((Object)new StoragePath("s3://a/b/c"), (Object)new StoragePath("s3://a/b/c/").makeQualified(defaultUri));
        Assertions.assertThrows(IllegalStateException.class, () -> new StoragePath("a").makeQualified(defaultUri));
    }

    @ParameterizedTest
    @ValueSource(strings={"/x/y/1.file#bar", "s3://foo/bar/1%2F2%2F3", "hdfs://host1/a/b/c"})
    public void testSerializability(String pathStr) throws IOException, ClassNotFoundException {
        StoragePath path = new StoragePath(pathStr);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(path);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                 ObjectInputStream ois = new ObjectInputStream(bais);){
                StoragePath deserialized = (StoragePath)ois.readObject();
                Assertions.assertEquals((Object)path.toUri(), (Object)deserialized.toUri());
            }
        }
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)new StoragePath("/foo"), (Object)new StoragePath("/foo"));
        Assertions.assertEquals((Object)new StoragePath("/foo"), (Object)new StoragePath("/foo/"));
        Assertions.assertEquals((Object)new StoragePath("/foo/bar"), (Object)new StoragePath("/foo//bar/"));
        Assertions.assertNotEquals((Object)new StoragePath("/"), (Object)new StoragePath("/foo"));
    }

    @Test
    public void testCachedResults() {
        StoragePath path = new StoragePath("s3://x/y/z/");
        Assertions.assertSame((Object)path.getParent(), (Object)path.getParent());
        Assertions.assertSame((Object)path.getName(), (Object)path.getName());
        Assertions.assertSame((Object)path.toString(), (Object)path.toString());
    }

    private void toStringTest(String pathString) {
        Assertions.assertEquals((Object)pathString, (Object)new StoragePath(pathString).toString());
    }
}

