// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/protobuf/duration.proto

package org.apache.hbase.thirdparty.com.google.protobuf;

/**
 * <pre>
 * A Duration represents a signed, fixed-length span of time represented
 * as a count of seconds and fractions of seconds at nanosecond
 * resolution. It is independent of any calendar and concepts like "day"
 * or "month". It is related to Timestamp in that the difference between
 * two Timestamp values is a Duration and it can be added or subtracted
 * from a Timestamp. Range is approximately +-10,000 years.
 * # Examples
 * Example 1: Compute Duration from two Timestamps in pseudo code.
 *     Timestamp start = ...;
 *     Timestamp end = ...;
 *     Duration duration = ...;
 *     duration.seconds = end.seconds - start.seconds;
 *     duration.nanos = end.nanos - start.nanos;
 *     if (duration.seconds &lt; 0 &amp;&amp; duration.nanos &gt; 0) {
 *       duration.seconds += 1;
 *       duration.nanos -= 1000000000;
 *     } else if (duration.seconds &gt; 0 &amp;&amp; duration.nanos &lt; 0) {
 *       duration.seconds -= 1;
 *       duration.nanos += 1000000000;
 *     }
 * Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.
 *     Timestamp start = ...;
 *     Duration duration = ...;
 *     Timestamp end = ...;
 *     end.seconds = start.seconds + duration.seconds;
 *     end.nanos = start.nanos + duration.nanos;
 *     if (end.nanos &lt; 0) {
 *       end.seconds -= 1;
 *       end.nanos += 1000000000;
 *     } else if (end.nanos &gt;= 1000000000) {
 *       end.seconds += 1;
 *       end.nanos -= 1000000000;
 *     }
 * Example 3: Compute Duration from datetime.timedelta in Python.
 *     td = datetime.timedelta(days=3, minutes=10)
 *     duration = Duration()
 *     duration.FromTimedelta(td)
 * # JSON Mapping
 * In JSON format, the Duration type is encoded as a string rather than an
 * object, where the string ends in the suffix "s" (indicating seconds) and
 * is preceded by the number of seconds, with nanoseconds expressed as
 * fractional seconds. For example, 3 seconds with 0 nanoseconds should be
 * encoded in JSON format as "3s", while 3 seconds and 1 nanosecond should
 * be expressed in JSON format as "3.000000001s", and 3 seconds and 1
 * microsecond should be expressed in JSON format as "3.000001s".
 * </pre>
 *
 * Protobuf type {@code google.protobuf.Duration}
 */
public final class Duration extends
    org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.protobuf.Duration)
    DurationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Duration.newBuilder() to construct.
  private Duration(org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Duration() {
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Duration();
  }

  @java.lang.Override
  public final org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Duration(
      org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream input,
      org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8: {

            seconds_ = input.readInt64();
            break;
          }
          case 16: {

            nanos_ = input.readInt32();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (org.apache.hbase.thirdparty.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return org.apache.hbase.thirdparty.com.google.protobuf.DurationProto.internal_static_google_protobuf_Duration_descriptor;
  }

  @java.lang.Override
  protected org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.hbase.thirdparty.com.google.protobuf.DurationProto.internal_static_google_protobuf_Duration_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.hbase.thirdparty.com.google.protobuf.Duration.class, org.apache.hbase.thirdparty.com.google.protobuf.Duration.Builder.class);
  }

  public static final int SECONDS_FIELD_NUMBER = 1;
  private long seconds_;
  /**
   * <pre>
   * Signed seconds of the span of time. Must be from -315,576,000,000
   * to +315,576,000,000 inclusive. Note: these bounds are computed from:
   * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
   * </pre>
   *
   * <code>int64 seconds = 1;</code>
   * @return The seconds.
   */
  @java.lang.Override
  public long getSeconds() {
    return seconds_;
  }

  public static final int NANOS_FIELD_NUMBER = 2;
  private int nanos_;
  /**
   * <pre>
   * Signed fractions of a second at nanosecond resolution of the span
   * of time. Durations less than one second are represented with a 0
   * `seconds` field and a positive or negative `nanos` field. For durations
   * of one second or more, a non-zero value for the `nanos` field must be
   * of the same sign as the `seconds` field. Must be from -999,999,999
   * to +999,999,999 inclusive.
   * </pre>
   *
   * <code>int32 nanos = 2;</code>
   * @return The nanos.
   */
  @java.lang.Override
  public int getNanos() {
    return nanos_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (seconds_ != 0L) {
      output.writeInt64(1, seconds_);
    }
    if (nanos_ != 0) {
      output.writeInt32(2, nanos_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (seconds_ != 0L) {
      size += org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream
        .computeInt64Size(1, seconds_);
    }
    if (nanos_ != 0) {
      size += org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream
        .computeInt32Size(2, nanos_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof org.apache.hbase.thirdparty.com.google.protobuf.Duration)) {
      return super.equals(obj);
    }
    org.apache.hbase.thirdparty.com.google.protobuf.Duration other = (org.apache.hbase.thirdparty.com.google.protobuf.Duration) obj;

    if (getSeconds()
        != other.getSeconds()) return false;
    if (getNanos()
        != other.getNanos()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + org.apache.hbase.thirdparty.com.google.protobuf.Internal.hashLong(
        getSeconds());
    hash = (37 * hash) + NANOS_FIELD_NUMBER;
    hash = (53 * hash) + getNanos();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      java.nio.ByteBuffer data)
      throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      java.nio.ByteBuffer data,
      org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      org.apache.hbase.thirdparty.com.google.protobuf.ByteString data)
      throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      org.apache.hbase.thirdparty.com.google.protobuf.ByteString data,
      org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(byte[] data)
      throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      byte[] data,
      org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      java.io.InputStream input,
      org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseDelimitedFrom(
      java.io.InputStream input,
      org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration parseFrom(
      org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream input,
      org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(org.apache.hbase.thirdparty.com.google.protobuf.Duration prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A Duration represents a signed, fixed-length span of time represented
   * as a count of seconds and fractions of seconds at nanosecond
   * resolution. It is independent of any calendar and concepts like "day"
   * or "month". It is related to Timestamp in that the difference between
   * two Timestamp values is a Duration and it can be added or subtracted
   * from a Timestamp. Range is approximately +-10,000 years.
   * # Examples
   * Example 1: Compute Duration from two Timestamps in pseudo code.
   *     Timestamp start = ...;
   *     Timestamp end = ...;
   *     Duration duration = ...;
   *     duration.seconds = end.seconds - start.seconds;
   *     duration.nanos = end.nanos - start.nanos;
   *     if (duration.seconds &lt; 0 &amp;&amp; duration.nanos &gt; 0) {
   *       duration.seconds += 1;
   *       duration.nanos -= 1000000000;
   *     } else if (duration.seconds &gt; 0 &amp;&amp; duration.nanos &lt; 0) {
   *       duration.seconds -= 1;
   *       duration.nanos += 1000000000;
   *     }
   * Example 2: Compute Timestamp from Timestamp + Duration in pseudo code.
   *     Timestamp start = ...;
   *     Duration duration = ...;
   *     Timestamp end = ...;
   *     end.seconds = start.seconds + duration.seconds;
   *     end.nanos = start.nanos + duration.nanos;
   *     if (end.nanos &lt; 0) {
   *       end.seconds -= 1;
   *       end.nanos += 1000000000;
   *     } else if (end.nanos &gt;= 1000000000) {
   *       end.seconds += 1;
   *       end.nanos -= 1000000000;
   *     }
   * Example 3: Compute Duration from datetime.timedelta in Python.
   *     td = datetime.timedelta(days=3, minutes=10)
   *     duration = Duration()
   *     duration.FromTimedelta(td)
   * # JSON Mapping
   * In JSON format, the Duration type is encoded as a string rather than an
   * object, where the string ends in the suffix "s" (indicating seconds) and
   * is preceded by the number of seconds, with nanoseconds expressed as
   * fractional seconds. For example, 3 seconds with 0 nanoseconds should be
   * encoded in JSON format as "3s", while 3 seconds and 1 nanosecond should
   * be expressed in JSON format as "3.000000001s", and 3 seconds and 1
   * microsecond should be expressed in JSON format as "3.000001s".
   * </pre>
   *
   * Protobuf type {@code google.protobuf.Duration}
   */
  public static final class Builder extends
      org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.protobuf.Duration)
      org.apache.hbase.thirdparty.com.google.protobuf.DurationOrBuilder {
    public static final org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.hbase.thirdparty.com.google.protobuf.DurationProto.internal_static_google_protobuf_Duration_descriptor;
    }

    @java.lang.Override
    protected org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.hbase.thirdparty.com.google.protobuf.DurationProto.internal_static_google_protobuf_Duration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.hbase.thirdparty.com.google.protobuf.Duration.class, org.apache.hbase.thirdparty.com.google.protobuf.Duration.Builder.class);
    }

    // Construct using org.apache.hbase.thirdparty.com.google.protobuf.Duration.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      seconds_ = 0L;

      nanos_ = 0;

      return this;
    }

    @java.lang.Override
    public org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return org.apache.hbase.thirdparty.com.google.protobuf.DurationProto.internal_static_google_protobuf_Duration_descriptor;
    }

    @java.lang.Override
    public org.apache.hbase.thirdparty.com.google.protobuf.Duration getDefaultInstanceForType() {
      return org.apache.hbase.thirdparty.com.google.protobuf.Duration.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.hbase.thirdparty.com.google.protobuf.Duration build() {
      org.apache.hbase.thirdparty.com.google.protobuf.Duration result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.hbase.thirdparty.com.google.protobuf.Duration buildPartial() {
      org.apache.hbase.thirdparty.com.google.protobuf.Duration result = new org.apache.hbase.thirdparty.com.google.protobuf.Duration(this);
      result.seconds_ = seconds_;
      result.nanos_ = nanos_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        org.apache.hbase.thirdparty.com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(org.apache.hbase.thirdparty.com.google.protobuf.Message other) {
      if (other instanceof org.apache.hbase.thirdparty.com.google.protobuf.Duration) {
        return mergeFrom((org.apache.hbase.thirdparty.com.google.protobuf.Duration)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.hbase.thirdparty.com.google.protobuf.Duration other) {
      if (other == org.apache.hbase.thirdparty.com.google.protobuf.Duration.getDefaultInstance()) return this;
      if (other.getSeconds() != 0L) {
        setSeconds(other.getSeconds());
      }
      if (other.getNanos() != 0) {
        setNanos(other.getNanos());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream input,
        org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.hbase.thirdparty.com.google.protobuf.Duration parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.hbase.thirdparty.com.google.protobuf.Duration) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private long seconds_ ;
    /**
     * <pre>
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     * @return The seconds.
     */
    @java.lang.Override
    public long getSeconds() {
      return seconds_;
    }
    /**
     * <pre>
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     * @param value The seconds to set.
     * @return This builder for chaining.
     */
    public Builder setSeconds(long value) {
      
      seconds_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Signed seconds of the span of time. Must be from -315,576,000,000
     * to +315,576,000,000 inclusive. Note: these bounds are computed from:
     * 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     * </pre>
     *
     * <code>int64 seconds = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearSeconds() {
      
      seconds_ = 0L;
      onChanged();
      return this;
    }

    private int nanos_ ;
    /**
     * <pre>
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     * @return The nanos.
     */
    @java.lang.Override
    public int getNanos() {
      return nanos_;
    }
    /**
     * <pre>
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     * @param value The nanos to set.
     * @return This builder for chaining.
     */
    public Builder setNanos(int value) {
      
      nanos_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Signed fractions of a second at nanosecond resolution of the span
     * of time. Durations less than one second are represented with a 0
     * `seconds` field and a positive or negative `nanos` field. For durations
     * of one second or more, a non-zero value for the `nanos` field must be
     * of the same sign as the `seconds` field. Must be from -999,999,999
     * to +999,999,999 inclusive.
     * </pre>
     *
     * <code>int32 nanos = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearNanos() {
      
      nanos_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.apache.hbase.thirdparty.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.protobuf.Duration)
  }

  // @@protoc_insertion_point(class_scope:google.protobuf.Duration)
  private static final org.apache.hbase.thirdparty.com.google.protobuf.Duration DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new org.apache.hbase.thirdparty.com.google.protobuf.Duration();
  }

  public static org.apache.hbase.thirdparty.com.google.protobuf.Duration getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.apache.hbase.thirdparty.com.google.protobuf.Parser<Duration>
      PARSER = new org.apache.hbase.thirdparty.com.google.protobuf.AbstractParser<Duration>() {
    @java.lang.Override
    public Duration parsePartialFrom(
        org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream input,
        org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException {
      return new Duration(input, extensionRegistry);
    }
  };

  public static org.apache.hbase.thirdparty.com.google.protobuf.Parser<Duration> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.hbase.thirdparty.com.google.protobuf.Parser<Duration> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.hbase.thirdparty.com.google.protobuf.Duration getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

