/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.facebook.presto.jdbc.internal.common.function;

import com.facebook.presto.jdbc.internal.common.block.Block;

import static java.util.Objects.requireNonNull;

public class SqlFunctionResult
{
    private final Block result;
    private final long cpuTimeMs;

    public SqlFunctionResult(Block result, long cpuTimeMs)
    {
        this.result = requireNonNull(result, "result is null");
        this.cpuTimeMs = cpuTimeMs;
    }

    public Block getResult()
    {
        return result;
    }

    public long getCpuTimeMs()
    {
        return cpuTimeMs;
    }
}
