package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.KeyDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.NullValueProvider;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableBiMap;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableMap.Builder;

public class ImmutableBiMapDeserializer
    extends GuavaImmutableMapDeserializer<ImmutableBiMap<Object, Object>>
{
    private static final long serialVersionUID = 2L;

    public ImmutableBiMapDeserializer(JavaType type, KeyDeserializer keyDeser,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller) {
        super(type, keyDeser, deser, typeDeser, nuller);
    }

    @Override
    protected Builder<Object, Object> createBuilder() {
        return ImmutableBiMap.builder();
    }

    @Override
    public GuavaMapDeserializer<ImmutableBiMap<Object, Object>> withResolved(KeyDeserializer keyDeser,
            JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller) {
        return new ImmutableBiMapDeserializer(_containerType, keyDeser, valueDeser, typeDeser, nuller);
    }
}
