/*
 * Javalin - https://javalin.io
 * Copyright 2017 David Åse
 * Licensed under Apache 2.0: https://github.com/tipsy/javalin/blob/master/LICENSE
 */

package io.javalin.core.util

object Header {
    const val ACCEPT = "Accept"
    const val ACCEPT_CHARSET = "Accept-Charset"
    const val ACCEPT_ENCODING = "Accept-Encoding"
    const val ACCEPT_LANGUAGE = "Accept-Language"
    const val ACCEPT_RANGES = "Accept-Ranges"
    const val ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials"
    const val ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers"
    const val ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods"
    const val ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin"
    const val ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers"
    const val ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age"
    const val ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers"
    const val ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method"
    const val AGE = "Age"
    const val ALLOW = "Allow"
    const val AUTHORIZATION = "Authorization"
    const val CACHE_CONTROL = "Cache-Control"
    const val CONNECTION = "Connection"
    const val CONTENT_ENCODING = "Content-Encoding"
    const val CONTENT_DISPOSITION = "Content-Disposition"
    const val CONTENT_LANGUAGE = "Content-Language"
    const val CONTENT_LENGTH = "Content-Length"
    const val CONTENT_LOCATION = "Content-Location"
    const val CONTENT_RANGE = "Content-Range"
    const val CONTENT_TYPE = "Content-Type"
    const val COOKIE = "Cookie"
    const val DATE = "Date"
    const val ETAG = "ETag"
    const val EXPECT = "Expect"
    const val EXPIRES = "Expires"
    const val FROM = "From"
    const val HOST = "Host"
    const val IF_MATCH = "If-Match"
    const val IF_MODIFIED_SINCE = "If-Modified-Since"
    const val IF_NONE_MATCH = "If-None-Match"
    const val IF_RANGE = "If-Range"
    const val IF_UNMODIFIED_SINCE = "If-Unmodified-Since"
    const val LAST_MODIFIED = "Last-Modified"
    const val LINK = "Link"
    const val LOCATION = "Location"
    const val MAX_FORWARDS = "Max-Forwards"
    const val ORIGIN = "Origin"
    const val PRAGMA = "Pragma"
    const val PROXY_AUTHENTICATE = "Proxy-Authenticate"
    const val PROXY_AUTHORIZATION = "Proxy-Authorization"
    const val RANGE = "Range"
    const val REFERER = "Referer"
    const val RETRY_AFTER = "Retry-After"
    const val SERVER = "Server"
    const val SET_COOKIE = "Set-Cookie"
    const val SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key"
    const val TE = "TE"
    const val TRAILER = "Trailer"
    const val TRANSFER_ENCODING = "Transfer-Encoding"
    const val UPGRADE = "Upgrade"
    const val USER_AGENT = "User-Agent"
    const val VARY = "Vary"
    const val VIA = "Via"
    const val WARNING = "Warning"
    const val WWW_AUTHENTICATE = "WWW-Authenticate"
    const val X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override"
}
