/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.realtime.RealtimeCompactedRecordReader;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.realtime.RealtimeUnmergedRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieRealtimeRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    public static final String REALTIME_SKIP_MERGE_PROP = "hoodie.realtime.merge.skip";
    public static final String DEFAULT_REALTIME_SKIP_MERGE = "false";
    private static final Logger LOG = LoggerFactory.getLogger(HoodieRealtimeRecordReader.class);
    private final RecordReader<NullWritable, ArrayWritable> reader;

    public HoodieRealtimeRecordReader(RealtimeSplit split, JobConf job, RecordReader<NullWritable, ArrayWritable> realReader) {
        this.reader = HoodieRealtimeRecordReader.constructRecordReader(split, job, realReader);
    }

    public static boolean canSkipMerging(JobConf jobConf) {
        return Boolean.parseBoolean(jobConf.get(REALTIME_SKIP_MERGE_PROP, DEFAULT_REALTIME_SKIP_MERGE));
    }

    private static RecordReader<NullWritable, ArrayWritable> constructRecordReader(RealtimeSplit split, JobConf jobConf, RecordReader<NullWritable, ArrayWritable> realReader) {
        try {
            if (HoodieRealtimeRecordReader.canSkipMerging(jobConf)) {
                LOG.info("Enabling un-merged reading of realtime records");
                return new RealtimeUnmergedRecordReader(split, jobConf, realReader);
            }
            LOG.info("Enabling merged reading of realtime records for split " + split);
            return new RealtimeCompactedRecordReader(split, jobConf, realReader);
        }
        catch (Exception e) {
            LOG.error("Got exception when constructing record reader", (Throwable)e);
            try {
                if (null != realReader) {
                    realReader.close();
                }
            }
            catch (IOException ioe) {
                LOG.error("Unable to close real reader", (Throwable)ioe);
            }
            throw new HoodieException("Exception when constructing record reader ", (Throwable)e);
        }
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        return this.reader.next((Object)key, (Object)value);
    }

    public NullWritable createKey() {
        return (NullWritable)this.reader.createKey();
    }

    public ArrayWritable createValue() {
        return (ArrayWritable)this.reader.createValue();
    }

    public long getPos() throws IOException {
        return this.reader.getPos();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() throws IOException {
        return this.reader.getProgress();
    }

    public RecordReader<NullWritable, ArrayWritable> getReader() {
        return this.reader;
    }
}

