/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.HiveHoodieReaderContext;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.hadoop.utils.ObjectInspectorCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieFileGroupReaderBasedRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieFileGroupReaderBasedRecordReader.class);
    private final HiveHoodieReaderContext readerContext;
    private final HoodieFileGroupReader<ArrayWritable> fileGroupReader;
    private final ArrayWritable arrayWritable;
    private final NullWritable nullWritable = NullWritable.get();
    private final InputSplit inputSplit;
    private final JobConf jobConfCopy;
    private final UnaryOperator<ArrayWritable> reverseProjection;

    public HoodieFileGroupReaderBasedRecordReader(HiveReaderCreator readerCreator, InputSplit split, JobConf jobConf) throws IOException {
        this.jobConfCopy = new JobConf((Configuration)jobConf);
        HoodieRealtimeInputFormatUtils.cleanProjectionColumnIds((Configuration)this.jobConfCopy);
        HashSet<String> partitionColumns = new HashSet<String>(HoodieInputFormatUtils.getPartitionFieldNames(this.jobConfCopy));
        this.inputSplit = split;
        FileSplit fileSplit = (FileSplit)split;
        String tableBasePath = HoodieInputFormatUtils.getTableBasePath(split, this.jobConfCopy);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConf((Configuration)this.jobConfCopy)).setBasePath(tableBasePath).build();
        String latestCommitTime = HoodieFileGroupReaderBasedRecordReader.getLatestCommitTime(split, metaClient);
        Schema tableSchema = HoodieFileGroupReaderBasedRecordReader.getLatestTableSchema(metaClient, this.jobConfCopy, latestCommitTime);
        Schema requestedSchema = HoodieFileGroupReaderBasedRecordReader.createRequestedSchema(tableSchema, this.jobConfCopy);
        this.readerContext = new HiveHoodieReaderContext(readerCreator, HoodieFileGroupReaderBasedRecordReader.getRecordKeyField(metaClient), HoodieFileGroupReaderBasedRecordReader.getStoredPartitionFieldNames(this.jobConfCopy, tableSchema), new ObjectInspectorCache(tableSchema, this.jobConfCopy));
        this.arrayWritable = new ArrayWritable(Writable.class, new Writable[requestedSchema.getFields().size()]);
        TypedProperties props = metaClient.getTableConfig().getProps();
        jobConf.forEach(e -> {
            if (((String)e.getKey()).startsWith("hoodie")) {
                props.setProperty((String)e.getKey(), (String)e.getValue());
            }
        });
        if (props.containsKey((Object)"hoodie.realtime.merge.skip") && !ConfigUtils.containsConfigProperty((TypedProperties)props, (ConfigProperty)HoodieReaderConfig.MERGE_TYPE)) {
            if (props.getString("hoodie.realtime.merge.skip").equalsIgnoreCase("true")) {
                props.setProperty(HoodieReaderConfig.MERGE_TYPE.key(), "skip_merge");
            } else {
                props.setProperty(HoodieReaderConfig.MERGE_TYPE.key(), "payload_combine");
            }
        }
        LOG.debug("Creating HoodieFileGroupReaderRecordReader with tableBasePath={}, latestCommitTime={}, fileSplit={}", new Object[]{tableBasePath, latestCommitTime, fileSplit.getPath()});
        this.fileGroupReader = new HoodieFileGroupReader((HoodieReaderContext)this.readerContext, metaClient.getStorage(), tableBasePath, latestCommitTime, HoodieFileGroupReaderBasedRecordReader.getFileSliceFromSplit(fileSplit, HadoopFSUtils.getFs((String)tableBasePath, (Configuration)this.jobConfCopy), tableBasePath), tableSchema, requestedSchema, Option.empty(), metaClient, props, fileSplit.getStart(), fileSplit.getLength(), false, false);
        this.fileGroupReader.initRecordIterators();
        Schema outputSchema = HoodieAvroUtils.generateProjectionSchema((Schema)tableSchema, Stream.concat(tableSchema.getFields().stream().map(f -> f.name().toLowerCase(Locale.ROOT)).filter(n -> !partitionColumns.contains(n)), partitionColumns.stream()).collect(Collectors.toList()));
        this.reverseProjection = this.readerContext.reverseProjectRecord(requestedSchema, outputSchema);
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        if (!this.fileGroupReader.hasNext()) {
            return false;
        }
        value.set(((ArrayWritable)this.fileGroupReader.next()).get());
        this.reverseProjection.apply(value);
        return true;
    }

    public NullWritable createKey() {
        return this.nullWritable;
    }

    public ArrayWritable createValue() {
        return this.arrayWritable;
    }

    public long getPos() throws IOException {
        return this.readerContext.getPos();
    }

    public void close() throws IOException {
        this.fileGroupReader.close();
    }

    public float getProgress() throws IOException {
        return this.readerContext.getProgress();
    }

    @VisibleForTesting
    static String getRecordKeyField(HoodieTableMetaClient metaClient) {
        if (metaClient.getTableConfig().populateMetaFields()) {
            return HoodieRecord.RECORD_KEY_METADATA_FIELD;
        }
        Option recordKeyFieldsOpt = metaClient.getTableConfig().getRecordKeyFields();
        ValidationUtils.checkArgument((boolean)recordKeyFieldsOpt.isPresent(), (String)"No record key field set in table config, but populateMetaFields is disabled");
        ValidationUtils.checkArgument((((String[])recordKeyFieldsOpt.get()).length == 1 ? 1 : 0) != 0, (String)"More than 1 record key set in table config, but populateMetaFields is disabled");
        return ((String[])recordKeyFieldsOpt.get())[0];
    }

    @VisibleForTesting
    static List<String> getStoredPartitionFieldNames(JobConf jobConf, Schema writerSchema) {
        return HoodieInputFormatUtils.getPartitionFieldNames(jobConf).stream().filter(n -> writerSchema.getField(n) != null).collect(Collectors.toList());
    }

    public RealtimeSplit getSplit() {
        return (RealtimeSplit)this.inputSplit;
    }

    public JobConf getJobConf() {
        return this.jobConfCopy;
    }

    private static Schema getLatestTableSchema(HoodieTableMetaClient metaClient, JobConf jobConf, String latestCommitTime) {
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        try {
            Schema schema = tableSchemaResolver.getTableAvroSchema(latestCommitTime);
            return HoodieRealtimeRecordReaderUtils.addPartitionFields(schema, HoodieInputFormatUtils.getPartitionFieldNames(jobConf));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get table schema", e);
        }
    }

    private static String getLatestCommitTime(InputSplit split, HoodieTableMetaClient metaClient) {
        if (split instanceof RealtimeSplit) {
            return ((RealtimeSplit)split).getMaxCommitTime();
        }
        Option lastInstant = metaClient.getCommitsTimeline().lastInstant();
        if (lastInstant.isPresent()) {
            return ((HoodieInstant)lastInstant.get()).requestedTime();
        }
        return "";
    }

    private static FileSlice getFileSliceFromSplit(FileSplit split, FileSystem fs, String tableBasePath) throws IOException {
        BaseFile bootstrapBaseFile = HoodieFileGroupReaderBasedRecordReader.createBootstrapBaseFile(split, fs);
        if (split instanceof RealtimeSplit) {
            String commitTime;
            String fileID;
            RealtimeSplit realtimeSplit = (RealtimeSplit)split;
            boolean isLogFile = HadoopFSUtils.isLogFile((Path)realtimeSplit.getPath());
            if (isLogFile) {
                fileID = HadoopFSUtils.getFileIdFromLogPath((Path)realtimeSplit.getPath());
                commitTime = HadoopFSUtils.getDeltaCommitTimeFromLogPath((Path)realtimeSplit.getPath());
            } else {
                fileID = FSUtils.getFileId((String)realtimeSplit.getPath().getName());
                commitTime = FSUtils.getCommitTime((String)realtimeSplit.getPath().toString());
            }
            HoodieFileGroupId fileGroupId = new HoodieFileGroupId(HadoopFSUtils.getRelativePartitionPath((Path)new Path(realtimeSplit.getBasePath()), (Path)realtimeSplit.getPath()), fileID);
            if (isLogFile) {
                return new FileSlice(fileGroupId, commitTime, null, realtimeSplit.getDeltaLogFiles());
            }
            HoodieBaseFile hoodieBaseFile = new HoodieBaseFile(HadoopFSUtils.convertToStoragePathInfo((FileStatus)fs.getFileStatus(realtimeSplit.getPath()), (String[])realtimeSplit.getLocations()), bootstrapBaseFile);
            return new FileSlice(fileGroupId, commitTime, hoodieBaseFile, realtimeSplit.getDeltaLogFiles());
        }
        HoodieFileGroupId fileGroupId = new HoodieFileGroupId(FSUtils.getFileId((String)split.getPath().getName()), HadoopFSUtils.getRelativePartitionPath((Path)new Path(tableBasePath), (Path)split.getPath()));
        return new FileSlice(fileGroupId, FSUtils.getCommitTime((String)split.getPath().toString()), new HoodieBaseFile(HadoopFSUtils.convertToStoragePathInfo((FileStatus)fs.getFileStatus(split.getPath()), (String[])split.getLocations()), bootstrapBaseFile), Collections.emptyList());
    }

    private static BaseFile createBootstrapBaseFile(FileSplit split, FileSystem fs) throws IOException {
        if (split instanceof BootstrapBaseFileSplit) {
            BootstrapBaseFileSplit bootstrapBaseFileSplit = (BootstrapBaseFileSplit)split;
            FileSplit bootstrapFileSplit = bootstrapBaseFileSplit.getBootstrapFileSplit();
            return new BaseFile(HadoopFSUtils.convertToStoragePathInfo((FileStatus)fs.getFileStatus(bootstrapFileSplit.getPath()), (String[])bootstrapFileSplit.getLocations()));
        }
        return null;
    }

    private static Schema createRequestedSchema(Schema tableSchema, JobConf jobConf) {
        String readCols = jobConf.get("hive.io.file.readcolumn.names");
        if (StringUtils.isNullOrEmpty((String)readCols)) {
            Schema emptySchema = Schema.createRecord((String)tableSchema.getName(), (String)tableSchema.getDoc(), (String)tableSchema.getNamespace(), (boolean)tableSchema.isError());
            emptySchema.setFields(Collections.emptyList());
            return emptySchema;
        }
        String partitionColString = jobConf.get("partition_columns");
        Set partitionColumns = partitionColString == null ? Collections.emptySet() : Arrays.stream(partitionColString.split(",")).collect(Collectors.toSet());
        tableSchema.getFields().forEach(f -> partitionColumns.remove(f.name().toLowerCase(Locale.ROOT)));
        return HoodieAvroUtils.generateProjectionSchema((Schema)tableSchema, Arrays.stream(jobConf.get("hive.io.file.readcolumn.names").split(",")).filter(c -> !partitionColumns.contains(c)).collect(Collectors.toList()));
    }

    public static interface HiveReaderCreator {
        public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit var1, JobConf var2) throws IOException;
    }
}

