/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

public enum StorageSchemes {
    FILE("file", false, true, null),
    HDFS("hdfs", false, true, null),
    AFS("afs", null, null, null),
    MAPRFS("maprfs", null, null, null),
    IGNITE("igfs", null, null, null),
    S3A("s3a", true, null, "org.apache.hudi.aws.transaction.lock.S3StorageLockClient"),
    S3("s3", true, null, "org.apache.hudi.aws.transaction.lock.S3StorageLockClient"),
    GCS("gs", true, null, null),
    WASB("wasb", null, null, null),
    WASBS("wasbs", null, null, null),
    ADL("adl", null, null, null),
    ABFS("abfs", null, null, null),
    ABFSS("abfss", null, null, null),
    OSS("oss", null, null, null),
    VIEWFS("viewfs", null, true, null),
    ALLUXIO("alluxio", null, null, null),
    COSN("cosn", null, null, null),
    CHDFS("ofs", null, null, null),
    GOOSEFS("gfs", null, null, null),
    DBFS("dbfs", null, null, null),
    COS("cos", null, null, null),
    OBS("obs", null, null, null),
    KS3("ks3", null, null, null),
    NOS("nos", null, null, null),
    JFS("jfs", null, null, null),
    BOS("bos", null, null, null),
    OCI("oci", null, null, null),
    TOS("tos", null, null, null),
    CFS("cfs", null, null, null),
    DFS("dfs", false, true, null),
    HOPSFS("hopsfs", false, true, null);

    private static final Set<String> LIST_STATUS_FRIENDLY_SCHEMES;
    private final String scheme;
    private final Boolean isWriteTransactional;
    private final Boolean supportAtomicCreation;
    private final String storageLockClass;

    private StorageSchemes(String scheme, Boolean isWriteTransactional, Boolean supportAtomicCreation, String storageLockClass) {
        this.scheme = scheme;
        this.isWriteTransactional = isWriteTransactional;
        this.supportAtomicCreation = supportAtomicCreation;
        this.storageLockClass = storageLockClass;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isWriteTransactional() {
        return this.isWriteTransactional != null && this.isWriteTransactional != false;
    }

    public boolean isAtomicCreationSupported() {
        return this.supportAtomicCreation != null && this.supportAtomicCreation != false;
    }

    public boolean implementsStorageLock() {
        return !StringUtils.isNullOrEmpty(this.storageLockClass);
    }

    public String getStorageLockClass() {
        return this.storageLockClass;
    }

    public static boolean isSchemeSupported(String scheme) {
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getScheme().equals(scheme));
    }

    public static boolean isWriteTransactional(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isWriteTransactional() && s.scheme.equals(scheme));
    }

    public static boolean isAtomicCreationSupported(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isAtomicCreationSupported() && s.scheme.equals(scheme));
    }

    public static boolean isListStatusFriendly(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return LIST_STATUS_FRIENDLY_SCHEMES.contains(scheme);
    }

    public static Option<StorageSchemes> getStorageLockImplementationIfExists(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Option.fromJavaOptional(Arrays.stream(StorageSchemes.values()).filter(s -> s.implementsStorageLock() && s.scheme.equals(scheme)).findFirst());
    }

    static {
        LIST_STATUS_FRIENDLY_SCHEMES = new HashSet<String>(Arrays.asList(StorageSchemes.FILE.scheme, StorageSchemes.S3.scheme, StorageSchemes.S3A.scheme, StorageSchemes.GCS.scheme));
    }
}

