/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import org.apache.hudi.org.apache.hadoop.hbase.util.Methods;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ShutdownHookManager {
    private static ShutdownHookManager instance;
    static Class shutdownHookManagerClass;

    public abstract void addShutdownHook(Thread var1, int var2);

    public abstract boolean removeShutdownHook(Runnable var1);

    public static void affixShutdownHook(Thread shutdownHook, int priority) {
        instance.addShutdownHook(shutdownHook, priority);
    }

    public static boolean deleteShutdownHook(Runnable shutdownHook) {
        return instance.removeShutdownHook(shutdownHook);
    }

    static {
        shutdownHookManagerClass = null;
        try {
            shutdownHookManagerClass = Class.forName("org.apache.hadoop.util.ShutdownHookManager");
            instance = new ShutdownHookManagerV2();
        }
        catch (Exception e) {
            instance = new ShutdownHookManagerV1();
        }
    }

    private static class ShutdownHookManagerV2
    extends ShutdownHookManager {
        private ShutdownHookManagerV2() {
        }

        @Override
        public void addShutdownHook(Thread shutdownHookThread, int priority) {
            try {
                Methods.call(shutdownHookManagerClass, Methods.call(shutdownHookManagerClass, null, "get", null, null), "addShutdownHook", new Class[]{Runnable.class, Integer.TYPE}, new Object[]{shutdownHookThread, priority});
            }
            catch (Exception ex) {
                throw new RuntimeException("we could not use ShutdownHookManager.addShutdownHook", ex);
            }
        }

        @Override
        public boolean removeShutdownHook(Runnable shutdownHook) {
            try {
                return (Boolean)Methods.call(shutdownHookManagerClass, Methods.call(shutdownHookManagerClass, null, "get", null, null), "removeShutdownHook", new Class[]{Runnable.class}, new Object[]{shutdownHook});
            }
            catch (Exception ex) {
                throw new RuntimeException("we could not use ShutdownHookManager", ex);
            }
        }
    }

    private static class ShutdownHookManagerV1
    extends ShutdownHookManager {
        private ShutdownHookManagerV1() {
        }

        @Override
        public void addShutdownHook(Thread shutdownHookThread, int priority) {
            Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        }

        @Override
        public boolean removeShutdownHook(Runnable shutdownHook) {
            Thread shutdownHookThread = null;
            shutdownHookThread = !(shutdownHook instanceof Thread) ? new Thread(shutdownHook) : (Thread)shutdownHook;
            return Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        }
    }
}

