/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ObjectPool<K, V> {
    protected final ReferenceQueue<V> staleRefQueue = new ReferenceQueue();
    private final ObjectFactory<K, V> objectFactory;
    protected final ConcurrentMap<K, Reference<V>> referenceCache;
    private final Lock purgeLock = new ReentrantLock();
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;

    public ObjectPool(ObjectFactory<K, V> objectFactory) {
        this(objectFactory, 16, 16);
    }

    public ObjectPool(ObjectFactory<K, V> objectFactory, int initialCapacity) {
        this(objectFactory, initialCapacity, 16);
    }

    public ObjectPool(ObjectFactory<K, V> objectFactory, int initialCapacity, int concurrencyLevel) {
        if (objectFactory == null) {
            throw new NullPointerException("Given object factory instance is NULL");
        }
        this.objectFactory = objectFactory;
        this.referenceCache = new ConcurrentHashMap<K, Reference<V>>(initialCapacity, 0.75f, concurrencyLevel);
    }

    public void purge() {
        if (this.purgeLock.tryLock()) {
            try {
                Reference<V> ref;
                while ((ref = this.staleRefQueue.poll()) != null) {
                    this.referenceCache.remove(this.getReferenceKey(ref), ref);
                }
            }
            finally {
                this.purgeLock.unlock();
            }
        }
    }

    public abstract Reference<V> createReference(K var1, V var2);

    public abstract K getReferenceKey(Reference<V> var1);

    public V get(K key) {
        Reference ref = (Reference)this.referenceCache.get(key);
        if (ref != null) {
            Object obj = ref.get();
            if (obj != null) {
                return (V)obj;
            }
            this.referenceCache.remove(key, ref);
        }
        V newObj = this.objectFactory.createObject(key);
        Reference<V> newRef = this.createReference(key, newObj);
        Reference<V> existingRef;
        while ((existingRef = this.referenceCache.putIfAbsent(key, newRef)) != null) {
            V existingObject = existingRef.get();
            if (existingObject != null) {
                return existingObject;
            }
            this.referenceCache.remove(key, existingRef);
        }
        return newObj;
    }

    public int size() {
        return this.referenceCache.size();
    }

    public static interface ObjectFactory<K, V> {
        public V createObject(K var1);
    }
}

