/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.tmpl.common;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hudi.org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hudi.org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TaskMonitorTmplImpl
extends AbstractTemplateImpl
implements TaskMonitorTmpl.Intf {
    private final String filter;
    private final String format;
    private final String parent;
    private final TaskMonitor taskMonitor;

    protected static TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(TaskMonitorTmpl.ImplData p_implData) {
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        if (!p_implData.getParent__IsNotDefault()) {
            p_implData.setParent("");
        }
        if (!p_implData.getTaskMonitor__IsNotDefault()) {
            p_implData.setTaskMonitor(TaskMonitor.get());
        }
        return p_implData;
    }

    public TaskMonitorTmplImpl(TemplateManager p_templateManager, TaskMonitorTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TaskMonitorTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.filter = p_implData.getFilter();
        this.format = p_implData.getFormat();
        this.parent = p_implData.getParent();
        this.taskMonitor = p_implData.getTaskMonitor();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json")) {
            jamonWriter.write("\n    ");
            this.__jamon_innerUnit__renderTasks(jamonWriter, this.filter);
            jamonWriter.write("\n");
        } else {
            jamonWriter.write("\n  <h2><a name=\"tasks\">Tasks</a></h2>\n\n  <div class=\"tabbable\">\n      <ul class=\"nav nav-pills\">\n        <li class=\"\">\n            <a href=\"#tab_alltasks\" data-toggle=\"tab\">Show All Monitored Tasks</a>\n        </li>\n        <li class=\"active\">\n            <a href=\"#tab_generaltasks\" data-toggle=\"tab\">Show non-RPC Tasks</a>\n        </li>\n        <li class=\"\">\n            <a href=\"#tab_handlertasks\" data-toggle=\"tab\">Show All RPC Handler Tasks</a>\n        </li>\n        <li class=\"\">\n            <a href=\"#tab_rpctasks\" data-toggle=\"tab\">Show Active RPC Calls</a>\n        </li>\n        <li>\n            <a href=\"#tab_operationtasks\" data-toggle=\"tab\">Show Client Operations</a>\n        </li>\n      </ul>\n      <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane\" id=\"tab_alltasks\">\n            ");
            this.__jamon_innerUnit__jsonView(jamonWriter, "all");
            jamonWriter.write("\n            ");
            this.__jamon_innerUnit__renderTasks(jamonWriter, "all");
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane active\" id=\"tab_generaltasks\">\n            ");
            this.__jamon_innerUnit__jsonView(jamonWriter, "general");
            jamonWriter.write("\n            ");
            this.__jamon_innerUnit__renderTasks(jamonWriter, "general");
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_handlertasks\">\n            ");
            this.__jamon_innerUnit__jsonView(jamonWriter, "handler");
            jamonWriter.write("\n            ");
            this.__jamon_innerUnit__renderTasks(jamonWriter, "handler");
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rpctasks\">\n            ");
            this.__jamon_innerUnit__jsonView(jamonWriter, "rpc");
            jamonWriter.write("\n            ");
            this.__jamon_innerUnit__renderTasks(jamonWriter, "rpc");
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_operationtasks\">\n            ");
            this.__jamon_innerUnit__jsonView(jamonWriter, "operation");
            jamonWriter.write("\n            ");
            this.__jamon_innerUnit__renderTasks(jamonWriter, "operation");
            jamonWriter.write("\n        </div>\n      </div>\n  </div>\n");
        }
        jamonWriter.write("\n\n");
    }

    private void __jamon_innerUnit__jsonView(Writer jamonWriter, String filter) throws IOException {
        jamonWriter.write("<a href=\"");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.parent), jamonWriter);
        jamonWriter.write("?format=json&filter=");
        Escaping.HTML.write(StandardEmitter.valueOf((String)filter), jamonWriter);
        jamonWriter.write("\">View as JSON</a>\n");
    }

    private void __jamon_innerUnit__renderTasks(Writer jamonWriter, String filter) throws IOException {
        List<MonitoredTask> tasks = this.taskMonitor.getTasks(filter);
        long now = System.currentTimeMillis();
        Collections.sort(tasks, (t1, t2) -> Long.compare(t1.getStateTime(), t2.getStateTime()));
        boolean first = true;
        if (this.format.equals("json")) {
            jamonWriter.write("\n        [");
            for (MonitoredTask task : tasks) {
                if (first) {
                    first = false;
                } else {
                    jamonWriter.write(",");
                }
                Escaping.HTML.write(StandardEmitter.valueOf((String)task.toJSON()), jamonWriter);
            }
            jamonWriter.write("]\n    ");
        } else {
            jamonWriter.write("\n        ");
            if (tasks.isEmpty()) {
                jamonWriter.write("\n            <p>No tasks currently running on this node.</p>\n        ");
            } else {
                jamonWriter.write("\n            <table class=\"table table-striped\">\n                <tr>\n                      <th>Start Time</th>\n                      <th>Description</th>\n                      <th>State</th>\n                      <th>Status</th>\n                </tr>\n                ");
                for (MonitoredTask task : tasks) {
                    jamonWriter.write("\n                    <tr class=\"");
                    this.__jamon_innerUnit__stateCss(jamonWriter, task.getState());
                    jamonWriter.write("\">\n                      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(task.getStartTime())), jamonWriter);
                    jamonWriter.write("</td>\n                      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)task.getDescription()), jamonWriter);
                    jamonWriter.write("</td>\n                      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((Object)((Object)task.getState())), jamonWriter);
                    jamonWriter.write("\n                          (since ");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.formatTimeDiff((long)now, (long)task.getStateTime())), jamonWriter);
                    jamonWriter.write(" ago)\n                      </td>\n                      <td>");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)task.getStatus()), jamonWriter);
                    jamonWriter.write("\n                          (since ");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.formatTimeDiff((long)now, (long)task.getStatusTime())), jamonWriter);
                    jamonWriter.write("\n                          ago)</td>\n                    </tr>\n                ");
                }
                jamonWriter.write("\n            </table>\n        ");
            }
            jamonWriter.write("\n    ");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__stateCss(Writer jamonWriter, MonitoredTask.State state) throws IOException {
        if (state == MonitoredTask.State.COMPLETE) {
            jamonWriter.write("alert alert-success");
        } else if (state == MonitoredTask.State.ABORTED) {
            jamonWriter.write("alert alert-error");
        }
    }
}

